/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.queue.processor;

import com.tangosol.internal.net.queue.model.QueueKey;
import com.tangosol.internal.net.queue.model.QueueOfferResult;
import com.tangosol.internal.net.queue.processor.AbstractQueueProcessor;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.EvolvablePortableObject;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.util.Binary;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.InvocableMap;
import jakarta.json.bind.annotation.JsonbProperty;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class QueueOffer<E>
extends AbstractQueueProcessor<QueueKey, E, QueueOfferResult>
implements EvolvablePortableObject,
ExternalizableLite {
    public static final int IMPL_VERSION = 1;
    @JsonbProperty(value="binary")
    private Binary m_binary;
    @JsonbProperty(value="value")
    private E m_oValue;

    public QueueOffer() {
    }

    public QueueOffer(E oValue) {
        this.m_oValue = oValue;
        this.m_binary = null;
    }

    public QueueOffer(Binary binary) {
        this.m_oValue = null;
        this.m_binary = binary;
    }

    @Override
    public QueueOfferResult process(InvocableMap.Entry<QueueKey, E> entry) {
        if (entry.getKey().getId() < 0L) {
            return this.offerToHead(entry.asBinaryEntry(), this.m_binary, this.m_oValue);
        }
        return this.offerToTail(entry.asBinaryEntry(), this.m_binary, this.m_oValue);
    }

    @Override
    public int getImplVersion() {
        return 1;
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_binary = in.readBinary(0);
        this.m_oValue = in.readObject(1);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeBinary(0, this.m_binary);
        out.writeObject(1, this.m_oValue);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_binary = (Binary)ExternalizableHelper.readObject(in);
        this.m_oValue = ExternalizableHelper.readObject(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject(out, this.m_binary);
        ExternalizableHelper.writeObject(out, this.m_oValue);
    }
}

