/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.queue.processor;

import com.oracle.coherence.common.base.Exceptions;
import com.oracle.coherence.common.base.Logger;
import com.tangosol.internal.net.queue.extractor.QueueKeyExtractor;
import com.tangosol.internal.net.queue.model.QueueKey;
import com.tangosol.internal.net.queue.model.QueueOfferResult;
import com.tangosol.internal.net.queue.model.QueuePollResult;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.EvolvablePortableObject;
import com.tangosol.net.BackingMapContext;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.net.cache.BinaryMemoryCalculator;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.Converter;
import com.tangosol.util.MapIndex;
import com.tangosol.util.processor.AbstractProcessor;

public abstract class AbstractQueueProcessor<K, V, R>
extends AbstractProcessor<K, V, R>
implements EvolvablePortableObject,
ExternalizableLite {
    protected transient int m_nDataVersion;
    protected transient Binary m_binFuture;

    protected QueuePollResult pollFromHead(BinaryEntry<QueueKey, V> entry) {
        BinaryEntry<QueueKey, V> entryHead = AbstractQueueProcessor.enlistHeadEntry(entry, false);
        if (entryHead != null) {
            Binary binResult = entryHead.getBinaryValue();
            entryHead.remove(false);
            return new QueuePollResult(((QueueKey)entryHead.getKey()).getId(), binResult);
        }
        return QueuePollResult.empty();
    }

    protected QueuePollResult pollFromTail(BinaryEntry<QueueKey, V> entry) {
        BinaryEntry<QueueKey, V> entryTail = AbstractQueueProcessor.enlistTailEntry(entry, false);
        if (entryTail != null) {
            Binary binResult = entryTail.getBinaryValue();
            entryTail.remove(false);
            return new QueuePollResult(((QueueKey)entryTail.getKey()).getId(), binResult);
        }
        return QueuePollResult.empty();
    }

    protected QueuePollResult peekAtHead(BinaryEntry<QueueKey, V> entry) {
        BinaryEntry<QueueKey, V> entryHead = AbstractQueueProcessor.enlistHeadEntry(entry, true);
        if (entryHead != null && entryHead.isPresent()) {
            Binary binResult = entryHead.getBinaryValue();
            return new QueuePollResult(((QueueKey)entryHead.getKey()).getId(), binResult);
        }
        return QueuePollResult.empty();
    }

    protected QueuePollResult peekAtTail(BinaryEntry<QueueKey, V> entry) {
        BinaryEntry<QueueKey, V> entryTail = AbstractQueueProcessor.enlistTailEntry(entry, true);
        if (entryTail != null && entryTail.isPresent()) {
            Binary binResult = entryTail.getBinaryValue();
            return new QueuePollResult(((QueueKey)entryTail.getKey()).getId(), binResult);
        }
        return QueuePollResult.empty();
    }

    public QueueOfferResult offerToTail(BinaryEntry<QueueKey, ?> entry, Binary binary, Object oValue) {
        BackingMapContext context = entry.getBackingMapContext();
        Binary binaryValue = this.ensureBinaryValue(context, binary, oValue);
        if (this.exceedsSizeLimit(entry, entry.getBinaryKey(), binaryValue)) {
            return new QueueOfferResult(((QueueKey)entry.getKey()).getId(), 2);
        }
        QueueKeyExtractor.QueueIndex index = AbstractQueueProcessor.assertQueueIndex(entry);
        long nTail = index.nextTailOffer();
        QueueKey keyNext = new QueueKey(((QueueKey)entry.getKey()).getHash(), nTail);
        BackingMapManagerContext mgrContext = context.getManagerContext();
        Converter converter = mgrContext.getKeyToInternalConverter();
        Binary binKeyNext = (Binary)converter.convert(keyNext);
        BinaryEntry entryTail = (BinaryEntry)context.getBackingMapEntry(binKeyNext);
        while (entryTail.isPresent()) {
            keyNext = keyNext.next();
            binKeyNext = (Binary)converter.convert(keyNext);
            entryTail = (BinaryEntry)context.getBackingMapEntry(binKeyNext);
        }
        entryTail.updateBinaryValue(binaryValue);
        return new QueueOfferResult(keyNext.getId(), 1);
    }

    public QueueOfferResult offerToHead(BinaryEntry<QueueKey, ?> entry, Binary binary, Object oValue) {
        BackingMapContext context = entry.getBackingMapContext();
        Binary binaryValue = this.ensureBinaryValue(context, binary, oValue);
        if (this.exceedsSizeLimit(entry, entry.getBinaryKey(), binaryValue)) {
            return new QueueOfferResult(((QueueKey)entry.getKey()).getId(), 2);
        }
        QueueKeyExtractor.QueueIndex index = AbstractQueueProcessor.assertQueueIndex(entry);
        long nHead = index.nextHeadOffer();
        QueueKey keyPrev = new QueueKey(((QueueKey)entry.getKey()).getHash(), nHead);
        BackingMapManagerContext mgrContext = context.getManagerContext();
        Converter converter = mgrContext.getKeyToInternalConverter();
        Binary binKeyPrev = (Binary)converter.convert(keyPrev);
        BinaryEntry entryHead = (BinaryEntry)context.getBackingMapEntry(binKeyPrev);
        while (entryHead.isPresent()) {
            keyPrev = keyPrev.prev();
            binKeyPrev = (Binary)converter.convert(keyPrev);
            entryHead = (BinaryEntry)context.getBackingMapEntry(binKeyPrev);
        }
        entryHead.updateBinaryValue(binaryValue);
        return new QueueOfferResult(keyPrev.getId(), 1);
    }

    public Binary ensureBinaryValue(BackingMapContext context, Binary binary, Object oValue) {
        if (binary == null) {
            return (Binary)context.getManagerContext().getValueToInternalConverter().convert(oValue);
        }
        return binary;
    }

    public boolean exceedsSizeLimit(BinaryEntry<QueueKey, ?> entry, Binary binKey, Binary binValue) {
        QueueKeyExtractor.QueueIndex index = AbstractQueueProcessor.assertQueueIndex(entry);
        long cMaxBytes = index.getMaxQueueSize();
        long cCurrentBytes = index.getQueueSize();
        return this.exceedsSizeLimit(binKey, binValue, cMaxBytes, cCurrentBytes);
    }

    public boolean exceedsSizeLimit(BinaryEntry<? extends QueueKey, ?> entry, Binary binKey, Binary binValue, long cMaxBytes) {
        QueueKeyExtractor.QueueIndex index = AbstractQueueProcessor.assertQueueIndex(entry);
        long cCurrentBytes = index.getQueueSize();
        return this.exceedsSizeLimit(binKey, binValue, cMaxBytes, cCurrentBytes);
    }

    protected long entrySize(Binary binKey, Binary binValue) {
        return (long)(binKey.length() + binValue.length()) + (long)BinaryMemoryCalculator.SIZE_BINARY * 2L + (long)BinaryMemoryCalculator.SIZE_ENTRY;
    }

    protected boolean exceedsSizeLimit(Binary binKey, Binary binValue, long cMaxBytes, long cCurrentBytes) {
        long cBytes = cCurrentBytes + this.entrySize(binKey, binValue);
        return cBytes > cMaxBytes;
    }

    protected static <E> BinaryEntry<QueueKey, E> enlistHeadEntry(BinaryEntry<QueueKey, E> entry, boolean fReadOnly) {
        BackingMapContext context = entry.getBackingMapContext();
        QueueKeyExtractor.QueueIndex index = AbstractQueueProcessor.assertQueueIndex(entry);
        Object oHeadKey = index.getHeadBinaryKey(0L);
        if (oHeadKey != null) {
            try {
                return fReadOnly ? (BinaryEntry)context.getReadOnlyEntry(oHeadKey) : (BinaryEntry)context.getBackingMapEntry(oHeadKey);
            }
            catch (Exception e) {
                Object o = oHeadKey;
                if (oHeadKey instanceof Binary) {
                    o = context.getManagerContext().getValueFromInternalConverter().convert(o);
                }
                Logger.err("Error enlisting head entry entryKey=" + String.valueOf(entry.getKey()) + " key=" + String.valueOf(o));
                throw Exceptions.ensureRuntimeException(e);
            }
        }
        return null;
    }

    protected static <E> BinaryEntry<QueueKey, E> enlistTailEntry(BinaryEntry<QueueKey, E> entry, boolean fReadOnly) {
        BackingMapContext context = entry.getBackingMapContext();
        QueueKeyExtractor.QueueIndex index = AbstractQueueProcessor.assertQueueIndex(entry);
        Object oTailKey = index.getTailBinaryKey(0L);
        if (oTailKey != null) {
            try {
                return fReadOnly ? (BinaryEntry)context.getReadOnlyEntry(oTailKey) : (BinaryEntry)context.getBackingMapEntry(oTailKey);
            }
            catch (Exception e) {
                Object o = oTailKey;
                if (o instanceof Binary) {
                    o = context.getManagerContext().getValueFromInternalConverter().convert(o);
                }
                Logger.err("Error enlisting tail entry entryKey=" + String.valueOf(entry.getKey()) + " key=" + String.valueOf(o));
                throw Exceptions.ensureRuntimeException(e);
            }
        }
        return null;
    }

    protected static QueueKeyExtractor.QueueIndex assertQueueIndex(BinaryEntry<?, ?> entry) {
        MapIndex index = entry.getIndexMap().get(QueueKeyExtractor.INSTANCE);
        if (index instanceof QueueKeyExtractor.QueueIndex) {
            return (QueueKeyExtractor.QueueIndex)index;
        }
        String sCache = entry.getBackingMapContext().getCacheName();
        throw new IllegalStateException("The index on cache " + sCache + " foe extractor " + String.valueOf(QueueKeyExtractor.INSTANCE) + " must be an instance of " + String.valueOf(QueueKeyExtractor.QueueIndex.class) + " but is a " + String.valueOf(index.getClass()));
    }

    @Override
    public int getDataVersion() {
        return this.m_nDataVersion;
    }

    @Override
    public void setDataVersion(int nVersion) {
        this.m_nDataVersion = nVersion;
    }

    @Override
    public Binary getFutureData() {
        return this.m_binFuture;
    }

    @Override
    public void setFutureData(Binary binFuture) {
        this.m_binFuture = binFuture;
    }
}

