/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.queue.paged;

import com.tangosol.internal.net.queue.paged.QueueInfo;
import com.tangosol.internal.net.queue.paged.QueueVersionInfo;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.processor.AbstractProcessor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class TailIncrementProcessor
extends AbstractProcessor<String, QueueInfo, QueueInfo>
implements ExternalizableLite,
PortableObject {
    protected int m_expectedValue;
    protected long m_expectedVersion;
    protected boolean m_fUpdateValue;

    public TailIncrementProcessor() {
    }

    public TailIncrementProcessor(int expectedValue, long expectedVersion) {
        this(expectedValue, expectedVersion, true);
    }

    public TailIncrementProcessor(int expectedValue, long expectedVersion, boolean updateValue) {
        this.m_expectedValue = expectedValue;
        this.m_expectedVersion = expectedVersion;
        this.m_fUpdateValue = updateValue;
    }

    @Override
    public QueueInfo process(InvocableMap.Entry<String, QueueInfo> entry) {
        QueueInfo info = entry.getValue();
        if (info.isQueueFull()) {
            return info;
        }
        QueueVersionInfo versionInfo = info.getVersion();
        long tailVersion = versionInfo.getTailOfferVersion();
        int tailValue = info.getTailBucketId();
        if (tailValue != this.m_expectedValue || tailVersion != this.m_expectedVersion) {
            return info;
        }
        tailValue = tailValue == info.getMaxBucketId() ? 0 : ++tailValue;
        if (info.getHeadBucketId() == tailValue) {
            info.setQueueFull(true);
            if (this.m_fUpdateValue) {
                entry.setValue(info);
            }
            return info;
        }
        if (tailValue == 0) {
            versionInfo.incrementTailOfferVersion();
        }
        info.setTailBucketId(tailValue);
        if (this.m_fUpdateValue) {
            entry.setValue(info);
        }
        return info;
    }

    public void setUpdateValue(boolean fUpdateValue) {
        this.m_fUpdateValue = fUpdateValue;
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_expectedValue = in.readInt(0);
        this.m_expectedVersion = in.readLong(1);
        this.m_fUpdateValue = in.readBoolean(2);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeInt(0, this.m_expectedValue);
        out.writeLong(1, this.m_expectedVersion);
        out.writeBoolean(2, this.m_fUpdateValue);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_expectedValue = ExternalizableHelper.readInt(in);
        this.m_expectedVersion = ExternalizableHelper.readLong(in);
        this.m_fUpdateValue = in.readBoolean();
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeInt(out, this.m_expectedValue);
        ExternalizableHelper.writeLong(out, this.m_expectedVersion);
        out.writeBoolean(this.m_fUpdateValue);
    }
}

