/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.queue.paged;

import com.tangosol.internal.net.queue.paged.Bucket;
import com.tangosol.internal.net.queue.paged.PagedQueueCacheNames;
import com.tangosol.internal.net.queue.paged.PagedQueueKey;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.BackingMapContext;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.Converter;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.processor.AbstractProcessor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class RemoveBucketElementProcessor
extends AbstractProcessor<Integer, Bucket, Boolean>
implements ExternalizableLite,
PortableObject {
    protected Object m_element;
    protected boolean m_fHeadFirst;

    public RemoveBucketElementProcessor() {
    }

    public RemoveBucketElementProcessor(Object element) {
        this(element, true);
    }

    public RemoveBucketElementProcessor(Object element, boolean fHeadFirst) {
        this.m_element = element;
        this.m_fHeadFirst = fHeadFirst;
    }

    @Override
    public Boolean process(InvocableMap.Entry<Integer, Bucket> entry) {
        int endId;
        if (!entry.isPresent()) {
            return false;
        }
        BinaryEntry binaryEntry = (BinaryEntry)entry;
        BackingMapManagerContext context = binaryEntry.getContext();
        BackingMapContext backingMapContext = binaryEntry.getBackingMapContext();
        String elementCacheName = PagedQueueCacheNames.Elements.getCacheName(backingMapContext);
        BackingMapContext elementMapContext = context.getBackingMapContext(elementCacheName);
        Converter keyConverter = context.getKeyToInternalConverter();
        Bucket bucket = entry.getValue();
        int headId = bucket.getHead();
        int tailId = bucket.getTail();
        int startId = this.m_fHeadFirst ? headId : tailId;
        int n = endId = this.m_fHeadFirst ? tailId + 1 : headId - 1;
        if (startId != -1) {
            PagedQueueKey queueKey = new PagedQueueKey(bucket.getId(), startId);
            int i = startId;
            while (i != endId) {
                queueKey.setElementId(i);
                Binary binaryKey = (Binary)keyConverter.convert(queueKey);
                BinaryEntry elementEntry = (BinaryEntry)elementMapContext.getBackingMapEntry(binaryKey);
                if (elementEntry.isPresent() && RemoveBucketElementProcessor.equals(this.m_element, elementEntry.getValue())) {
                    elementEntry.remove(false);
                    return true;
                }
                if (this.m_fHeadFirst) {
                    i = i != Integer.MAX_VALUE ? i + 1 : 0;
                    continue;
                }
                i = i != 0 ? i - 1 : Integer.MAX_VALUE;
            }
        }
        return false;
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_element = in.readObject(0);
        this.m_fHeadFirst = in.readBoolean(1);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeObject(0, this.m_element);
        out.writeBoolean(1, this.m_fHeadFirst);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_element = ExternalizableHelper.readObject(in);
        this.m_fHeadFirst = in.readBoolean();
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeObject(out, this.m_element);
        out.writeBoolean(this.m_fHeadFirst);
    }
}

