/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.queue.paged;

import com.tangosol.internal.net.queue.paged.BasePollPeekProcessor;
import com.tangosol.internal.net.queue.paged.Bucket;
import com.tangosol.internal.net.queue.paged.PagedQueueKey;
import com.tangosol.internal.net.queue.paged.QueueVersionInfo;
import com.tangosol.internal.net.queue.paged.Utils;

public class QueuePollPeekHeadProcessor
extends BasePollPeekProcessor {
    public QueuePollPeekHeadProcessor() {
    }

    public QueuePollPeekHeadProcessor(boolean fPoll, QueueVersionInfo version) {
        super(fPoll, version);
    }

    @Override
    protected boolean isValidVersion(QueueVersionInfo version) {
        return version.getHeadPollVersion() == this.m_version.getHeadPollVersion();
    }

    @Override
    protected PagedQueueKey firstQueueKey(Bucket bucket) {
        return new PagedQueueKey(bucket.getId(), bucket.getHead());
    }

    @Override
    protected PagedQueueKey nextQueueKey(Bucket bucket, PagedQueueKey queueKey) {
        int elementId = queueKey.getElementId();
        if (elementId == bucket.getTail()) {
            return null;
        }
        queueKey.setElementId(Utils.unsignedIncrement(elementId));
        return queueKey;
    }

    @Override
    protected void poll(Bucket bucket, PagedQueueKey key) {
        int elementId = key.getElementId();
        if (bucket.getTail() == elementId) {
            bucket.markEmpty();
        } else {
            bucket.setHead(Utils.unsignedIncrement(elementId));
        }
    }

    @Override
    protected void notifyRemovingEmptyBucket(Bucket bucket) {
        bucket.getVersion().incrementHeadPollVersion();
        bucket.getVersion().incrementTailOfferVersion();
    }
}

