/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.queue.paged;

import com.tangosol.internal.net.queue.model.QueueOfferResult;
import com.tangosol.internal.net.queue.paged.BasePagedQueueProcessor;
import com.tangosol.internal.net.queue.paged.Bucket;
import com.tangosol.internal.net.queue.paged.PagedQueueCacheNames;
import com.tangosol.internal.net.queue.paged.PagedQueueKey;
import com.tangosol.internal.net.queue.paged.QueueVersionInfo;
import com.tangosol.internal.net.queue.paged.Utils;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.BackingMapContext;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.Converter;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.InvocableMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;

public class QueueOfferTailProcessor
extends BasePagedQueueProcessor<QueueOfferResult>
implements ExternalizableLite,
PortableObject {
    public static final int POF_IMPL_VERSION = 0;
    protected Binary m_binElement;
    protected int m_nMaxBucketSize;
    protected QueueVersionInfo m_bucketVersion;

    public QueueOfferTailProcessor() {
    }

    public QueueOfferTailProcessor(Binary binElement, QueueVersionInfo version, int nMaxBucketSize) {
        this.m_binElement = Objects.requireNonNull(binElement);
        this.m_bucketVersion = version;
        this.m_nMaxBucketSize = nMaxBucketSize;
    }

    @Override
    public final QueueOfferResult process(InvocableMap.Entry<Integer, Bucket> entry) {
        int nResult;
        int tailId;
        BinaryEntry<Integer, Bucket> binaryEntry = entry.asBinaryEntry();
        Bucket bucket = this.ensureBucket(binaryEntry, this.m_nMaxBucketSize, this.m_bucketVersion);
        if (!bucket.isAcceptingOffers() || !this.isValidVersion(bucket)) {
            return new QueueOfferResult(0L, 3);
        }
        BackingMapManagerContext context = binaryEntry.getContext();
        BackingMapContext backingMapContext = binaryEntry.getBackingMapContext();
        String sElementCacheName = PagedQueueCacheNames.Elements.getCacheName(backingMapContext);
        BackingMapContext elementMapContext = context.getBackingMapContext(sElementCacheName);
        int bucketId = bucket.getId();
        int headId = bucket.getHead();
        if (headId != (tailId = Utils.unsignedIncrement(bucket.getTail()))) {
            Converter keyConverter = context.getKeyToInternalConverter();
            PagedQueueKey key = new PagedQueueKey(bucketId, tailId);
            Binary binKey = (Binary)keyConverter.convert(key);
            BinaryEntry elementEntry = (BinaryEntry)elementMapContext.getBackingMapEntry(binKey);
            long nSize = this.entrySize(binKey, this.m_binElement);
            if (bucket.increaseBytesUsed(nSize)) {
                elementEntry.updateBinaryValue(this.m_binElement);
                bucket.setTail(tailId);
                nResult = 1;
            } else {
                bucket.setAcceptingOffers(false);
                nResult = 3;
            }
        } else {
            bucket.setAcceptingOffers(false);
            nResult = 3;
        }
        entry.setValue(bucket);
        BinaryEntry<Integer, QueueVersionInfo> versionBinaryEntry = this.getVersionBinaryEntry(binaryEntry);
        if (versionBinaryEntry.isPresent()) {
            versionBinaryEntry.remove(true);
        }
        return new QueueOfferResult(bucket.m_id, bucket.m_tail, nResult);
    }

    protected boolean isValidVersion(Bucket bucket) {
        QueueVersionInfo versionInfo = bucket.getVersion();
        return versionInfo.getTailOfferVersion() == this.m_bucketVersion.getTailOfferVersion();
    }

    @Override
    public int getImplVersion() {
        return 0;
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_nMaxBucketSize = in.readInt(0);
        this.m_bucketVersion = (QueueVersionInfo)in.readObject(1);
        this.m_binElement = in.readBinary(2);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeInt(0, this.m_nMaxBucketSize);
        out.writeObject(1, this.m_bucketVersion);
        out.writeBinary(2, this.m_binElement);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_nMaxBucketSize = ExternalizableHelper.readInt(in);
        this.m_bucketVersion = (QueueVersionInfo)ExternalizableHelper.readObject(in);
        this.m_binElement = (Binary)ExternalizableHelper.readObject(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeInt(out, this.m_nMaxBucketSize);
        ExternalizableHelper.writeObject(out, this.m_bucketVersion);
        ExternalizableHelper.writeObject(out, this.m_binElement);
    }
}

