/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.queue.paged;

import com.tangosol.internal.net.queue.paged.QueueVersionInfo;
import com.tangosol.io.AbstractEvolvable;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.EvolvablePortableObject;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;

public class QueueInfo
extends AbstractEvolvable
implements ExternalizableLite,
EvolvablePortableObject {
    public static final int POF_VERSION = 0;
    protected String m_sQueueName;
    protected int m_headBucketId = 0;
    protected int m_tailBucketId = 0;
    protected int m_bucketSize = 0xA00000;
    protected int m_maxBucketId = Integer.MAX_VALUE;
    protected QueueVersionInfo m_version;
    protected boolean m_fQueueFull = false;

    public QueueInfo() {
        this(null);
    }

    public QueueInfo(String sQueueName) {
        this(sQueueName, 0, 0, new QueueVersionInfo());
    }

    public QueueInfo(String sQueueName, int nHead, int nTail, QueueVersionInfo version) {
        this.m_sQueueName = sQueueName;
        this.m_headBucketId = nHead;
        this.m_tailBucketId = nTail;
        this.m_version = version;
    }

    public String getsQueueName() {
        return this.m_sQueueName;
    }

    public int getHeadBucketId() {
        return this.m_headBucketId;
    }

    public void setHeadBucketId(int headBucketId) {
        this.m_headBucketId = headBucketId;
    }

    public int getTailBucketId() {
        return this.m_tailBucketId;
    }

    public void setTailBucketId(int tailBucketId) {
        this.m_tailBucketId = tailBucketId;
    }

    public int getBucketSize() {
        return this.m_bucketSize;
    }

    public void setBucketSize(int bucketSize) {
        this.m_bucketSize = bucketSize;
    }

    public int getMaxBucketId() {
        return this.m_maxBucketId;
    }

    public void setMaxBucketId(int maxBucketId) {
        this.m_maxBucketId = maxBucketId;
    }

    public QueueVersionInfo getVersion() {
        return this.m_version;
    }

    public boolean isQueueFull() {
        return this.m_fQueueFull;
    }

    public void setQueueFull(boolean fQueueFull) {
        this.m_fQueueFull = fQueueFull;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueueInfo queueInfo = (QueueInfo)o;
        return Objects.equals(this.m_sQueueName, queueInfo.m_sQueueName);
    }

    public int hashCode() {
        return this.m_sQueueName != null ? this.m_sQueueName.hashCode() : 0;
    }

    public String toString() {
        return "QueueInfo[name='" + this.m_sQueueName + "', head=" + this.m_headBucketId + ", tail=" + this.m_tailBucketId + ", maxBucketID=" + this.m_maxBucketId + ", bucketSize=" + this.m_bucketSize + ", version=" + String.valueOf(this.m_version) + "]";
    }

    @Override
    public int getImplVersion() {
        return 0;
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_sQueueName = in.readString(0);
        this.m_headBucketId = in.readInt(1);
        this.m_tailBucketId = in.readInt(2);
        this.m_bucketSize = in.readInt(3);
        this.m_maxBucketId = in.readInt(4);
        this.m_version = (QueueVersionInfo)in.readObject(5);
        this.m_fQueueFull = in.readBoolean(6);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeString(0, this.m_sQueueName);
        out.writeInt(1, this.m_headBucketId);
        out.writeInt(2, this.m_tailBucketId);
        out.writeInt(3, this.m_bucketSize);
        out.writeInt(4, this.m_maxBucketId);
        out.writeObject(5, this.m_version);
        out.writeBoolean(6, this.m_fQueueFull);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_sQueueName = ExternalizableHelper.readSafeUTF(in);
        this.m_headBucketId = ExternalizableHelper.readInt(in);
        this.m_tailBucketId = ExternalizableHelper.readInt(in);
        this.m_bucketSize = ExternalizableHelper.readInt(in);
        this.m_maxBucketId = ExternalizableHelper.readInt(in);
        this.m_version = (QueueVersionInfo)ExternalizableHelper.readObject(in);
        this.m_fQueueFull = in.readBoolean();
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeSafeUTF(out, this.m_sQueueName);
        ExternalizableHelper.writeInt(out, this.m_headBucketId);
        ExternalizableHelper.writeInt(out, this.m_tailBucketId);
        ExternalizableHelper.writeInt(out, this.m_bucketSize);
        ExternalizableHelper.writeInt(out, this.m_maxBucketId);
        ExternalizableHelper.writeObject(out, this.m_version);
        out.writeBoolean(this.m_fQueueFull);
    }
}

