/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.queue.paged;

import com.tangosol.internal.net.queue.paged.Bucket;
import com.tangosol.internal.net.queue.paged.PagedQueueCacheNames;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.BackingMapContext;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.InvocableMap;
import com.tangosol.util.MapIndex;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.ValueExtractor;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class PeekWholeBucketAggregator<K, V>
implements InvocableMap.StreamingAggregator<K, V, List<Binary>, List<Binary>>,
ExternalizableLite,
PortableObject {
    protected boolean m_fHeadFirst;
    protected transient List<Binary> m_listResult = null;

    public PeekWholeBucketAggregator() {
        this(true);
    }

    public PeekWholeBucketAggregator(boolean fHeadFirst) {
        this.m_fHeadFirst = fHeadFirst;
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_fHeadFirst = in.readBoolean(0);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeBoolean(0, this.m_fHeadFirst);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_fHeadFirst = in.readBoolean();
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        out.writeBoolean(this.m_fHeadFirst);
    }

    @Override
    public InvocableMap.StreamingAggregator<K, V, List<Binary>, List<Binary>> supply() {
        return new PeekWholeBucketAggregator<K, V>(this.m_fHeadFirst);
    }

    @Override
    public boolean accumulate(InvocableMap.Entry<? extends K, ? extends V> entry) {
        BinaryEntry<K, V> binaryEntry = entry.asBinaryEntry();
        if (binaryEntry.isPresent()) {
            Integer bucketId = (Integer)binaryEntry.getKey();
            BackingMapManagerContext context = binaryEntry.getContext();
            BackingMapContext backingMapContext = binaryEntry.getBackingMapContext();
            String elementCacheName = PagedQueueCacheNames.Elements.getCacheName(backingMapContext);
            BackingMapContext elementMapContext = context.getBackingMapContext(elementCacheName);
            ObservableMap backingMap = elementMapContext.getBackingMap();
            Map<ValueExtractor, MapIndex> indexes = elementMapContext.getIndexMap(binaryEntry.getKeyPartition());
            this.m_listResult = Bucket.findElementsForBucketId(bucketId, backingMap, indexes, context, this.m_fHeadFirst);
        }
        return true;
    }

    @Override
    public boolean combine(List<Binary> partialResult) {
        if (partialResult != null) {
            if (this.m_listResult == null) {
                this.m_listResult = new ArrayList<Binary>();
            }
            this.m_listResult.addAll(partialResult);
        }
        return true;
    }

    @Override
    public List<Binary> getPartialResult() {
        return this.m_listResult;
    }

    @Override
    public List<Binary> finalizeResult() {
        return this.m_listResult;
    }
}

