/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.queue.paged;

import com.tangosol.net.BackingMapContext;
import com.tangosol.net.CacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.net.NamedMap;
import com.tangosol.net.cache.NearCache;
import com.tangosol.util.NullImplementation;

public enum PagedQueueCacheNames {
    Buckets("$buckets", true),
    Elements("", true),
    Version("$versions", false),
    Info("$info", false);

    private final String m_sSuffix;
    private final boolean m_fPassThru;

    private PagedQueueCacheNames(String sSuffix, boolean fPassThru) {
        this.m_sSuffix = sSuffix;
        this.m_fPassThru = fPassThru;
    }

    public String suffix() {
        return this.m_sSuffix;
    }

    public String getCacheName(NamedMap<?, ?> map) {
        return this.getCacheName(map.getName());
    }

    public String getCacheName(BackingMapContext ctx) {
        return this.getCacheName(ctx.getCacheName());
    }

    public String getCacheName(String sCacheName) {
        if (sCacheName.endsWith(PagedQueueCacheNames.Buckets.m_sSuffix)) {
            return sCacheName.substring(0, sCacheName.length() - PagedQueueCacheNames.Buckets.m_sSuffix.length()) + this.m_sSuffix;
        }
        if (sCacheName.endsWith(PagedQueueCacheNames.Version.m_sSuffix)) {
            return sCacheName.substring(0, sCacheName.length() - PagedQueueCacheNames.Version.m_sSuffix.length()) + this.m_sSuffix;
        }
        if (sCacheName.endsWith(PagedQueueCacheNames.Info.m_sSuffix)) {
            return sCacheName.substring(0, sCacheName.length() - PagedQueueCacheNames.Info.m_sSuffix.length()) + this.m_sSuffix;
        }
        return sCacheName + this.m_sSuffix;
    }

    public boolean isPassThru() {
        return this.m_fPassThru;
    }

    public <K, V> NamedMap<K, V> ensureBinaryMap(String sQueueName, CacheService cacheService) {
        NamedCache map;
        if (this.m_fPassThru) {
            map = cacheService.ensureCache(sQueueName + this.m_sSuffix, NullImplementation.getClassLoader());
        } else {
            ClassLoader loaderService = cacheService.getContextClassLoader();
            map = cacheService.ensureCache(sQueueName + this.m_sSuffix, loaderService);
        }
        if (map instanceof NearCache) {
            map = ((NearCache)map).getBackCache();
        }
        return map;
    }
}

