/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.queue.paged;

import com.tangosol.internal.net.queue.BaseNamedMapQueue;
import com.tangosol.internal.net.queue.PagedQueue;
import com.tangosol.internal.net.queue.model.QueueOfferResult;
import com.tangosol.internal.net.queue.model.QueuePollResult;
import com.tangosol.internal.net.queue.paged.Bucket;
import com.tangosol.internal.net.queue.paged.ClearQueueProcessor;
import com.tangosol.internal.net.queue.paged.HeadIncrementProcessor;
import com.tangosol.internal.net.queue.paged.InitialiseQueueInfoProcessor;
import com.tangosol.internal.net.queue.paged.PagedQueueCacheNames;
import com.tangosol.internal.net.queue.paged.PagedQueueKey;
import com.tangosol.internal.net.queue.paged.PeekWholeBucketAggregator;
import com.tangosol.internal.net.queue.paged.QueueInfo;
import com.tangosol.internal.net.queue.paged.QueueOfferTailProcessor;
import com.tangosol.internal.net.queue.paged.QueuePollPeekHeadProcessor;
import com.tangosol.internal.net.queue.paged.QueueVersionInfo;
import com.tangosol.internal.net.queue.paged.TailIncrementProcessor;
import com.tangosol.io.Serializer;
import com.tangosol.net.CacheService;
import com.tangosol.net.NamedCache;
import com.tangosol.util.Binary;
import com.tangosol.util.ExternalizableHelper;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class PagedNamedQueue<E>
extends BaseNamedMapQueue<PagedQueueKey, E>
implements PagedQueue<E> {
    protected NamedCache<String, QueueInfo> m_queueInfoCache;
    protected NamedCache<Integer, Bucket> m_bucketCache;
    protected NamedCache<?, ?> m_versionCache;
    protected NamedCache<PagedQueueKey, E> m_elementCache;
    protected QueueInfo m_queueInfo;

    public PagedNamedQueue(String sName, NamedCache<PagedQueueKey, E> cache) {
        super(sName, cache);
        CacheService cacheService = cache.getCacheService();
        String sCacheName = cache.getCacheName();
        ClassLoader loader = cache.getCacheService().getContextClassLoader();
        this.m_elementCache = cache;
        this.m_bucketCache = cacheService.ensureCache(PagedQueueCacheNames.Buckets.getCacheName(sCacheName), loader);
        this.m_queueInfoCache = cacheService.ensureCache(PagedQueueCacheNames.Info.getCacheName(sCacheName), loader);
        this.m_versionCache = cacheService.ensureCache(PagedQueueCacheNames.Version.getCacheName(sCacheName), loader);
        this.m_queueInfo = this.m_queueInfoCache.invoke(sName, this.instantateInitialiseQueueInfoProcessor());
        this.m_elementCache.addIndex(PagedQueueKey.BUCKET_ID_EXTRACTOR, true, null);
    }

    @Override
    public PagedQueueKey createKey(long id) {
        return new PagedQueueKey(this.m_keyHead.getHash(), id);
    }

    @Override
    public void clear() {
        this.m_bucketCache.invokeAll(new ClearQueueProcessor());
    }

    @Override
    public void release() {
        super.release();
        this.release(this.m_bucketCache);
        this.release(this.m_queueInfoCache);
        this.release(this.m_versionCache);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.destroy(this.m_bucketCache);
        this.destroy(this.m_queueInfoCache);
        this.destroy(this.m_versionCache);
    }

    @Override
    public Iterator<E> iterator() {
        if (this.size() == 0) {
            return Collections.emptyIterator();
        }
        return new QueueIterator(this, this.m_queueInfo.getMaxBucketId());
    }

    @Override
    protected QueueOfferResult offerToTailInternal(E e) {
        if (e == null) {
            throw new NullPointerException("Null elements are not supported");
        }
        Binary binary = ExternalizableHelper.toBinary(e, this.getSerializer());
        int tailBucketId = this.m_queueInfo.getTailBucketId();
        QueueOfferTailProcessor processor = this.instantiateTailOfferProcessor(binary, this.m_queueInfo);
        QueueOfferResult result = this.m_bucketCache.invoke(tailBucketId, processor);
        while (result.getResult() == 3) {
            long version = this.m_queueInfo.getVersion().getTailOfferVersion();
            TailIncrementProcessor incrementor = new TailIncrementProcessor(tailBucketId, version);
            this.m_queueInfo = this.m_queueInfoCache.invoke(this.m_sName, incrementor);
            if (this.m_queueInfo.isQueueFull()) {
                this.peek();
                this.m_queueInfo = this.m_queueInfoCache.invoke(this.m_sName, incrementor);
                if (this.m_queueInfo.isQueueFull()) {
                    return new QueueOfferResult(0L, 2);
                }
            }
            tailBucketId = this.m_queueInfo.getTailBucketId();
            result = this.m_bucketCache.invoke(tailBucketId, processor);
        }
        return result;
    }

    @Override
    protected QueuePollResult pollFromHeadInternal() {
        Binary binary = this.pollOrPeekHead(true);
        return this.toResult(binary);
    }

    @Override
    protected QueuePollResult peekAtHeadInternal() {
        Binary binary = this.pollOrPeekHead(false);
        return this.toResult(binary);
    }

    protected QueuePollResult toResult(Binary binary) {
        return new QueuePollResult(1L, binary);
    }

    protected Binary pollOrPeekHead(boolean fPoll) {
        if (this.m_elementCache.isEmpty()) {
            return null;
        }
        int headId = this.m_queueInfo.getHeadBucketId();
        QueueVersionInfo version = this.m_queueInfo.getVersion();
        QueuePollPeekHeadProcessor processor = this.instantiatePollPeekHeadProcessor(fPoll, version);
        QueuePollResult result = this.m_bucketCache.invoke(headId, processor);
        while (result.getId() == -9223372036854775807L && !this.m_elementCache.isEmpty()) {
            HeadIncrementProcessor incrementor = new HeadIncrementProcessor(headId, version);
            this.m_queueInfo = this.m_queueInfoCache.invoke(this.m_sName, incrementor);
            version = this.m_queueInfo.getVersion();
            headId = this.m_queueInfo.getHeadBucketId();
            processor.setVersion(version);
            result = this.m_bucketCache.invoke(headId, processor);
        }
        return result.getBinaryElement();
    }

    protected InitialiseQueueInfoProcessor instantateInitialiseQueueInfoProcessor() {
        return InitialiseQueueInfoProcessor.INSTANCE;
    }

    protected QueueOfferTailProcessor instantiateTailOfferProcessor(Binary binElement, QueueInfo queueInfo) {
        QueueVersionInfo version = queueInfo.getVersion();
        int bucketSize = queueInfo.getBucketSize();
        return new QueueOfferTailProcessor(binElement, version, bucketSize);
    }

    protected QueuePollPeekHeadProcessor instantiatePollPeekHeadProcessor(boolean fPoll, QueueVersionInfo version) {
        return new QueuePollPeekHeadProcessor(fPoll, version);
    }

    protected Iterator<Binary> peekAtBucket(int bucketId, boolean fHeadFirst) {
        List results = (List)this.m_bucketCache.aggregate(Collections.singleton(bucketId), new PeekWholeBucketAggregator(fHeadFirst));
        if (results == null || results.isEmpty()) {
            return null;
        }
        return results.iterator();
    }

    protected int refreshHeadBucketId() {
        this.m_queueInfo = this.m_queueInfoCache.invoke(this.m_sName, this.instantateInitialiseQueueInfoProcessor());
        return this.m_queueInfo.getHeadBucketId();
    }

    protected int refreshTailBucketId() {
        this.m_queueInfo = this.m_queueInfoCache.invoke(this.m_sName, this.instantateInitialiseQueueInfoProcessor());
        return this.m_queueInfo.getTailBucketId();
    }

    protected int findNextBucketId(int bucketId) {
        bucketId = bucketId == this.m_queueInfo.getMaxBucketId() ? 0 : ++bucketId;
        return this.isValidBucketId(bucketId) ? bucketId : -1;
    }

    protected int findPreviousBucketId(int bucketId) {
        bucketId = bucketId == 0 ? this.m_queueInfo.getMaxBucketId() : --bucketId;
        return this.isValidBucketId(bucketId) ? bucketId : -1;
    }

    protected boolean isValidBucketId(int bucketId) {
        int tail;
        this.m_queueInfo = this.m_queueInfoCache.invoke(this.m_sName, this.instantateInitialiseQueueInfoProcessor());
        int head = this.m_queueInfo.getHeadBucketId();
        if (head <= (tail = this.m_queueInfo.getTailBucketId()) && bucketId >= head && bucketId <= tail) {
            return true;
        }
        return head > tail && (bucketId >= head || bucketId >= 0 && bucketId <= tail);
    }

    protected Serializer getSerializer() {
        return this.m_bucketCache.getCacheService().getSerializer();
    }

    protected void removeElement(int bucketId, int elementId) {
        this.m_elementCache.remove(new PagedQueueKey(bucketId, elementId));
    }

    protected static class QueueIterator<E>
    extends BaseQueueIterator<E> {
        public QueueIterator(PagedNamedQueue<E> queue, int maxBucketId) {
            super(queue, true, maxBucketId);
        }

        @Override
        protected void moveToNextBucketId() {
            this.m_currentBucketId = this.m_currentBucketId == this.m_maxBucketId ? 0 : ++this.m_currentBucketId;
        }
    }

    protected static class QueueReverseIterator<E>
    extends BaseQueueIterator<E> {
        public QueueReverseIterator(PagedNamedQueue<E> queue, int maxBucketId) {
            super(queue, false, maxBucketId);
        }

        @Override
        protected void moveToNextBucketId() {
            this.m_currentBucketId = this.m_currentBucketId == 0 ? this.m_maxBucketId : --this.m_currentBucketId;
        }
    }

    protected static abstract class BaseQueueIterator<E>
    implements Iterator<E> {
        protected PagedNamedQueue<E> m_queue;
        protected int m_maxBucketId;
        protected boolean m_fHeadFirst;
        protected int m_currentBucketId;
        protected Iterator<Binary> m_iterator;
        protected Serializer m_serializer;
        protected Binary m_currentBinary;

        public BaseQueueIterator(PagedNamedQueue<E> queue, boolean fHeadFirst, int maxBucketId) {
            this.m_queue = queue;
            this.m_fHeadFirst = fHeadFirst;
            this.m_maxBucketId = maxBucketId;
            if (queue.isEmpty()) {
                this.m_iterator = null;
            } else {
                this.m_currentBucketId = fHeadFirst ? this.m_queue.refreshHeadBucketId() : this.m_queue.refreshTailBucketId();
                this.m_serializer = this.m_queue.getSerializer();
                this.m_iterator = this.m_queue.peekAtBucket(this.m_currentBucketId, fHeadFirst);
            }
        }

        protected abstract void moveToNextBucketId();

        @Override
        public boolean hasNext() {
            while (this.m_iterator == null || !this.m_iterator.hasNext()) {
                this.moveToNextBucketId();
                this.m_iterator = this.m_queue.peekAtBucket(this.m_currentBucketId, this.m_fHeadFirst);
                while (this.m_iterator == null || !this.m_iterator.hasNext()) {
                    int n = this.m_currentBucketId = this.m_fHeadFirst ? this.m_queue.findNextBucketId(this.m_currentBucketId) : this.m_queue.findPreviousBucketId(this.m_currentBucketId);
                    if (this.m_currentBucketId == -1) {
                        return false;
                    }
                    this.m_iterator = this.m_queue.peekAtBucket(this.m_currentBucketId, this.m_fHeadFirst);
                }
            }
            return this.m_iterator != null && this.m_iterator.hasNext();
        }

        @Override
        public E next() {
            if (this.m_iterator != null) {
                if (!this.m_iterator.hasNext() && !this.hasNext()) {
                    throw new NoSuchElementException("Iterator is exhausted");
                }
                this.m_currentBinary = this.m_iterator.next();
                return (E)ExternalizableHelper.fromBinary(this.m_currentBinary, this.m_serializer);
            }
            throw new NoSuchElementException("Iterator is exhausted");
        }
    }
}

