/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.queue.paged;

import com.tangosol.internal.net.queue.paged.BasePagedQueueProcessor;
import com.tangosol.internal.net.queue.paged.Bucket;
import com.tangosol.internal.net.queue.paged.PagedQueueCacheNames;
import com.tangosol.internal.net.queue.paged.PagedQueueKey;
import com.tangosol.internal.net.queue.paged.QueueVersionInfo;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.InvocableMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class ClearQueueProcessor
extends BasePagedQueueProcessor<Void> {
    public static final int POF_IMPL_VERSION = 0;
    private boolean m_fSynthetic;

    public ClearQueueProcessor() {
    }

    public ClearQueueProcessor(boolean fSynthetic) {
        this.m_fSynthetic = fSynthetic;
    }

    @Override
    public Void process(InvocableMap.Entry<Integer, Bucket> entry) {
        if (entry.isPresent()) {
            Bucket bucket = entry.getValue();
            BinaryEntry<Integer, Bucket> binaryEntry = entry.asBinaryEntry();
            BinaryEntry<Integer, QueueVersionInfo> versionEntry = this.getVersionBinaryEntry(binaryEntry);
            versionEntry.setValue(bucket.getVersion());
            String cacheName = binaryEntry.getBackingMapContext().getCacheName();
            String elementsCacheName = PagedQueueCacheNames.Elements.getCacheName(cacheName);
            int nHead = bucket.getHead();
            int nTail = bucket.getTail();
            PagedQueueKey key = new PagedQueueKey(bucket.getId(), nHead);
            for (int i = nHead; i <= nTail; ++i) {
                key.setElementId(i);
                BinaryEntry elementEntry = binaryEntry.getAssociatedEntry(elementsCacheName, key);
                if (!elementEntry.isPresent()) continue;
                elementEntry.remove(this.m_fSynthetic);
            }
            entry.remove(this.m_fSynthetic);
        }
        return null;
    }

    @Override
    public int getImplVersion() {
        return 0;
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_fSynthetic = in.readBoolean(0);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeBoolean(0, this.m_fSynthetic);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_fSynthetic = in.readBoolean();
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        out.writeBoolean(this.m_fSynthetic);
    }
}

