/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.queue.paged;

import com.tangosol.internal.net.queue.paged.PagedQueueKey;
import com.tangosol.internal.net.queue.paged.QueueVersionInfo;
import com.tangosol.io.AbstractEvolvable;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.Serializer;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.util.Binary;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.Converter;
import com.tangosol.util.ConverterCollections;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.MapIndex;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;

public class Bucket
extends AbstractEvolvable
implements ExternalizableLite,
PortableObject {
    public static final int POF_IMPL_VERSION = 0;
    public static final int EMPTY = -1;
    protected int m_id;
    protected QueueVersionInfo m_version;
    protected long m_capacity = 0L;
    protected int m_head = -1;
    protected int m_tail = -1;
    protected boolean m_acceptingOffers = true;
    protected long m_bytesUsed;

    public Bucket() {
    }

    public Bucket(int bucketId, int capacity) {
        this(bucketId, new QueueVersionInfo(), capacity);
    }

    public Bucket(int bucketId, QueueVersionInfo version, long capacity) {
        this.m_id = bucketId;
        this.m_version = version;
        this.m_capacity = capacity;
        this.m_acceptingOffers = true;
    }

    public int getId() {
        return this.m_id;
    }

    public QueueVersionInfo getVersion() {
        return this.m_version;
    }

    public long getMaxCapacity() {
        return this.m_capacity;
    }

    public int getHead() {
        return this.m_head;
    }

    public void setHead(int head) {
        this.m_head = head;
        if (this.m_tail == -1) {
            this.m_tail = this.m_head;
        }
    }

    public int getTail() {
        return this.m_tail;
    }

    public void setTail(int tail) {
        this.m_tail = tail;
        if (this.m_head == -1) {
            this.m_head = tail;
        }
    }

    public void markEmpty() {
        this.m_head = -1;
        this.m_tail = -1;
        this.m_bytesUsed = 0L;
    }

    public boolean isEmpty() {
        return this.m_head == -1 && this.m_tail == -1;
    }

    public boolean isAcceptingOffers() {
        return this.m_acceptingOffers;
    }

    public void setAcceptingOffers(boolean acceptingOffers) {
        this.m_acceptingOffers = acceptingOffers;
    }

    public long getBytesUsed() {
        return this.m_bytesUsed;
    }

    public boolean increaseBytesUsed(long n) {
        if (this.m_bytesUsed >= this.m_capacity) {
            return false;
        }
        this.m_bytesUsed += n;
        return true;
    }

    public void decreaseBytesUsed(long n) {
        long nSize = this.m_bytesUsed - n;
        this.m_bytesUsed = Math.max(0L, nSize);
    }

    public String toString() {
        return ClassHelper.getSimpleName(this.getClass()) + "(id=" + this.m_id + ", capacity=" + this.m_capacity + ", bytesUsed=" + this.m_bytesUsed + ", head=" + this.m_head + ", tail=" + this.m_tail + ", acceptingOffers=" + this.m_acceptingOffers + ", version=" + String.valueOf(this.m_version) + ")";
    }

    public int hashCode() {
        return this.m_id;
    }

    public boolean equals(Object o) {
        if (o instanceof Bucket) {
            Bucket that = (Bucket)o;
            return this == that || this.getClass() == that.getClass() && this.m_id == that.m_id;
        }
        return false;
    }

    public static SortedSet<PagedQueueKey> findKeysForBucketId(int bucketId, Map backingMap, Map indexes, BackingMapManagerContext context) {
        if (backingMap.isEmpty()) {
            return new TreeSet<PagedQueueKey>();
        }
        Set<Binary> results = Bucket.findBinaryKeysForBucket(bucketId, backingMap, indexes, context);
        ConverterCollections.ConverterSet keySet = new ConverterCollections.ConverterSet(results, context.getKeyFromInternalConverter(), context.getKeyToInternalConverter());
        return new TreeSet<PagedQueueKey>(keySet);
    }

    public static List<Binary> findElementsForBucketId(int bucketId, Map<Binary, Binary> backingMap, Map indexes, BackingMapManagerContext context, boolean fHeadFirstOrder) {
        if (backingMap.isEmpty()) {
            return new ArrayList<Binary>();
        }
        Set<Binary> results = Bucket.findBinaryKeysForBucket(bucketId, backingMap, indexes, context);
        Converter keyConverter = context.getKeyFromInternalConverter();
        Comparator comparator = fHeadFirstOrder ? null : Collections.reverseOrder();
        TreeMap binaryKeyMap = new TreeMap(comparator);
        for (Binary binary : results) {
            PagedQueueKey queueKey = (PagedQueueKey)keyConverter.convert(binary);
            binaryKeyMap.put(queueKey, binary);
        }
        ArrayList<Binary> elementList = new ArrayList<Binary>();
        for (PagedQueueKey key : binaryKeyMap.keySet()) {
            Binary element = backingMap.get(binaryKeyMap.get(key));
            if (element == null) continue;
            elementList.add(element);
        }
        return elementList;
    }

    private static Set<Binary> findBinaryKeysForBucket(int bucketId, Map backingMap, Map indexes, BackingMapManagerContext context) {
        MapIndex index;
        HashSet<Binary> results = new HashSet<Binary>();
        MapIndex mapIndex = index = indexes != null ? (MapIndex)indexes.get(PagedQueueKey.BUCKET_ID_EXTRACTOR) : null;
        if (index != null) {
            Set keys = index.getIndexContents().get(bucketId);
            if (keys != null) {
                results.addAll(keys);
            }
        } else {
            Converter converter = context.getValueFromInternalConverter();
            for (Binary binaryKey : backingMap.keySet()) {
                PagedQueueKey queueKey = (PagedQueueKey)converter.convert(binaryKey);
                int keyBucketId = queueKey.getBucketId();
                if (keyBucketId != bucketId) continue;
                results.add(binaryKey);
            }
        }
        return results;
    }

    private static Set<Binary> findBinaryKeysForBucket(int bucketId, int fromId, int toId, Map backingMap, Map indexes, BackingMapManagerContext context) {
        HashSet<Binary> results = new HashSet<Binary>();
        MapIndex index = indexes != null ? (MapIndex)indexes.get(PagedQueueKey.BUCKET_ID_EXTRACTOR) : null;
        Set keys = index != null ? index.getIndexContents().get(bucketId) : backingMap.keySet();
        if (keys == null) {
            return results;
        }
        Serializer serializer = context.getCacheService().getSerializer();
        for (Binary binaryKey : keys) {
            PagedQueueKey queueKey = (PagedQueueKey)ExternalizableHelper.fromBinary(binaryKey, serializer);
            int keyBucketId = queueKey.getBucketId();
            int keyElementId = queueKey.getElementId();
            if (keyBucketId != bucketId || keyElementId < fromId || keyElementId > toId) continue;
            results.add(binaryKey);
        }
        return results;
    }

    @Override
    public int getImplVersion() {
        return 0;
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_id = in.readInt(0);
        this.m_version = (QueueVersionInfo)in.readObject(1);
        this.m_capacity = in.readLong(2);
        this.m_head = in.readInt(3);
        this.m_tail = in.readInt(4);
        this.m_acceptingOffers = (Boolean)in.readObject(5);
        this.m_bytesUsed = in.readLong(6);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeInt(0, this.m_id);
        out.writeObject(1, this.m_version);
        out.writeLong(2, this.m_capacity);
        out.writeInt(3, this.m_head);
        out.writeInt(4, this.m_tail);
        out.writeObject(5, this.m_acceptingOffers);
        out.writeLong(6, this.m_bytesUsed);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_id = ExternalizableHelper.readInt(in);
        this.m_version = (QueueVersionInfo)ExternalizableHelper.readObject(in);
        this.m_capacity = ExternalizableHelper.readLong(in);
        this.m_head = ExternalizableHelper.readInt(in);
        this.m_tail = ExternalizableHelper.readInt(in);
        this.m_acceptingOffers = (Boolean)ExternalizableHelper.readObject(in);
        this.m_bytesUsed = ExternalizableHelper.readLong(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        ExternalizableHelper.writeInt(out, this.m_id);
        ExternalizableHelper.writeObject(out, this.m_version);
        ExternalizableHelper.writeLong(out, this.m_capacity);
        ExternalizableHelper.writeInt(out, this.m_head);
        ExternalizableHelper.writeInt(out, this.m_tail);
        ExternalizableHelper.writeObject(out, this.m_acceptingOffers);
        ExternalizableHelper.writeLong(out, this.m_bytesUsed);
    }
}

