/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.queue.paged;

import com.tangosol.internal.net.queue.BaseBinaryNamedMapQueue;
import com.tangosol.internal.net.queue.PagedQueue;
import com.tangosol.internal.net.queue.model.QueueOfferResult;
import com.tangosol.internal.net.queue.model.QueuePollResult;
import com.tangosol.internal.net.queue.paged.ClearQueueProcessor;
import com.tangosol.internal.net.queue.paged.HeadIncrementProcessor;
import com.tangosol.internal.net.queue.paged.InitialiseQueueInfoProcessor;
import com.tangosol.internal.net.queue.paged.PagedQueueCacheNames;
import com.tangosol.internal.net.queue.paged.PagedQueueKey;
import com.tangosol.internal.net.queue.paged.PeekWholeBucketAggregator;
import com.tangosol.internal.net.queue.paged.QueueInfo;
import com.tangosol.internal.net.queue.paged.QueueOfferTailProcessor;
import com.tangosol.internal.net.queue.paged.QueuePollPeekHeadProcessor;
import com.tangosol.internal.net.queue.paged.QueueVersionInfo;
import com.tangosol.internal.net.queue.paged.TailIncrementProcessor;
import com.tangosol.io.Serializer;
import com.tangosol.net.CacheService;
import com.tangosol.net.ExtensibleConfigurableCacheFactory;
import com.tangosol.net.NamedCache;
import com.tangosol.net.NamedMap;
import com.tangosol.net.Session;
import com.tangosol.net.options.WithClassLoader;
import com.tangosol.util.Binary;
import com.tangosol.util.NullImplementation;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class BinaryPagedNamedQueue
extends BaseBinaryNamedMapQueue
implements PagedQueue<Binary> {
    protected NamedMap<String, QueueInfo> m_queueInfoCache;
    protected NamedMap<Binary, Binary> m_bucketCache;
    protected NamedMap<?, ?> m_versionCache;
    protected NamedMap<Binary, Binary> m_elementCache;
    protected QueueInfo m_queueInfo;

    public BinaryPagedNamedQueue(String sName, Session session) {
        this(sName, session.getCache(sName, WithClassLoader.nullImplementation()));
    }

    public BinaryPagedNamedQueue(String sName, ExtensibleConfigurableCacheFactory eccf) {
        this(sName, eccf.ensureCache(sName, NullImplementation.getClassLoader()));
    }

    public BinaryPagedNamedQueue(String sName, NamedCache<Binary, Binary> cache) {
        super(sName, (NamedMap<Binary, Binary>)cache);
        CacheService cacheService = cache.getCacheService();
        this.m_elementCache = cache;
        this.m_bucketCache = PagedQueueCacheNames.Buckets.ensureBinaryMap(sName, cacheService);
        this.m_versionCache = PagedQueueCacheNames.Version.ensureBinaryMap(sName, cacheService);
        this.m_queueInfoCache = PagedQueueCacheNames.Info.ensureBinaryMap(sName, cacheService);
        this.m_queueInfo = this.m_queueInfoCache.invoke(sName, this.instantateInitialiseQueueInfoProcessor());
        this.m_elementCache.addIndex(PagedQueueKey.BUCKET_ID_EXTRACTOR, true, null);
    }

    @Override
    public void clear() {
        this.m_bucketCache.invokeAll(new ClearQueueProcessor());
    }

    @Override
    public void release() {
        super.release();
        this.release(this.m_bucketCache);
        this.release(this.m_queueInfoCache);
        this.release(this.m_versionCache);
    }

    @Override
    public void destroy() {
        super.destroy();
        this.destroy(this.m_bucketCache);
        this.destroy(this.m_queueInfoCache);
        this.destroy(this.m_versionCache);
    }

    @Override
    public Iterator<Binary> iterator() {
        if (this.size() == 0) {
            return Collections.emptyIterator();
        }
        return new BinaryQueueIterator(this, this.m_queueInfo.getMaxBucketId());
    }

    @Override
    protected QueueOfferResult offerToTailInternal(Binary binary) {
        if (binary == null) {
            throw new NullPointerException("Null elements are not supported");
        }
        int tailBucketId = this.m_queueInfo.getTailBucketId();
        QueueOfferTailProcessor processor = this.instantiateTailOfferProcessor(binary, this.m_queueInfo);
        Binary binKey = (Binary)this.m_converterKeyToInternal.convert(tailBucketId);
        Binary binResult = (Binary)((Object)this.m_bucketCache.invoke(binKey, processor));
        QueueOfferResult result = (QueueOfferResult)this.m_converterValueFromInternal.convert(binResult);
        while (result.getResult() == 3) {
            long version = this.m_queueInfo.getVersion().getTailOfferVersion();
            TailIncrementProcessor incrementor = new TailIncrementProcessor(tailBucketId, version);
            this.m_queueInfo = this.m_queueInfoCache.invoke(this.m_sName, incrementor);
            if (this.m_queueInfo.isQueueFull()) {
                this.peek();
                this.m_queueInfo = this.m_queueInfoCache.invoke(this.m_sName, incrementor);
                if (this.m_queueInfo.isQueueFull()) {
                    return new QueueOfferResult(0L, 2);
                }
            }
            tailBucketId = this.m_queueInfo.getTailBucketId();
            binKey = (Binary)this.m_converterKeyToInternal.convert(tailBucketId);
            binResult = (Binary)((Object)this.m_bucketCache.invoke(binKey, processor));
            result = (QueueOfferResult)this.m_converterValueFromInternal.convert(binResult);
        }
        return result;
    }

    @Override
    protected QueuePollResult pollFromHeadInternal() {
        Binary binary = this.pollOrPeekHead(true);
        return this.toResult(binary);
    }

    @Override
    protected QueuePollResult peekAtHeadInternal() {
        Binary binary = this.pollOrPeekHead(false);
        return this.toResult(binary);
    }

    protected QueuePollResult toResult(Binary binary) {
        return new QueuePollResult(1L, binary);
    }

    protected Binary pollOrPeekHead(boolean fPoll) {
        if (this.m_elementCache.isEmpty()) {
            return null;
        }
        int headId = this.m_queueInfo.getHeadBucketId();
        QueueVersionInfo version = this.m_queueInfo.getVersion();
        QueuePollPeekHeadProcessor processor = this.instantiatePollPeekHeadProcessor(fPoll, version);
        Binary binKey = (Binary)this.m_converterKeyToInternal.convert(headId);
        Binary binResult = (Binary)((Object)this.m_bucketCache.invoke(binKey, processor));
        QueuePollResult result = (QueuePollResult)this.m_converterValueFromInternal.convert(binResult);
        while (result.getId() == -9223372036854775807L && !this.m_elementCache.isEmpty()) {
            HeadIncrementProcessor incrementor = new HeadIncrementProcessor(headId, version);
            this.m_queueInfo = this.m_queueInfoCache.invoke(this.m_sName, incrementor);
            version = this.m_queueInfo.getVersion();
            headId = this.m_queueInfo.getHeadBucketId();
            binKey = (Binary)this.m_converterKeyToInternal.convert(headId);
            processor.setVersion(version);
            binResult = (Binary)((Object)this.m_bucketCache.invoke(binKey, processor));
            result = (QueuePollResult)this.m_converterValueFromInternal.convert(binResult);
        }
        return result.getBinaryElement();
    }

    protected InitialiseQueueInfoProcessor instantateInitialiseQueueInfoProcessor() {
        return InitialiseQueueInfoProcessor.INSTANCE;
    }

    protected QueueOfferTailProcessor instantiateTailOfferProcessor(Binary binElement, QueueInfo queueInfo) {
        QueueVersionInfo version = queueInfo.getVersion();
        int bucketSize = queueInfo.getBucketSize();
        return new QueueOfferTailProcessor(binElement, version, bucketSize);
    }

    protected QueuePollPeekHeadProcessor instantiatePollPeekHeadProcessor(boolean fPoll, QueueVersionInfo version) {
        return new QueuePollPeekHeadProcessor(fPoll, version);
    }

    protected Iterator<Binary> peekAtBucket(int bucketId, boolean fHeadFirst) {
        Binary binKey = (Binary)this.m_converterKeyToInternal.convert(bucketId);
        PeekWholeBucketAggregator aggregator = new PeekWholeBucketAggregator(fHeadFirst);
        Binary binResult = (Binary)this.m_bucketCache.aggregate(Collections.singleton(binKey), aggregator);
        if (binResult == null) {
            return null;
        }
        List results = (List)this.m_converterValueFromInternal.convert(binResult);
        if (results == null || results.isEmpty()) {
            return null;
        }
        return results.iterator();
    }

    protected int refreshHeadBucketId() {
        this.m_queueInfo = this.m_queueInfoCache.invoke(this.m_sName, this.instantateInitialiseQueueInfoProcessor());
        return this.m_queueInfo.getHeadBucketId();
    }

    protected int refreshTailBucketId() {
        this.m_queueInfo = this.m_queueInfoCache.invoke(this.m_sName, this.instantateInitialiseQueueInfoProcessor());
        return this.m_queueInfo.getTailBucketId();
    }

    protected int findNextBucketId(int bucketId) {
        bucketId = bucketId == this.m_queueInfo.getMaxBucketId() ? 0 : ++bucketId;
        return this.isValidBucketId(bucketId) ? bucketId : -1;
    }

    protected int findPreviousBucketId(int bucketId) {
        bucketId = bucketId == 0 ? this.m_queueInfo.getMaxBucketId() : --bucketId;
        return this.isValidBucketId(bucketId) ? bucketId : -1;
    }

    protected boolean isValidBucketId(int bucketId) {
        int tail;
        this.m_queueInfo = this.m_queueInfoCache.invoke(this.m_sName, this.instantateInitialiseQueueInfoProcessor());
        int head = this.m_queueInfo.getHeadBucketId();
        if (head <= (tail = this.m_queueInfo.getTailBucketId()) && bucketId >= head && bucketId <= tail) {
            return true;
        }
        return head > tail && (bucketId >= head || bucketId >= 0 && bucketId <= tail);
    }

    protected Serializer getSerializer() {
        return this.m_bucketCache.getService().getSerializer();
    }

    protected void removeElement(int bucketId, int elementId) {
        this.m_elementCache.remove(this.m_converterKeyToInternal.convert(new PagedQueueKey(bucketId, elementId)));
    }

    protected static class BinaryQueueIterator
    extends BaseBinaryQueueIterator {
        public BinaryQueueIterator(BinaryPagedNamedQueue queue, int maxBucketId) {
            super(queue, true, maxBucketId);
        }

        @Override
        protected void moveToNextBucketId() {
            this.m_currentBucketId = this.m_currentBucketId == this.m_maxBucketId ? 0 : ++this.m_currentBucketId;
        }
    }

    protected static abstract class BaseBinaryQueueIterator
    implements Iterator<Binary> {
        protected BinaryPagedNamedQueue m_queue;
        protected int m_maxBucketId;
        protected boolean m_fHeadFirst;
        protected int m_currentBucketId;
        protected Iterator<Binary> m_iterator;
        protected Serializer m_serializer;
        protected Binary m_currentBinary;

        public BaseBinaryQueueIterator(BinaryPagedNamedQueue queue, boolean fHeadFirst, int maxBucketId) {
            this.m_queue = queue;
            this.m_fHeadFirst = fHeadFirst;
            this.m_maxBucketId = maxBucketId;
            if (queue.isEmpty()) {
                this.m_iterator = null;
            } else {
                this.m_currentBucketId = fHeadFirst ? this.m_queue.refreshHeadBucketId() : this.m_queue.refreshTailBucketId();
                this.m_serializer = this.m_queue.getSerializer();
                this.m_iterator = this.m_queue.peekAtBucket(this.m_currentBucketId, fHeadFirst);
            }
        }

        protected abstract void moveToNextBucketId();

        @Override
        public boolean hasNext() {
            while (this.m_iterator == null || !this.m_iterator.hasNext()) {
                this.moveToNextBucketId();
                this.m_iterator = this.m_queue.peekAtBucket(this.m_currentBucketId, this.m_fHeadFirst);
                while (this.m_iterator == null || !this.m_iterator.hasNext()) {
                    int n = this.m_currentBucketId = this.m_fHeadFirst ? this.m_queue.findNextBucketId(this.m_currentBucketId) : this.m_queue.findPreviousBucketId(this.m_currentBucketId);
                    if (this.m_currentBucketId == -1) {
                        return false;
                    }
                    this.m_iterator = this.m_queue.peekAtBucket(this.m_currentBucketId, this.m_fHeadFirst);
                }
            }
            return this.m_iterator != null && this.m_iterator.hasNext();
        }

        @Override
        public Binary next() {
            if (this.m_iterator != null) {
                if (!this.m_iterator.hasNext() && !this.hasNext()) {
                    throw new NoSuchElementException("Iterator is exhausted");
                }
                this.m_currentBinary = this.m_iterator.next();
                return this.m_currentBinary;
            }
            throw new NoSuchElementException("Iterator is exhausted");
        }
    }
}

