/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.queue.paged;

import com.tangosol.internal.net.queue.model.QueuePollResult;
import com.tangosol.internal.net.queue.paged.BasePagedQueueProcessor;
import com.tangosol.internal.net.queue.paged.Bucket;
import com.tangosol.internal.net.queue.paged.PagedQueueCacheNames;
import com.tangosol.internal.net.queue.paged.PagedQueueKey;
import com.tangosol.internal.net.queue.paged.QueueVersionInfo;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.net.BackingMapContext;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.Converter;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.InvocableMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public abstract class BasePollPeekProcessor
extends BasePagedQueueProcessor<QueuePollResult> {
    public static final int POF_IMPL_VERSION = 0;
    protected boolean m_fPoll;
    protected QueueVersionInfo m_version;

    public BasePollPeekProcessor() {
    }

    protected BasePollPeekProcessor(boolean fPoll, QueueVersionInfo version) {
        this.m_fPoll = fPoll;
        this.m_version = version;
    }

    @Override
    public final QueuePollResult process(InvocableMap.Entry<Integer, Bucket> entry) {
        BinaryEntry binaryEntry = (BinaryEntry)entry;
        if (!binaryEntry.isPresent()) {
            BinaryEntry<Integer, QueueVersionInfo> versionEntry = this.getVersionBinaryEntry(binaryEntry);
            if (!versionEntry.isPresent()) {
                return QueuePollResult.empty();
            }
            return QueuePollResult.nextPage();
        }
        Bucket bucket = entry.getValue();
        QueueVersionInfo version = bucket.getVersion();
        if (!this.isValidVersion(version)) {
            return QueuePollResult.nextPage();
        }
        if (bucket.isEmpty()) {
            this.removeEmptyBucket(bucket, binaryEntry);
            return QueuePollResult.nextPage();
        }
        QueuePollResult result = this.pollOrPeek(binaryEntry, bucket);
        binaryEntry.setValue(bucket);
        return result;
    }

    protected abstract boolean isValidVersion(QueueVersionInfo var1);

    protected abstract PagedQueueKey firstQueueKey(Bucket var1);

    protected abstract PagedQueueKey nextQueueKey(Bucket var1, PagedQueueKey var2);

    protected abstract void poll(Bucket var1, PagedQueueKey var2);

    protected abstract void notifyRemovingEmptyBucket(Bucket var1);

    public boolean isPoll() {
        return this.m_fPoll;
    }

    public void setVersion(QueueVersionInfo version) {
        this.m_version = version;
    }

    protected void removeEmptyBucket(Bucket bucket, BinaryEntry<Integer, Bucket> bucketBinaryEntry) {
        this.notifyRemovingEmptyBucket(bucket);
        bucket.setAcceptingOffers(true);
        BinaryEntry<Integer, QueueVersionInfo> versionBinaryEntry = this.getVersionBinaryEntry(bucketBinaryEntry);
        versionBinaryEntry.setValue(bucket.getVersion());
        bucketBinaryEntry.remove(true);
    }

    protected QueuePollResult pollOrPeek(BinaryEntry<Integer, Bucket> binaryEntry, Bucket bucket) {
        BackingMapManagerContext context = binaryEntry.getContext();
        BackingMapContext backingMapContext = binaryEntry.getBackingMapContext();
        String elementCacheName = PagedQueueCacheNames.Elements.getCacheName(backingMapContext);
        BackingMapContext elementMapContext = context.getBackingMapContext(elementCacheName);
        Converter keyConverter = context.getKeyToInternalConverter();
        PagedQueueKey queueKey = this.firstQueueKey(bucket);
        Binary binaryKey = (Binary)keyConverter.convert(queueKey);
        BinaryEntry elementEntry = (BinaryEntry)elementMapContext.getBackingMapEntry(binaryKey);
        while (!elementEntry.isPresent()) {
            if ((queueKey = this.nextQueueKey(bucket, queueKey)) == null) {
                bucket.markEmpty();
                return new QueuePollResult();
            }
            binaryKey = (Binary)keyConverter.convert(queueKey);
            elementEntry = (BinaryEntry)elementMapContext.getBackingMapEntry(binaryKey);
            bucket.setHead(queueKey.getElementId());
            binaryEntry.setValue(bucket);
        }
        Binary binElement = elementEntry.getBinaryValue();
        if (this.m_fPoll) {
            Binary binKey = elementEntry.getBinaryKey();
            long nSize = this.entrySize(binKey, binElement);
            bucket.decreaseBytesUsed(nSize);
            elementEntry.remove(false);
            this.poll(bucket, queueKey);
        }
        return new QueuePollResult(queueKey.getBucketId(), queueKey.getElementId(), binElement);
    }

    @Override
    public int getImplVersion() {
        return 0;
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_fPoll = in.readBoolean(0);
        this.m_version = (QueueVersionInfo)in.readObject(1);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeBoolean(0, this.m_fPoll);
        out.writeObject(1, this.m_version);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_fPoll = in.readBoolean();
        this.m_version = (QueueVersionInfo)ExternalizableHelper.readObject(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        out.writeBoolean(this.m_fPoll);
        ExternalizableHelper.writeObject(out, this.m_version);
    }
}

