/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.queue.paged;

import com.tangosol.internal.net.queue.paged.Bucket;
import com.tangosol.internal.net.queue.paged.PagedQueueCacheNames;
import com.tangosol.internal.net.queue.paged.QueueVersionInfo;
import com.tangosol.internal.net.queue.processor.AbstractQueueProcessor;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.BackingMapContext;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.util.Binary;
import com.tangosol.util.BinaryEntry;

public abstract class BasePagedQueueProcessor<R>
extends AbstractQueueProcessor<Integer, Bucket, R>
implements ExternalizableLite,
PortableObject {
    protected Bucket ensureBucket(BinaryEntry<Integer, Bucket> binaryEntry, int nMaxBucketSize, QueueVersionInfo version) {
        Bucket bucket;
        if (binaryEntry.isPresent()) {
            bucket = (Bucket)binaryEntry.getValue();
        } else {
            BinaryEntry<Integer, QueueVersionInfo> versionEntry = this.getVersionBinaryEntry(binaryEntry);
            QueueVersionInfo versionBucket = versionEntry.isPresent() ? (QueueVersionInfo)versionEntry.getValue() : this.instantiateQueueVersionInfo(version);
            bucket = this.instantiateBucket(binaryEntry, versionBucket, nMaxBucketSize);
        }
        return bucket;
    }

    protected Bucket instantiateBucket(BinaryEntry<Integer, ?> bucketEntry, QueueVersionInfo version, int nMaxBucketSize) {
        return new Bucket((Integer)bucketEntry.getKey(), version, nMaxBucketSize);
    }

    protected QueueVersionInfo instantiateQueueVersionInfo(QueueVersionInfo version) {
        return version;
    }

    protected BinaryEntry<Integer, QueueVersionInfo> getVersionBinaryEntry(BinaryEntry<?, ?> binaryEntry) {
        Binary binaryKey = binaryEntry.getBinaryKey();
        BackingMapManagerContext context = binaryEntry.getContext();
        BackingMapContext backingMapContext = binaryEntry.getBackingMapContext();
        String versionCacheName = PagedQueueCacheNames.Version.getCacheName(backingMapContext);
        BackingMapContext versionContext = context.getBackingMapContext(versionCacheName);
        return (BinaryEntry)versionContext.getBackingMapEntry(binaryKey);
    }
}

