/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.queue.model;

import com.tangosol.io.AbstractEvolvable;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.EvolvablePortableObject;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.util.Binary;
import com.tangosol.util.ExternalizableHelper;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class QueuePollResult
extends AbstractEvolvable
implements ExternalizableLite,
EvolvablePortableObject {
    public static final long RESULT_EMPTY = Long.MIN_VALUE;
    public static final long RESULT_POLL_NEXT_PAGE = -9223372036854775807L;
    public static final int IMPL_VERSION = 1;
    private Binary m_binElement;
    private long m_id;

    public QueuePollResult() {
    }

    public QueuePollResult(long id) {
        this(id, null);
    }

    public QueuePollResult(int idMSB, int idLSB, Binary binElement) {
        this((long)idMSB << 32 | (long)idLSB & 0xFFFFFFFFL, binElement);
    }

    public QueuePollResult(long id, Binary binElement) {
        this.m_id = id;
        this.m_binElement = binElement;
    }

    public long getId() {
        return this.m_id;
    }

    public Binary getBinaryElement() {
        return this.m_binElement;
    }

    @Override
    public int getImplVersion() {
        return 1;
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_id = in.readLong(0);
        this.m_binElement = in.readBinary(1);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeLong(0, this.m_id);
        out.writeBinary(1, this.m_binElement);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_id = in.readLong();
        this.m_binElement = (Binary)ExternalizableHelper.readObject(in);
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        out.writeLong(this.m_id);
        ExternalizableHelper.writeObject(out, this.m_binElement);
    }

    public static QueuePollResult empty() {
        return new QueuePollResult(Long.MIN_VALUE);
    }

    public static QueuePollResult nextPage() {
        return new QueuePollResult(-9223372036854775807L);
    }
}

