/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.queue.model;

import com.oracle.coherence.common.base.Formatting;
import com.tangosol.io.ExternalizableLite;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.net.cache.KeyAssociation;
import jakarta.json.bind.annotation.JsonbProperty;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;

public class QueueKey
implements PortableObject,
ExternalizableLite,
KeyAssociation<Integer>,
Comparable<QueueKey> {
    public static final long ID_HEAD = Long.MAX_VALUE;
    public static final long ID_TAIL = Long.MIN_VALUE;
    public static final long EMPTY_ID = 0L;
    @JsonbProperty(value="hash")
    protected int m_nHash;
    @JsonbProperty(value="id")
    protected long m_nId;

    public QueueKey() {
    }

    public QueueKey(int nHash, long nId) {
        this.m_nHash = nHash;
        this.m_nId = nId;
    }

    public int getHash() {
        return this.m_nHash;
    }

    public long getId() {
        return this.m_nId;
    }

    public QueueKey next() {
        return new QueueKey(this.m_nHash, this.m_nId + 1L);
    }

    public QueueKey prev() {
        return new QueueKey(this.m_nHash, this.m_nId - 1L);
    }

    public QueueKey randomHead() {
        int n = Math.min(-1, -Math.abs(ThreadLocalRandom.current().nextInt()));
        return new QueueKey(this.m_nHash, n);
    }

    public QueueKey randomTail() {
        int n = Math.max(1, Math.abs(ThreadLocalRandom.current().nextInt()));
        return new QueueKey(this.m_nHash, n);
    }

    @Override
    public int compareTo(QueueKey o) {
        int n = Integer.compare(this.m_nHash, o.m_nHash);
        if (n == 0) {
            n = Long.compare(this.m_nId, o.m_nId);
        }
        return n;
    }

    @Override
    public Integer getAssociatedKey() {
        return this.m_nHash;
    }

    @Override
    public void readExternal(PofReader in) throws IOException {
        this.m_nHash = in.readInt(0);
        this.m_nId = in.readLong(1);
    }

    @Override
    public void writeExternal(PofWriter out) throws IOException {
        out.writeInt(0, this.m_nHash);
        out.writeLong(1, this.m_nId);
    }

    @Override
    public void readExternal(DataInput in) throws IOException {
        this.m_nHash = in.readInt();
        this.m_nId = in.readLong();
    }

    @Override
    public void writeExternal(DataOutput out) throws IOException {
        out.writeInt(this.m_nHash);
        out.writeLong(this.m_nId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueueKey queueKey = (QueueKey)o;
        return this.m_nHash == queueKey.m_nHash && this.m_nId == queueKey.m_nId;
    }

    public int hashCode() {
        return Objects.hash(this.m_nHash, this.m_nId);
    }

    public String toString() {
        return "QueueKey{id=" + this.m_nId + ", hash=" + this.m_nHash + "}";
    }

    public static int calculateQueueHash(String sQueueName) {
        byte[] ab = sQueueName.getBytes(StandardCharsets.UTF_8);
        return Formatting.toCrc(ab, 0, ab.length, 0);
    }

    public static QueueKey head(String sQueue) {
        return new QueueKey(QueueKey.calculateQueueHash(sQueue), Long.MAX_VALUE);
    }

    public static QueueKey tail(String sQueue) {
        return new QueueKey(QueueKey.calculateQueueHash(sQueue), Long.MIN_VALUE);
    }
}

