/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.queue.extractor;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.internal.net.queue.model.QueueKey;
import com.tangosol.net.BackingMapContext;
import com.tangosol.net.cache.BinaryMemoryCalculator;
import com.tangosol.net.cache.ConfigurableCacheMap;
import com.tangosol.util.BinaryEntry;
import com.tangosol.util.MapIndex;
import com.tangosol.util.ObservableMap;
import com.tangosol.util.ValueExtractor;
import com.tangosol.util.extractor.EntryExtractor;
import com.tangosol.util.extractor.IndexAwareExtractor;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;

public class QueueKeyExtractor
extends EntryExtractor
implements IndexAwareExtractor {
    public static final QueueKeyExtractor INSTANCE = new QueueKeyExtractor();

    @Override
    public Long extract(Object oTarget) {
        return oTarget instanceof QueueKey ? ((QueueKey)oTarget).getId() : -1L;
    }

    public Long extractFromEntry(Map.Entry entry) {
        QueueKey key = (QueueKey)entry.getKey();
        return key == null ? -1L : key.getId();
    }

    @Override
    public String getCanonicalName() {
        return "Key";
    }

    public MapIndex createIndex(boolean fOrdered, Comparator comparator, Map mapIndex, BackingMapContext ctx) {
        long nHighUnits;
        ConfigurableCacheMap map;
        MapIndex index = (MapIndex)mapIndex.get(INSTANCE);
        if (index instanceof QueueIndex) {
            return null;
        }
        if (index != null) {
            Logger.warn("Replacing a previous index was created with extractor " + String.valueOf(INSTANCE) + " which was not a " + String.valueOf(QueueIndex.class));
        }
        long cBytesMax = 2000000000L;
        ObservableMap backingMap = ctx.getBackingMap();
        if (backingMap instanceof ConfigurableCacheMap && (map = (ConfigurableCacheMap)backingMap).getUnitCalculator() instanceof BinaryMemoryCalculator && (nHighUnits = (long)map.getHighUnits() * (long)map.getUnitFactor()) > 0L) {
            cBytesMax = Math.min(nHighUnits, cBytesMax);
        }
        int nHash = QueueKey.calculateQueueHash(ctx.getCacheName());
        QueueIndex indexNew = new QueueIndex(nHash, cBytesMax);
        mapIndex.put(INSTANCE, indexNew);
        return indexNew;
    }

    public MapIndex destroyIndex(Map mapIndex) {
        return (MapIndex)mapIndex.remove(INSTANCE);
    }

    @Override
    public boolean equals(Object o) {
        return o != null && o.getClass() == QueueKeyExtractor.class;
    }

    @Override
    public int hashCode() {
        return QueueKeyExtractor.class.hashCode();
    }

    public String toString() {
        return "QueueKeyExtractor";
    }

    public static <E> ValueExtractor<E, Long> instance() {
        return INSTANCE;
    }

    public static class QueueIndex
    implements MapIndex {
        private static final BinaryMemoryCalculator CALCULATOR = new BinaryMemoryCalculator();
        private final int m_nQueueHash;
        private final AtomicLong m_cHead = new AtomicLong();
        private final AtomicLong m_cTail = new AtomicLong();
        private long m_cBytesMax;
        private final ConcurrentSkipListMap<Long, Object> m_map = new ConcurrentSkipListMap();
        private final LongAdder m_queueSize = new LongAdder();

        public QueueIndex(int nQueueHash, long cBytesMax) {
            this.m_nQueueHash = nQueueHash;
            this.m_cBytesMax = cBytesMax;
        }

        public long getQueueSize() {
            return this.m_queueSize.longValue();
        }

        public long getMaxQueueSize() {
            return this.m_cBytesMax;
        }

        public void setMaxQueueSize(long cBytesMax) {
            this.m_cBytesMax = Math.min(2000000000L, cBytesMax);
        }

        public long head(long nDefault) {
            return QueueIndex.head(this.m_map, nDefault);
        }

        public long nextHeadOffer() {
            return this.m_cHead.getAndDecrement();
        }

        public long nextTailOffer() {
            return this.m_cTail.getAndIncrement();
        }

        public long tail(long nDefault) {
            return QueueIndex.tail(this.m_map, nDefault);
        }

        public SortedMap<Long, Object> tailMap(long fromId) {
            return Collections.unmodifiableSortedMap(this.m_map.tailMap((Object)fromId, false));
        }

        public SortedMap<Long, Object> headMap(long fromId) {
            return Collections.unmodifiableSortedMap(this.m_map.headMap((Object)fromId, false).descendingMap());
        }

        public Object getHeadBinaryKey(long nDefaultId) {
            long nHead = QueueIndex.head(this.m_map, nDefaultId);
            return this.m_map.get(nHead);
        }

        public Object getTailBinaryKey(long nDefaultId) {
            long nHead = QueueIndex.tail(this.m_map, nDefaultId);
            return this.m_map.get(nHead);
        }

        public ValueExtractor getValueExtractor() {
            return INSTANCE;
        }

        @Override
        public boolean isOrdered() {
            return true;
        }

        @Override
        public boolean isPartial() {
            return true;
        }

        public Map getIndexContents() {
            return Collections.emptyMap();
        }

        public Object get(Object key) {
            return null;
        }

        public Comparator getComparator() {
            return INSTANCE;
        }

        public void insert(Map.Entry entry) {
            this.updateInternal(entry);
        }

        public void update(Map.Entry entry) {
            this.updateInternal(entry);
        }

        public void delete(Map.Entry entry) {
            long nId = ((QueueKey)entry.getKey()).getId();
            this.m_cHead.getAndUpdate(c -> c == nId ? c + 1L : c);
            this.m_cTail.getAndUpdate(c -> c == nId ? c - 1L : c);
            this.m_map.remove(nId);
            BinaryEntry binaryEntry = (BinaryEntry)entry;
            long cBytes = CALCULATOR.calculateUnits(binaryEntry.getBinaryKey(), binaryEntry.getBinaryValue());
            this.m_queueSize.add(-cBytes);
        }

        public boolean isEmpty() {
            return this.m_map.isEmpty();
        }

        public static long head(SortedMap<Long, ?> map, long nDefault) {
            if (!map.isEmpty()) {
                try {
                    return map.firstKey();
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
            }
            return nDefault;
        }

        public static long tail(SortedMap<Long, ?> map, long nDefault) {
            if (!map.isEmpty()) {
                try {
                    return map.lastKey();
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
            }
            return nDefault;
        }

        private void updateInternal(Map.Entry entry) {
            QueueKey queueKey = (QueueKey)entry.getKey();
            long nId = queueKey.getId();
            QueueKey oKey = entry instanceof BinaryEntry ? ((BinaryEntry)entry).getBinaryKey() : queueKey;
            this.m_cHead.getAndUpdate(c -> Math.min(c, nId));
            this.m_cTail.getAndUpdate(c -> Math.max(c, nId));
            this.m_map.put(nId, oKey);
            if (entry instanceof BinaryEntry) {
                BinaryEntry binaryEntry = (BinaryEntry)entry;
                long cBytes = CALCULATOR.calculateUnits(binaryEntry.getBinaryKey(), binaryEntry.getBinaryValue());
                this.m_queueSize.add(cBytes);
            }
        }
    }
}

