/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.queue;

import com.tangosol.internal.net.metrics.Histogram;
import com.tangosol.internal.net.metrics.Meter;
import com.tangosol.net.metrics.Rates;
import com.tangosol.net.metrics.Snapshot;
import com.tangosol.net.queue.MutableQueueStatistics;
import java.util.concurrent.atomic.LongAdder;

public class SimpleQueueStatistics
implements MutableQueueStatistics {
    private final Histogram m_pollHistogram = new Histogram();
    private Snapshot m_pollSnapshot;
    private volatile long m_nLastPollSnapshot;
    private final Meter m_pollMeter = new Meter();
    private final Histogram m_offerHistogram = new Histogram();
    private Snapshot m_offerSnapshot;
    private volatile long m_nLastOfferSnapshot;
    private final Meter m_offerMeter = new Meter();
    private final LongAdder m_cHits = new LongAdder();
    private final LongAdder m_cMisses = new LongAdder();
    private final LongAdder m_cAccepted = new LongAdder();
    private final LongAdder m_cRejected = new LongAdder();

    @Override
    public void polled(long cNanos) {
        this.m_pollHistogram.update(cNanos);
        this.m_pollMeter.mark();
    }

    @Override
    public void offered(long cNanos) {
        this.m_offerHistogram.update(cNanos);
        this.m_offerMeter.mark();
    }

    @Override
    public void registerHit() {
        this.m_cHits.increment();
    }

    @Override
    public void registerMiss() {
        this.m_cMisses.increment();
    }

    @Override
    public void registerAccepted() {
        this.m_cAccepted.increment();
    }

    @Override
    public void registerRejected() {
        this.m_cRejected.increment();
    }

    @Override
    public Snapshot getPollSnapshot() {
        return this.ensurePollSnapshot();
    }

    @Override
    public Rates getPollRates() {
        return this.m_pollMeter;
    }

    @Override
    public Snapshot getOfferSnapshot() {
        return this.ensureOfferSnapshot();
    }

    @Override
    public Rates getOfferRates() {
        return this.m_offerMeter;
    }

    @Override
    public long getHits() {
        return this.m_cHits.longValue();
    }

    @Override
    public long getMisses() {
        return this.m_cMisses.longValue();
    }

    @Override
    public long getAccepted() {
        return this.m_cAccepted.longValue();
    }

    @Override
    public long getRejected() {
        return this.m_cRejected.longValue();
    }

    @Override
    public void logTo(StringBuilder s) {
        s.append("hits=").append(this.m_cHits.longValue()).append(", misses=").append(this.m_cMisses.longValue()).append(", accepted=").append(this.m_cAccepted.longValue()).append(", rejected=").append(this.m_cRejected.longValue()).append(", Poll Rates (in TPS)[");
        this.appendMeter(s, this.m_pollMeter);
        s.append("] Poll Latency (in millis)[");
        this.appendHistogram(s, this.ensurePollSnapshot());
        s.append("] Offer Rates (in TPS)[");
        this.appendMeter(s, this.m_offerMeter);
        s.append("] Offer Latency (in millis)[");
        this.appendHistogram(s, this.ensureOfferSnapshot());
        s.append(']');
    }

    protected Snapshot ensurePollSnapshot() {
        long nLastPollSnapshot = this.m_nLastPollSnapshot;
        long nNow = System.currentTimeMillis();
        Snapshot snapshot = this.m_pollSnapshot;
        if (nNow - nLastPollSnapshot > 1000L) {
            snapshot = this.m_pollSnapshot = this.m_pollHistogram.getSnapshot();
            this.m_nLastPollSnapshot = nNow;
        }
        return snapshot;
    }

    protected Snapshot ensureOfferSnapshot() {
        long nLastOfferSnapshot = this.m_nLastOfferSnapshot;
        long nNow = System.currentTimeMillis();
        Snapshot snapshot = this.m_offerSnapshot;
        if (nNow - nLastOfferSnapshot > 1000L) {
            snapshot = this.m_offerSnapshot = this.m_offerHistogram.getSnapshot();
            this.m_nLastOfferSnapshot = nNow;
        }
        return snapshot;
    }

    protected void appendHistogram(StringBuilder s, Snapshot snapshot) {
        s.append("max=").append(this.toMillis(snapshot.getMax())).append(",min=").append(this.toMillis(snapshot.getMin())).append(", mean=").append(this.toMillis(snapshot.getMean())).append(", median=").append(this.toMillis(snapshot.getMedian())).append(", 75th%=").append(this.toMillis(snapshot.get75thPercentile())).append(", 95th%=").append(this.toMillis(snapshot.get95thPercentile())).append(", 99th%=").append(this.toMillis(snapshot.get99thPercentile())).append(", 999th%=").append(this.toMillis(snapshot.get999thPercentile()));
    }

    protected void appendMeter(StringBuilder s, Meter meter) {
        s.append("count=").append(meter.getCount()).append(", 1Min=").append(this.toThreeDecimals(meter.getOneMinuteRate())).append(", 5Min=").append(this.toThreeDecimals(meter.getFiveMinuteRate())).append(", 15Min=").append(this.toThreeDecimals(meter.getFifteenMinuteRate())).append(", Mean=").append(this.toThreeDecimals(meter.getMeanRate()));
    }

    private String toMillis(double cNanos) {
        return String.format("%.6f", cNanos / 1000000.0);
    }

    private String toThreeDecimals(double d) {
        return String.format("%.3f", d);
    }
}

