/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.queue;

import com.tangosol.internal.net.queue.BaseNamedMapQueue;
import com.tangosol.internal.net.queue.NamedMapQueue;
import com.tangosol.internal.net.queue.QueuePageIterator;
import com.tangosol.internal.net.queue.model.QueueKey;
import com.tangosol.internal.net.queue.model.QueueOfferResult;
import com.tangosol.internal.net.queue.model.QueuePollResult;
import com.tangosol.internal.net.queue.processor.QueueOffer;
import com.tangosol.internal.net.queue.processor.QueuePeek;
import com.tangosol.internal.net.queue.processor.QueuePoll;
import com.tangosol.net.NamedMap;
import java.util.Iterator;

public class SimpleNamedMapQueue<E>
extends BaseNamedMapQueue<QueueKey, E>
implements NamedMapQueue<QueueKey, E> {
    public SimpleNamedMapQueue(String sName, NamedMap<QueueKey, E> cache) {
        super(sName, cache);
    }

    @Override
    public Iterator<E> iterator() {
        return QueuePageIterator.head(this::createKey, this.m_cache);
    }

    @Override
    protected QueueOfferResult offerToTailInternal(E e) {
        long lStart = System.nanoTime();
        QueueOffer<E> processor = new QueueOffer<E>(e);
        QueueOfferResult result = (QueueOfferResult)this.m_cache.invoke(this.m_keyTail.randomTail(), processor);
        long lEnd = System.nanoTime();
        this.m_statistics.offered(lEnd - lStart);
        return result;
    }

    @Override
    protected QueuePollResult pollFromHeadInternal() {
        long lStart = System.nanoTime();
        QueuePollResult result = (QueuePollResult)this.m_cache.invoke(this.m_keyHead, QueuePoll.instance());
        long lEnd = System.nanoTime();
        this.m_statistics.polled(lEnd - lStart);
        return result;
    }

    @Override
    protected QueuePollResult peekAtHeadInternal() {
        long lStart = System.nanoTime();
        QueuePollResult result = (QueuePollResult)this.m_cache.invoke(this.m_keyHead, QueuePeek.instance());
        long lEnd = System.nanoTime();
        this.m_statistics.polled(lEnd - lStart);
        return result;
    }
}

