/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.queue;

import com.tangosol.internal.net.queue.NamedMapDeque;
import com.tangosol.internal.net.queue.QueuePageIterator;
import com.tangosol.internal.net.queue.SimpleNamedMapQueue;
import com.tangosol.internal.net.queue.model.QueueKey;
import com.tangosol.internal.net.queue.model.QueueOfferResult;
import com.tangosol.internal.net.queue.model.QueuePollResult;
import com.tangosol.internal.net.queue.processor.QueueOffer;
import com.tangosol.internal.net.queue.processor.QueuePeek;
import com.tangosol.internal.net.queue.processor.QueuePoll;
import com.tangosol.internal.net.queue.processor.QueueRemove;
import com.tangosol.net.NamedMap;
import com.tangosol.util.Binary;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Extractors;
import com.tangosol.util.Filters;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;

public class SimpleNamedMapDeque<E>
extends SimpleNamedMapQueue<E>
implements NamedMapDeque<QueueKey, E> {
    public SimpleNamedMapDeque(String sName, NamedMap<QueueKey, E> cache) {
        super(Objects.requireNonNull(sName), Objects.requireNonNull(cache));
    }

    @Override
    public long prepend(E e) {
        boolean fSuccess;
        QueueOfferResult result = this.offerToHeadInternal(e);
        boolean bl = fSuccess = result.getResult() == 1;
        if (fSuccess) {
            this.m_statistics.registerAccepted();
        } else {
            this.m_statistics.registerRejected();
        }
        return fSuccess ? result.getId() : Long.MIN_VALUE;
    }

    @Override
    public void addFirst(E e) {
        QueueOfferResult result = this.offerToHeadInternal(e);
        int nStatus = result.getResult();
        if (nStatus == 2) {
            this.m_statistics.registerRejected();
            throw new IllegalStateException("Queue " + this.m_sName + " is full");
        }
        this.m_statistics.registerAccepted();
    }

    @Override
    public void addLast(E e) {
        QueueOfferResult result = this.offerToTailInternal(e);
        int nStatus = result.getResult();
        if (nStatus == 2) {
            this.m_statistics.registerRejected();
            throw new IllegalStateException("Queue " + this.m_sName + " is full");
        }
        this.m_statistics.registerAccepted();
    }

    @Override
    public boolean offerFirst(E e) {
        boolean fSuccess;
        QueueOfferResult result = this.offerToHeadInternal(e);
        boolean bl = fSuccess = result.getResult() == 1;
        if (fSuccess) {
            this.m_statistics.registerAccepted();
        } else {
            this.m_statistics.registerRejected();
        }
        return fSuccess;
    }

    @Override
    public boolean offerLast(E e) {
        return this.offer(e);
    }

    @Override
    public E removeFirst() {
        Object e = this.poll();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    @Override
    public E removeLast() {
        E e = this.pollLast();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    @Override
    public E pollFirst() {
        return this.poll();
    }

    @Override
    public E pollLast() {
        E oValue;
        QueuePollResult result = this.pollFromTailInternal();
        Binary binary = result.getBinaryElement();
        E e = oValue = binary == null ? null : (E)ExternalizableHelper.fromBinary(binary, this.m_serializer);
        if (oValue == null) {
            this.m_statistics.registerMiss();
        } else {
            this.m_statistics.registerHit();
        }
        return oValue;
    }

    @Override
    public E getFirst() {
        Object e = this.peek();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    @Override
    public E getLast() {
        E e = this.peekLast();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    @Override
    public E peekFirst() {
        return this.peek();
    }

    @Override
    public E peekLast() {
        E oValue;
        QueuePollResult result = this.peekAtTailInternal();
        Binary binary = result.getBinaryElement();
        E e = oValue = binary == null ? null : (E)ExternalizableHelper.fromBinary(binary, this.m_serializer);
        if (oValue == null) {
            this.m_statistics.registerMiss();
        } else {
            this.m_statistics.registerHit();
        }
        return oValue;
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        Map map = this.m_cache.invokeAll(Filters.equal(Extractors.identity(), o), QueueRemove.removeFirst());
        if (map.isEmpty()) {
            return false;
        }
        return (Boolean)map.values().iterator().next();
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        Map map = this.m_cache.invokeAll(Filters.equal(Extractors.identity(), o), QueueRemove.removeLast());
        if (map.isEmpty()) {
            return false;
        }
        return (Boolean)map.values().iterator().next();
    }

    @Override
    public void push(E e) {
        this.addFirst(e);
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    @Override
    public Iterator<E> descendingIterator() {
        return QueuePageIterator.tail(this::createKey, this.m_cache);
    }

    protected QueueOfferResult offerToHeadInternal(E e) {
        long lStart = System.nanoTime();
        QueueOffer<E> processor = new QueueOffer<E>(e);
        QueueOfferResult result = (QueueOfferResult)this.m_cache.invoke(this.m_keyHead.randomHead(), processor);
        long lEnd = System.nanoTime();
        this.m_statistics.offered(lEnd - lStart);
        return result;
    }

    protected QueuePollResult pollFromTailInternal() {
        long lStart = System.nanoTime();
        QueuePollResult result = (QueuePollResult)this.m_cache.invoke(this.m_keyTail, QueuePoll.instance());
        long lEnd = System.nanoTime();
        this.m_statistics.polled(lEnd - lStart);
        return result;
    }

    protected QueuePollResult peekAtTailInternal() {
        long lStart = System.nanoTime();
        QueuePollResult result = (QueuePollResult)this.m_cache.invoke(this.m_keyTail, QueuePeek.instance());
        long lEnd = System.nanoTime();
        this.m_statistics.polled(lEnd - lStart);
        return result;
    }
}

