/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.queue;

import com.tangosol.internal.net.queue.model.QueueKey;
import com.tangosol.internal.net.queue.model.QueuePageResult;
import com.tangosol.internal.net.queue.processor.QueuePage;
import com.tangosol.io.Serializer;
import com.tangosol.net.NamedMap;
import com.tangosol.util.Binary;
import com.tangosol.util.Converter;
import com.tangosol.util.ConverterCollections;
import com.tangosol.util.ExternalizableHelper;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Function;

public class QueuePageIterator<K extends QueueKey, E>
implements Iterator<E> {
    public static final int DEFAULT_PAGE_SIZE = 100;
    private final Function<Long, K> m_fnKey;
    private final NamedMap<K, E> m_cache;
    private final boolean m_fHead;
    private final boolean m_fPoll;
    private final Converter<Binary, E> m_converter;
    private long m_nLastId;
    private Iterator<E> m_iterator;
    private boolean m_fHasNext;
    private final Lock m_lock = new ReentrantLock();
    private final int m_nPageSize;
    private int m_cRemaining;

    private QueuePageIterator(Function<Long, K> fnKey, boolean fHead, boolean fPoll, NamedMap<K, E> cache, int nPageSize, int cMaxElements) {
        this.m_fnKey = fnKey;
        this.m_fHead = fHead;
        this.m_fPoll = fPoll;
        this.m_cache = cache;
        this.m_nLastId = fHead ? Long.MIN_VALUE : Long.MAX_VALUE;
        this.m_fHasNext = true;
        this.m_iterator = Collections.emptyIterator();
        this.m_nPageSize = nPageSize;
        this.m_cRemaining = cMaxElements;
        Serializer serializer = cache.getService().getSerializer();
        this.m_converter = bin -> ExternalizableHelper.fromBinary(bin, serializer);
    }

    @Override
    public boolean hasNext() {
        if (this.m_fHasNext && !this.m_iterator.hasNext()) {
            this.nextPage();
        }
        return this.m_fHasNext;
    }

    @Override
    public E next() {
        if (this.m_fHasNext && !this.m_iterator.hasNext()) {
            this.nextPage();
        }
        return this.m_iterator.next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void nextPage() {
        if (this.m_fHasNext) {
            this.m_lock.lock();
            try {
                int nPage = Math.min(this.m_nPageSize, this.m_cRemaining);
                QueueKey key = (QueueKey)this.m_fnKey.apply(0x7FFFFFFFFFFFFFFEL);
                QueuePageResult result = (QueuePageResult)this.m_cache.invoke(key, new QueuePage(this.m_fHead, nPage, this.m_nLastId, this.m_fPoll));
                List<Binary> list = result.getBinaryList();
                if (list == null || list.isEmpty()) {
                    this.m_fHasNext = false;
                    this.m_iterator = Collections.emptyIterator();
                } else {
                    this.m_cRemaining -= list.size();
                    this.m_iterator = ConverterCollections.getIterator(list.iterator(), this.m_converter);
                    this.m_fHasNext = true;
                    this.m_nLastId = result.getKey();
                }
            }
            finally {
                this.m_lock.unlock();
            }
        }
    }

    public static <K extends QueueKey, E> QueuePageIterator<K, E> head(Function<Long, K> fnKey, NamedMap<K, E> cache) {
        return new QueuePageIterator<K, E>(fnKey, true, false, cache, 100, Integer.MAX_VALUE);
    }

    public static <K extends QueueKey, E> QueuePageIterator<K, E> tail(Function<Long, K> fnKey, NamedMap<K, E> cache) {
        return new QueuePageIterator<K, E>(fnKey, false, false, cache, 100, Integer.MAX_VALUE);
    }

    public static <K extends QueueKey, E> QueuePageIterator<K, E> headPolling(Function<Long, K> fnKey, NamedMap<K, E> cache) {
        return QueuePageIterator.headPolling(fnKey, cache, Integer.MAX_VALUE);
    }

    public static <K extends QueueKey, E> QueuePageIterator<K, E> headPolling(Function<Long, K> fnKey, NamedMap<K, E> cache, int cMax) {
        return new QueuePageIterator<K, E>(fnKey, true, true, cache, 100, cMax);
    }

    public static <K extends QueueKey, E> QueuePageIterator<K, E> tailPolling(Function<Long, K> fnKey, NamedMap<K, E> cache) {
        return new QueuePageIterator<K, E>(fnKey, false, true, cache, 100, Integer.MAX_VALUE);
    }
}

