/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.queue;

import com.tangosol.internal.net.NamedMapCollection;
import com.tangosol.internal.net.queue.NamedMapDeque;
import com.tangosol.internal.net.queue.QueuePageIterator;
import com.tangosol.internal.net.queue.WrapperNamedMapDeque;
import com.tangosol.internal.net.queue.model.QueueKey;
import com.tangosol.net.CacheService;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.NamedBlockingDeque;
import com.tangosol.net.NamedMap;
import com.tangosol.util.MapEvent;
import com.tangosol.util.MapListener;
import com.tangosol.util.filter.AlwaysFilter;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

public class NamedMapBlockingDeque<K extends QueueKey, E>
extends WrapperNamedMapDeque<K, E>
implements NamedBlockingDeque<E>,
MapListener<K, E> {
    final ReentrantLock m_lock = new ReentrantLock();
    private final Condition m_notEmpty = this.m_lock.newCondition();
    private final Condition m_notFull = this.m_lock.newCondition();
    private final int m_nHash;

    public NamedMapBlockingDeque(String sName, NamedMapDeque<K, E> delegate) {
        super(sName, delegate);
        delegate.getNamedMap().addMapListener(this, AlwaysFilter.INSTANCE(), true);
        this.m_nHash = QueueKey.calculateQueueHash(delegate.getName());
    }

    @Override
    public void release() {
        ((NamedMapDeque)this.f_delegate).getNamedMap().removeMapListener(this);
        super.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long prepend(E e, long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        ReentrantLock lock = this.m_lock;
        lock.lockInterruptibly();
        try {
            long nId = this.prepend(e);
            while (nId < 0L) {
                if (nanos <= 0L) {
                    long l = -1L;
                    return l;
                }
                nanos = this.m_notFull.awaitNanos(nanos);
                nId = this.prepend(e);
            }
            long l = nId;
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long prependFirst(E e) throws InterruptedException {
        ReentrantLock lock = this.m_lock;
        lock.lock();
        try {
            long nId = this.prepend(e);
            while (nId < 0L) {
                this.m_notFull.await();
                nId = this.prepend(e);
            }
            long l = nId;
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long append(E e, long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        ReentrantLock lock = this.m_lock;
        lock.lockInterruptibly();
        try {
            long nId = this.append(e);
            while (nId < 0L) {
                if (nanos <= 0L) {
                    long l = -1L;
                    return l;
                }
                nanos = this.m_notFull.awaitNanos(nanos);
                nId = this.append(e);
            }
            long l = nId;
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long appendLast(E e) throws InterruptedException {
        ReentrantLock lock = this.m_lock;
        lock.lock();
        try {
            long nId = this.append(e);
            while (nId < 0L) {
                this.m_notFull.await();
                nId = this.append(e);
            }
            long l = nId;
            return l;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void putFirst(E e) throws InterruptedException {
        ReentrantLock lock = this.m_lock;
        lock.lock();
        try {
            while (!this.offerFirst(e)) {
                this.m_notFull.await();
            }
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void putLast(E e) throws InterruptedException {
        ReentrantLock lock = this.m_lock;
        lock.lock();
        try {
            while (!this.offerLast(e)) {
                this.m_notFull.await();
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offerFirst(E e, long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        ReentrantLock lock = this.m_lock;
        lock.lockInterruptibly();
        try {
            while (!this.offerFirst(e)) {
                if (nanos <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                nanos = this.m_notFull.awaitNanos(nanos);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offerLast(E e, long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        ReentrantLock lock = this.m_lock;
        lock.lockInterruptibly();
        try {
            while (!this.offerLast(e)) {
                if (nanos <= 0L) {
                    boolean bl = false;
                    return bl;
                }
                nanos = this.m_notFull.awaitNanos(nanos);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E takeFirst() throws InterruptedException {
        ReentrantLock lock = this.m_lock;
        lock.lock();
        try {
            Object x;
            while ((x = this.poll()) == null) {
                this.m_notEmpty.await();
            }
            Object e = x;
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E takeLast() throws InterruptedException {
        ReentrantLock lock = this.m_lock;
        lock.lock();
        try {
            Object x;
            while ((x = this.pollLast()) == null) {
                this.m_notEmpty.await();
            }
            Object e = x;
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E pollFirst(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        ReentrantLock lock = this.m_lock;
        lock.lockInterruptibly();
        try {
            Object x;
            while ((x = this.poll()) == null) {
                if (nanos <= 0L) {
                    E e = null;
                    return e;
                }
                nanos = this.m_notEmpty.awaitNanos(nanos);
            }
            Object e = x;
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E pollLast(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        ReentrantLock lock = this.m_lock;
        lock.lockInterruptibly();
        try {
            Object x;
            while ((x = this.pollLast()) == null) {
                if (nanos <= 0L) {
                    E e = null;
                    return e;
                }
                nanos = this.m_notEmpty.awaitNanos(nanos);
            }
            Object e = x;
            return e;
        }
        finally {
            lock.unlock();
        }
    }

    @Override
    public void put(E e) throws InterruptedException {
        this.putLast(e);
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        return this.offerLast(e, timeout, unit);
    }

    @Override
    public E take() throws InterruptedException {
        return this.takeFirst();
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.pollFirst(timeout, unit);
    }

    @Override
    public int remainingCapacity() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int drainTo(Collection<? super E> c) {
        this.assertNotSameCollection(c, "Queue cannot be drained to the same underlying cache");
        QueuePageIterator<QueueKey, E> iterator = QueuePageIterator.headPolling(((NamedMapDeque)this.f_delegate)::createKey, this.getNamedMap());
        int cPolled = 0;
        while (iterator.hasNext()) {
            ++cPolled;
            c.add(iterator.next());
        }
        return cPolled;
    }

    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        this.assertNotSameCollection(c, "Queue cannot be drained to the same underlying cache");
        QueuePageIterator<QueueKey, E> iterator = QueuePageIterator.headPolling(((NamedMapDeque)this.f_delegate)::createKey, this.getNamedMap(), maxElements);
        int cPolled = 0;
        while (iterator.hasNext()) {
            ++cPolled;
            c.add(iterator.next());
        }
        return cPolled;
    }

    @Override
    public void entryInserted(MapEvent<K, E> evt) {
        this.m_lock.lock();
        try {
            this.m_notEmpty.signal();
        }
        finally {
            this.m_lock.unlock();
        }
    }

    @Override
    public void entryUpdated(MapEvent<K, E> evt) {
    }

    @Override
    public void entryDeleted(MapEvent<K, E> evt) {
        this.m_lock.lock();
        try {
            this.m_notFull.signal();
        }
        finally {
            this.m_lock.unlock();
        }
    }

    @Override
    public NamedMap<K, E> getNamedMap() {
        return ((NamedMapDeque)this.f_delegate).getNamedMap();
    }

    private void assertNotSameCollection(Collection<?> c, String sMsg) {
        if (c == null) {
            throw new NullPointerException("target collection cannot be null");
        }
        if (this == c) {
            throw new IllegalArgumentException(sMsg);
        }
        if (c instanceof NamedMapCollection) {
            ConfigurableCacheFactory ccfOther;
            ConfigurableCacheFactory ccfThis;
            CacheService serviceOther;
            String sNameOther;
            CacheService serviceThis;
            String sNameThis;
            NamedMap mapThis = ((NamedMapDeque)this.f_delegate).getNamedMap();
            NamedMap mapOther = ((NamedMapCollection)c).getNamedMap();
            if (mapThis.getName().equals(mapOther.getName()) && (sNameThis = (serviceThis = mapThis.getService()).getInfo().getServiceName()).equals(sNameOther = (serviceOther = mapOther.getService()).getInfo().getServiceName()) && (ccfThis = serviceThis.getBackingMapManager().getCacheFactory()).equals(ccfOther = serviceOther.getBackingMapManager().getCacheFactory())) {
                throw new IllegalArgumentException(sMsg);
            }
        }
    }
}

