/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.queue;

import com.tangosol.internal.net.queue.NamedMapQueue;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.net.NamedCache;
import com.tangosol.net.QueueService;
import com.tangosol.net.queue.QueueStatistics;
import com.tangosol.util.Binary;
import com.tangosol.util.CollectionEvent;
import com.tangosol.util.CollectionListener;
import com.tangosol.util.Converter;
import com.tangosol.util.ConverterCollections;
import com.tangosol.util.Filter;
import java.util.Collection;
import java.util.Objects;

public class ConverterNamedMapQueue<FK, FV, TK, TV>
extends ConverterCollections.ConverterCollection<FV, TV>
implements NamedMapQueue<TK, TV> {
    protected final NamedMapQueue<FK, FV> f_queue;
    protected final Converter<FK, TK> f_convKeyUp;
    protected final Converter<TK, FK> f_convKeyDown;

    public ConverterNamedMapQueue(NamedMapQueue<FK, FV> queue, Converter<FK, TK> convKeyUp, Converter<FV, TV> convUp, Converter<TK, FK> convKeyDown, Converter<TV, FV> convDown) {
        super(queue, convUp, convDown);
        this.f_queue = queue;
        this.f_convKeyUp = convKeyUp;
        this.f_convKeyDown = convKeyDown;
    }

    @Override
    public TK createKey(long id) {
        return (TK)this.f_convKeyUp.convert(this.f_queue.createKey(id));
    }

    @Override
    public boolean addAll(Collection<? extends TV> col) {
        if (col.contains(null)) {
            throw new NullPointerException("null elements are not supported");
        }
        return super.addAll(col);
    }

    @Override
    public NamedCache<TK, TV> getNamedMap() {
        NamedCache cache = (NamedCache)this.f_queue.getNamedMap();
        return ConverterCollections.getNamedCache(cache, this.f_convKeyUp, this.f_convKeyDown, this.m_convUp, this.m_convDown);
    }

    @Override
    public boolean isReady() {
        return this.f_queue.isReady();
    }

    @Override
    public boolean isDestroyed() {
        return this.f_queue.isDestroyed();
    }

    @Override
    public boolean isReleased() {
        return this.f_queue.isReleased();
    }

    @Override
    public void close() {
        this.f_queue.close();
    }

    @Override
    public QueueService getService() {
        return this.f_queue.getService();
    }

    @Override
    public boolean isActive() {
        return this.f_queue.isActive();
    }

    @Override
    public QueueStatistics getQueueStatistics() {
        return this.f_queue.getQueueStatistics();
    }

    @Override
    public int getQueueNameHash() {
        return this.f_queue.getQueueNameHash();
    }

    @Override
    public long append(TV t) {
        return this.f_queue.append(this.getConverterDown().convert(t));
    }

    @Override
    public String getName() {
        return this.f_queue.getName();
    }

    @Override
    public void destroy() {
        this.f_queue.destroy();
    }

    @Override
    public void release() {
        this.f_queue.release();
    }

    @Override
    public void addListener(CollectionListener<? super TV> listener) {
        this.f_queue.addListener(new ConverterListener(listener));
    }

    @Override
    public void removeListener(CollectionListener<? super TV> listener) {
        this.f_queue.removeListener(new ConverterListener(listener));
    }

    @Override
    public void addListener(CollectionListener<? super TV> listener, Filter<TV> filter, boolean fLite) {
        this.f_queue.addListener(new ConverterListener(listener), filter, fLite);
    }

    @Override
    public void removeListener(CollectionListener<? super TV> listener, Filter<TV> filter) {
        this.f_queue.removeListener(new ConverterListener(listener), filter);
    }

    @Override
    public boolean offer(TV t) {
        return this.f_queue.offer(this.getConverterDown().convert(t));
    }

    @Override
    public TV remove() {
        return (TV)this.getConverterUp().convert(this.f_queue.remove());
    }

    @Override
    public TV poll() {
        return (TV)this.getConverterUp().convert(this.f_queue.poll());
    }

    @Override
    public TV element() {
        return (TV)this.getConverterUp().convert(this.f_queue.element());
    }

    @Override
    public TV peek() {
        return (TV)this.getConverterUp().convert(this.f_queue.peek());
    }

    public static <K, E> NamedMapQueue<K, E> createQueue(NamedMapQueue<Binary, Binary> queue) {
        BackingMapManagerContext context = queue.getService().getBackingMapManager().getContext();
        Converter convKeyUp = context.getKeyFromInternalConverter();
        Converter convKeyDown = context.getKeyToInternalConverter();
        Converter convValUp = context.getKeyFromInternalConverter();
        Converter convValDown = context.getKeyToInternalConverter();
        return new ConverterNamedMapQueue(queue, convKeyUp, convValUp, convKeyDown, convValDown);
    }

    private class ConverterListener
    implements CollectionListener<FV> {
        private final CollectionListener<TV> f_listener;

        public ConverterListener(CollectionListener<? super TV> listener) {
            this.f_listener = listener;
        }

        @Override
        public void entryInserted(CollectionEvent<FV> evt) {
            this.f_listener.entryInserted(new ConverterEvent(evt));
        }

        @Override
        public void entryUpdated(CollectionEvent<FV> evt) {
            this.f_listener.entryUpdated(new ConverterEvent(evt));
        }

        @Override
        public void entryDeleted(CollectionEvent<FV> evt) {
            this.f_listener.entryDeleted(new ConverterEvent(evt));
        }

        @Override
        public int characteristics() {
            return this.f_listener.characteristics();
        }

        @Override
        public boolean isAsynchronous() {
            return this.f_listener.isAsynchronous();
        }

        @Override
        public boolean isSynchronous() {
            return this.f_listener.isSynchronous();
        }

        @Override
        public boolean isVersionAware() {
            return this.f_listener.isVersionAware();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConverterListener that = (ConverterListener)o;
            return Objects.equals(this.f_listener, that.f_listener);
        }

        public int hashCode() {
            return Objects.hashCode(this.f_listener);
        }
    }

    protected class ConverterEvent
    implements CollectionEvent<TV> {
        private final CollectionEvent<FV> f_event;

        public ConverterEvent(CollectionEvent<FV> event) {
            this.f_event = event;
        }

        @Override
        public int getId() {
            return this.f_event.getId();
        }

        @Override
        public TV getOldValue() {
            return ConverterNamedMapQueue.this.getConverterUp().convert(this.f_event.getOldValue());
        }

        @Override
        public TV getNewValue() {
            return ConverterNamedMapQueue.this.getConverterUp().convert(this.f_event.getNewValue());
        }

        @Override
        public int getPartition() {
            return this.f_event.getPartition();
        }

        @Override
        public long getVersion() {
            return this.f_event.getVersion();
        }

        @Override
        public boolean isInsert() {
            return this.f_event.isInsert();
        }

        @Override
        public boolean isUpdate() {
            return this.f_event.isUpdate();
        }

        @Override
        public boolean isDelete() {
            return this.f_event.isDelete();
        }
    }
}

