/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.queue;

import com.tangosol.internal.net.queue.model.QueueKey;
import com.tangosol.internal.net.queue.model.QueuePageResult;
import com.tangosol.internal.net.queue.processor.QueuePage;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.net.NamedMap;
import com.tangosol.util.Binary;
import com.tangosol.util.Converter;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class BinaryQueuePageIterator
implements Iterator<Binary> {
    public static final int DEFAULT_PAGE_SIZE = 100;
    private final int m_nQueueHash;
    private final NamedMap<Binary, Binary> m_cache;
    private final boolean m_fHead;
    private final boolean m_fPoll;
    private long m_nLastId;
    private Iterator<Binary> m_iterator;
    private boolean m_fHasNext;
    private final Lock m_lock = new ReentrantLock();
    private final int m_nPageSize;
    private final Converter<QueueKey, Binary> m_converterKey;
    private final Converter<Binary, Object> m_converterValue;
    private int m_cRemaining;

    private BinaryQueuePageIterator(int nQueueHash, boolean fHead, boolean fPoll, NamedMap<Binary, Binary> cache, int nPageSize, int cMaxElements) {
        this.m_nQueueHash = nQueueHash;
        this.m_fHead = fHead;
        this.m_fPoll = fPoll;
        this.m_cache = cache;
        this.m_nLastId = fHead ? Long.MIN_VALUE : Long.MAX_VALUE;
        this.m_fHasNext = true;
        this.m_iterator = Collections.emptyIterator();
        this.m_nPageSize = nPageSize;
        this.m_cRemaining = cMaxElements;
        BackingMapManagerContext context = cache.getService().getBackingMapManager().getContext();
        this.m_converterKey = context.getKeyToInternalConverter();
        this.m_converterValue = context.getValueFromInternalConverter();
    }

    @Override
    public boolean hasNext() {
        if (this.m_fHasNext && !this.m_iterator.hasNext()) {
            this.nextPage();
        }
        return this.m_fHasNext;
    }

    @Override
    public Binary next() {
        if (this.m_fHasNext && !this.m_iterator.hasNext()) {
            this.nextPage();
        }
        return this.m_iterator.next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void nextPage() {
        if (this.m_fHasNext) {
            this.m_lock.lock();
            try {
                int nPage = Math.min(this.m_nPageSize, this.m_cRemaining);
                QueueKey key = new QueueKey(this.m_nQueueHash, 0x7FFFFFFFFFFFFFFEL);
                Binary binKey = (Binary)this.m_converterKey.convert(key);
                Binary binary = (Binary)this.m_cache.invoke(binKey, new QueuePage(this.m_fHead, nPage, this.m_nLastId, this.m_fPoll));
                QueuePageResult result = (QueuePageResult)this.m_converterValue.convert(binary);
                List<Binary> list = result.getBinaryList();
                if (list.isEmpty()) {
                    this.m_fHasNext = false;
                    this.m_iterator = Collections.emptyIterator();
                } else {
                    this.m_cRemaining -= list.size();
                    this.m_iterator = list.iterator();
                    this.m_fHasNext = true;
                    this.m_nLastId = result.getKey();
                }
            }
            finally {
                this.m_lock.unlock();
            }
        }
    }

    public static BinaryQueuePageIterator head(int nQueueHash, NamedMap<Binary, Binary> cache) {
        return new BinaryQueuePageIterator(nQueueHash, true, false, cache, 100, Integer.MAX_VALUE);
    }

    public static BinaryQueuePageIterator tail(int nQueueHash, NamedMap<Binary, Binary> cache) {
        return new BinaryQueuePageIterator(nQueueHash, false, false, cache, 100, Integer.MAX_VALUE);
    }

    public static BinaryQueuePageIterator headPolling(int nQueueHash, NamedMap<Binary, Binary> cache) {
        return BinaryQueuePageIterator.headPolling(nQueueHash, cache, Integer.MAX_VALUE);
    }

    public static BinaryQueuePageIterator headPolling(int nQueueHash, NamedMap<Binary, Binary> cache, int cMax) {
        return new BinaryQueuePageIterator(nQueueHash, true, true, cache, 100, cMax);
    }

    public static BinaryQueuePageIterator tailPolling(int nQueueHash, NamedMap<Binary, Binary> cache) {
        return new BinaryQueuePageIterator(nQueueHash, false, true, cache, 100, Integer.MAX_VALUE);
    }
}

