/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.queue;

import com.tangosol.internal.net.queue.BaseBinaryNamedMapQueue;
import com.tangosol.internal.net.queue.BinaryQueuePageIterator;
import com.tangosol.internal.net.queue.model.QueueOfferResult;
import com.tangosol.internal.net.queue.model.QueuePollResult;
import com.tangosol.internal.net.queue.processor.QueueOffer;
import com.tangosol.internal.net.queue.processor.QueuePeek;
import com.tangosol.internal.net.queue.processor.QueuePoll;
import com.tangosol.net.ExtensibleConfigurableCacheFactory;
import com.tangosol.net.NamedMap;
import com.tangosol.net.Session;
import com.tangosol.net.options.WithClassLoader;
import com.tangosol.util.Binary;
import com.tangosol.util.NullImplementation;
import java.util.Iterator;

public class BinaryNamedMapQueue
extends BaseBinaryNamedMapQueue {
    public BinaryNamedMapQueue(String sName, Session session) {
        this(sName, (NamedMap<Binary, Binary>)session.getCache(sName, WithClassLoader.nullImplementation()));
    }

    public BinaryNamedMapQueue(String sName, ExtensibleConfigurableCacheFactory eccf) {
        this(sName, (NamedMap<Binary, Binary>)eccf.ensureCache(sName, NullImplementation.getClassLoader()));
    }

    public BinaryNamedMapQueue(String sName, NamedMap<Binary, Binary> cache) {
        super(sName, cache);
    }

    @Override
    public Iterator<Binary> iterator() {
        return BinaryQueuePageIterator.head(this.m_nHash, this.m_cache);
    }

    @Override
    protected QueueOfferResult offerToTailInternal(Binary e) {
        long lStart = System.nanoTime();
        QueueOffer processor = new QueueOffer(e);
        Binary binKey = (Binary)this.m_converterKeyToInternal.convert(this.m_keyTail.randomTail());
        Binary binResult = (Binary)this.m_cache.invoke(binKey, processor);
        QueueOfferResult result = (QueueOfferResult)this.m_converterValueFromInternal.convert(binResult);
        long lEnd = System.nanoTime();
        this.m_statistics.offered(lEnd - lStart);
        return result;
    }

    @Override
    protected QueuePollResult pollFromHeadInternal() {
        long lStart = System.nanoTime();
        QueuePoll poll = QueuePoll.instance();
        Binary binResult = (Binary)this.m_cache.invoke(this.m_binKeyHead, poll);
        QueuePollResult result = (QueuePollResult)this.m_converterValueFromInternal.convert(binResult);
        long lEnd = System.nanoTime();
        this.m_statistics.polled(lEnd - lStart);
        return result;
    }

    @Override
    protected QueuePollResult peekAtHeadInternal() {
        long lStart = System.nanoTime();
        QueuePeek peek = QueuePeek.instance();
        Binary binResult = (Binary)this.m_cache.invoke(this.m_binKeyHead, peek);
        QueuePollResult result = (QueuePollResult)this.m_converterValueFromInternal.convert(binResult);
        long lEnd = System.nanoTime();
        this.m_statistics.polled(lEnd - lStart);
        return result;
    }
}

