/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.queue;

import com.tangosol.internal.net.queue.BinaryNamedMapQueue;
import com.tangosol.internal.net.queue.BinaryQueuePageIterator;
import com.tangosol.internal.net.queue.NamedMapDeque;
import com.tangosol.internal.net.queue.model.QueueOfferResult;
import com.tangosol.internal.net.queue.model.QueuePollResult;
import com.tangosol.internal.net.queue.processor.QueueOffer;
import com.tangosol.internal.net.queue.processor.QueuePeek;
import com.tangosol.internal.net.queue.processor.QueuePoll;
import com.tangosol.internal.net.queue.processor.QueueRemove;
import com.tangosol.net.ExtensibleConfigurableCacheFactory;
import com.tangosol.net.NamedMap;
import com.tangosol.net.Session;
import com.tangosol.net.options.WithClassLoader;
import com.tangosol.util.Binary;
import com.tangosol.util.Extractors;
import com.tangosol.util.Filters;
import com.tangosol.util.NullImplementation;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;

public class BinaryNamedMapDeque
extends BinaryNamedMapQueue
implements NamedMapDeque<Binary, Binary> {
    public BinaryNamedMapDeque(String sName, Session session) {
        this(sName, (NamedMap<Binary, Binary>)session.getCache(sName, WithClassLoader.nullImplementation()));
    }

    public BinaryNamedMapDeque(String sName, ExtensibleConfigurableCacheFactory eccf) {
        this(sName, (NamedMap<Binary, Binary>)eccf.ensureCache(sName, NullImplementation.getClassLoader()));
    }

    public BinaryNamedMapDeque(String sName, NamedMap<Binary, Binary> cache) {
        super(Objects.requireNonNull(sName), Objects.requireNonNull(cache));
    }

    @Override
    public long prepend(Binary e) {
        boolean fSuccess;
        QueueOfferResult result = this.offerToHeadInternal(e);
        boolean bl = fSuccess = result.getResult() == 1;
        if (fSuccess) {
            this.m_statistics.registerAccepted();
        } else {
            this.m_statistics.registerRejected();
        }
        return fSuccess ? result.getId() : Long.MIN_VALUE;
    }

    @Override
    public void addFirst(Binary e) {
        QueueOfferResult result = this.offerToHeadInternal(e);
        int nStatus = result.getResult();
        if (nStatus == 2) {
            this.m_statistics.registerRejected();
            throw new IllegalStateException("Queue " + this.m_sName + " is full");
        }
        this.m_statistics.registerAccepted();
    }

    @Override
    public void addLast(Binary e) {
        QueueOfferResult result = this.offerToTailInternal(e);
        int nStatus = result.getResult();
        if (nStatus == 2) {
            this.m_statistics.registerRejected();
            throw new IllegalStateException("Queue " + this.m_sName + " is full");
        }
        this.m_statistics.registerAccepted();
    }

    @Override
    public boolean offerFirst(Binary e) {
        boolean fSuccess;
        QueueOfferResult result = this.offerToHeadInternal(e);
        boolean bl = fSuccess = result.getResult() == 1;
        if (fSuccess) {
            this.m_statistics.registerAccepted();
        } else {
            this.m_statistics.registerRejected();
        }
        return fSuccess;
    }

    @Override
    public boolean offerLast(Binary e) {
        return this.offer(e);
    }

    @Override
    public Binary removeFirst() {
        Binary e = this.poll();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    @Override
    public Binary removeLast() {
        Binary e = this.pollLast();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    @Override
    public Binary pollFirst() {
        return this.poll();
    }

    @Override
    public Binary pollLast() {
        QueuePollResult result = this.pollFromTailInternal();
        Binary binary = result.getBinaryElement();
        if (binary == null) {
            this.m_statistics.registerMiss();
        } else {
            this.m_statistics.registerHit();
        }
        return binary;
    }

    @Override
    public Binary getFirst() {
        Binary e = this.peek();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    @Override
    public Binary getLast() {
        Binary e = this.peekLast();
        if (e == null) {
            throw new NoSuchElementException();
        }
        return e;
    }

    @Override
    public Binary peekFirst() {
        return this.peek();
    }

    @Override
    public Binary peekLast() {
        QueuePollResult result = this.peekAtTailInternal();
        Binary binary = result.getBinaryElement();
        if (binary == null) {
            this.m_statistics.registerMiss();
        } else {
            this.m_statistics.registerHit();
        }
        return binary;
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        QueueRemove remove = QueueRemove.removeFirst();
        Map map = this.m_cache.invokeAll(Filters.equal(Extractors.identity(), o), remove);
        if (map.isEmpty()) {
            return false;
        }
        return (Boolean)this.m_converterValueFromInternal.convert((Binary)map.values().iterator().next());
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        QueueRemove remove = QueueRemove.removeLast();
        Map map = this.m_cache.invokeAll(Filters.equal(Extractors.identity(), o), remove);
        if (map.isEmpty()) {
            return false;
        }
        return (Boolean)this.m_converterValueFromInternal.convert((Binary)map.values().iterator().next());
    }

    @Override
    public void push(Binary e) {
        this.addFirst(e);
    }

    @Override
    public Binary pop() {
        return this.removeFirst();
    }

    @Override
    public Iterator<Binary> descendingIterator() {
        return BinaryQueuePageIterator.tail(this.m_keyHead.getHash(), this.m_cache);
    }

    protected QueueOfferResult offerToHeadInternal(Binary e) {
        long lStart = System.nanoTime();
        QueueOffer processor = new QueueOffer(e);
        Binary binKey = (Binary)this.m_converterKeyToInternal.convert(this.m_keyHead.randomHead());
        Binary binary = (Binary)this.m_cache.invoke(binKey, processor);
        QueueOfferResult result = (QueueOfferResult)this.m_converterValueFromInternal.convert(binary);
        long lEnd = System.nanoTime();
        this.m_statistics.offered(lEnd - lStart);
        return result;
    }

    protected QueuePollResult pollFromTailInternal() {
        long lStart = System.nanoTime();
        QueuePoll poll = QueuePoll.instance();
        Binary binary = (Binary)this.m_cache.invoke(this.m_binKeyTail, poll);
        QueuePollResult result = (QueuePollResult)this.m_converterValueFromInternal.convert(binary);
        long lEnd = System.nanoTime();
        this.m_statistics.polled(lEnd - lStart);
        return result;
    }

    protected QueuePollResult peekAtTailInternal() {
        long lStart = System.nanoTime();
        QueuePeek peek = QueuePeek.instance();
        Binary binary = (Binary)this.m_cache.invoke(this.m_binKeyTail, peek);
        QueuePollResult result = (QueuePollResult)this.m_converterValueFromInternal.convert(binary);
        long lEnd = System.nanoTime();
        this.m_statistics.polled(lEnd - lStart);
        return result;
    }
}

