/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.queue;

import com.tangosol.internal.net.NamedMapValuesCollection;
import com.tangosol.internal.net.queue.CacheQueueService;
import com.tangosol.internal.net.queue.NamedMapQueue;
import com.tangosol.internal.net.queue.SimpleQueueStatistics;
import com.tangosol.internal.net.queue.extractor.QueueKeyExtractor;
import com.tangosol.internal.net.queue.model.QueueKey;
import com.tangosol.internal.net.queue.model.QueueOfferResult;
import com.tangosol.internal.net.queue.model.QueuePollResult;
import com.tangosol.io.Serializer;
import com.tangosol.net.CacheService;
import com.tangosol.net.NamedMap;
import com.tangosol.net.QueueService;
import com.tangosol.net.queue.MutableQueueStatistics;
import com.tangosol.net.queue.QueueStatistics;
import com.tangosol.util.Binary;
import com.tangosol.util.CollectionListener;
import com.tangosol.util.ExternalizableHelper;
import com.tangosol.util.Filter;
import com.tangosol.util.transformer.MapListenerCollectionListener;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;

public abstract class BaseNamedMapQueue<K extends QueueKey, E>
extends NamedMapValuesCollection<K, E>
implements NamedMapQueue<K, E> {
    protected final QueueService m_service;
    protected final Serializer m_serializer;
    protected final MutableQueueStatistics m_statistics;
    protected final QueueKey m_keyHead;
    protected final QueueKey m_keyTail;

    public BaseNamedMapQueue(String sName, NamedMap<K, E> cache) {
        super(Objects.requireNonNull(sName), Objects.requireNonNull(cache));
        this.m_service = BaseNamedMapQueue.ensureQueueService(cache.getService());
        this.m_serializer = this.m_service.getSerializer();
        this.m_statistics = new SimpleQueueStatistics();
        this.m_keyHead = QueueKey.head(this.m_sName);
        this.m_keyTail = QueueKey.tail(this.m_sName);
        this.m_cache.addIndex(QueueKeyExtractor.instance(), true, null);
    }

    @Override
    public K createKey(long id) {
        return (K)new QueueKey(this.m_keyHead.getHash(), id);
    }

    @Override
    public QueueService getService() {
        return this.m_service;
    }

    @Override
    public QueueStatistics getQueueStatistics() {
        return this.m_statistics;
    }

    @Override
    public int getQueueNameHash() {
        return this.m_keyHead.getHash();
    }

    @Override
    public void addListener(CollectionListener<? super E> listener) {
        MapListenerCollectionListener wrapper = new MapListenerCollectionListener(listener);
        this.m_cache.addMapListener(wrapper);
    }

    @Override
    public void removeListener(CollectionListener<? super E> listener) {
        MapListenerCollectionListener wrapper = new MapListenerCollectionListener(listener);
        this.m_cache.removeMapListener(wrapper);
    }

    @Override
    public void addListener(CollectionListener<? super E> listener, Filter<E> filter, boolean fLite) {
        MapListenerCollectionListener wrapper = new MapListenerCollectionListener(listener);
        this.m_cache.addMapListener(wrapper, filter, fLite);
    }

    @Override
    public void removeListener(CollectionListener<? super E> listener, Filter<E> filter) {
        MapListenerCollectionListener wrapper = new MapListenerCollectionListener(listener);
        this.m_cache.removeMapListener(wrapper, filter);
    }

    @Override
    public boolean add(E e) {
        return this.offer(e);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.assertNotSameCollection(c, "This collection cannot be added to itself or the same underlying cache");
        for (E e : c) {
            if (this.offer(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public E element() {
        E element;
        QueuePollResult result = this.peekAtHeadInternal();
        Binary binary = result.getBinaryElement();
        E e = element = binary == null ? null : (E)ExternalizableHelper.fromBinary(binary, this.m_serializer);
        if (element != null) {
            this.m_statistics.registerHit();
            return element;
        }
        this.m_statistics.registerMiss();
        throw new NoSuchElementException();
    }

    @Override
    public long append(E e) {
        boolean fSuccess;
        this.assertNotNull(e);
        QueueOfferResult result = this.offerToTailInternal(e);
        boolean bl = fSuccess = result.getResult() == 1;
        if (fSuccess) {
            this.m_statistics.registerAccepted();
        } else {
            this.m_statistics.registerRejected();
        }
        return fSuccess ? result.getId() : Long.MIN_VALUE;
    }

    @Override
    public boolean offer(E e) {
        long id = this.append(e);
        return id >= 0L;
    }

    @Override
    public E peek() {
        E oValue;
        QueuePollResult result = this.peekAtHeadInternal();
        Binary binary = result.getBinaryElement();
        E e = oValue = binary == null ? null : (E)ExternalizableHelper.fromBinary(binary, this.m_serializer);
        if (oValue == null) {
            this.m_statistics.registerMiss();
        } else {
            this.m_statistics.registerHit();
        }
        return oValue;
    }

    @Override
    public E poll() {
        E oValue;
        QueuePollResult result = this.pollFromHeadInternal();
        Binary binary = result.getBinaryElement();
        E e = oValue = binary == null ? null : (E)ExternalizableHelper.fromBinary(binary, this.m_serializer);
        if (oValue == null) {
            this.m_statistics.registerMiss();
        } else {
            this.m_statistics.registerHit();
        }
        return oValue;
    }

    @Override
    public E remove() {
        E element;
        QueuePollResult result = this.pollFromHeadInternal();
        Binary binary = result.getBinaryElement();
        E e = element = binary == null ? null : (E)ExternalizableHelper.fromBinary(binary, this.m_serializer);
        if (element != null) {
            this.m_statistics.registerHit();
            return element;
        }
        this.m_statistics.registerMiss();
        throw new NoSuchElementException();
    }

    @Override
    public abstract Iterator<E> iterator();

    @Override
    public Object[] toArray() {
        return this.toArrayInternal(null);
    }

    @Override
    public <T> T[] toArray(T[] ao) {
        return this.toArrayInternal(ao);
    }

    public String toString() {
        StringBuilder s = new StringBuilder().append(this.getClass().getSimpleName()).append("{name=\"").append(this.m_sName).append("\"").append(", metrics={");
        this.getQueueStatistics().logTo(s);
        s.append("}");
        return s.toString();
    }

    protected static QueueService ensureQueueService(CacheService cacheService) {
        if (cacheService instanceof QueueService) {
            return (QueueService)cacheService;
        }
        return new CacheQueueService(cacheService);
    }

    protected abstract QueueOfferResult offerToTailInternal(E var1);

    protected abstract QueuePollResult pollFromHeadInternal();

    protected abstract QueuePollResult peekAtHeadInternal();

    protected Object[] toArrayInternal(Object[] ao) {
        int c = this.size();
        if (ao == null) {
            ao = new Object[c];
        } else if (ao.length < c) {
            ao = (Object[])Array.newInstance(ao.getClass().getComponentType(), c);
        } else if (ao.length > c) {
            ao[c] = null;
        }
        Iterator<E> iter = this.iterator();
        for (int i = 0; i < c; ++i) {
            try {
                ao[i] = iter.next();
                continue;
            }
            catch (ArrayStoreException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ConcurrentModificationException("element " + i + ": " + e.getMessage());
            }
        }
        return ao;
    }
}

