/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.queue;

import com.tangosol.internal.net.NamedMapValuesCollection;
import com.tangosol.internal.net.queue.CacheQueueService;
import com.tangosol.internal.net.queue.NamedMapQueue;
import com.tangosol.internal.net.queue.SimpleQueueStatistics;
import com.tangosol.internal.net.queue.extractor.QueueKeyExtractor;
import com.tangosol.internal.net.queue.model.QueueKey;
import com.tangosol.internal.net.queue.model.QueueOfferResult;
import com.tangosol.internal.net.queue.model.QueuePollResult;
import com.tangosol.net.BackingMapManagerContext;
import com.tangosol.net.CacheService;
import com.tangosol.net.NamedMap;
import com.tangosol.net.QueueService;
import com.tangosol.net.queue.MutableQueueStatistics;
import com.tangosol.net.queue.QueueStatistics;
import com.tangosol.util.Binary;
import com.tangosol.util.CollectionListener;
import com.tangosol.util.Converter;
import com.tangosol.util.Filter;
import com.tangosol.util.transformer.MapListenerCollectionListener;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;

public abstract class BaseBinaryNamedMapQueue
extends NamedMapValuesCollection<Binary, Binary>
implements NamedMapQueue<Binary, Binary> {
    protected final QueueService m_service;
    protected final MutableQueueStatistics m_statistics;
    protected final Converter<Object, Binary> m_converterKeyToInternal;
    protected final Converter<Object, Binary> m_converterValueToInternal;
    protected final Converter<Binary, Object> m_converterValueFromInternal;
    protected final int m_nHash;
    protected final QueueKey m_keyHead;
    protected final Binary m_binKeyHead;
    protected final QueueKey m_keyTail;
    protected final Binary m_binKeyTail;

    public BaseBinaryNamedMapQueue(String sName, NamedMap<Binary, Binary> map) {
        super(Objects.requireNonNull(sName), Objects.requireNonNull(map));
        CacheService service = map.getService();
        BackingMapManagerContext context = service.getBackingMapManager().getContext();
        this.m_service = BaseBinaryNamedMapQueue.ensureQueueService(service);
        this.m_converterKeyToInternal = context.getKeyToInternalConverter();
        this.m_converterValueToInternal = context.getValueToInternalConverter();
        this.m_converterValueFromInternal = context.getValueFromInternalConverter();
        this.m_keyHead = QueueKey.head(this.m_sName);
        this.m_nHash = this.m_keyHead.getHash();
        this.m_binKeyHead = (Binary)this.m_converterKeyToInternal.convert(this.m_keyHead);
        this.m_keyTail = QueueKey.tail(this.m_sName);
        this.m_binKeyTail = (Binary)this.m_converterKeyToInternal.convert(this.m_keyTail);
        this.m_statistics = new SimpleQueueStatistics();
        this.m_cache.addIndex(QueueKeyExtractor.instance(), true, null);
    }

    @Override
    public Binary createKey(long id) {
        return (Binary)this.m_converterKeyToInternal.convert(new QueueKey(this.m_nHash, id));
    }

    @Override
    public QueueService getService() {
        return this.m_service;
    }

    @Override
    public QueueStatistics getQueueStatistics() {
        return this.m_statistics;
    }

    @Override
    public int getQueueNameHash() {
        return this.m_nHash;
    }

    @Override
    public void addListener(CollectionListener<? super Binary> listener) {
        MapListenerCollectionListener wrapper = new MapListenerCollectionListener(listener);
        this.m_cache.addMapListener(wrapper);
    }

    @Override
    public void removeListener(CollectionListener<? super Binary> listener) {
        MapListenerCollectionListener wrapper = new MapListenerCollectionListener(listener);
        this.m_cache.removeMapListener(wrapper);
    }

    @Override
    public void addListener(CollectionListener<? super Binary> listener, Filter<Binary> filter, boolean fLite) {
        MapListenerCollectionListener wrapper = new MapListenerCollectionListener(listener);
        this.m_cache.addMapListener(wrapper, filter, fLite);
    }

    @Override
    public void removeListener(CollectionListener<? super Binary> listener, Filter<Binary> filter) {
        MapListenerCollectionListener wrapper = new MapListenerCollectionListener(listener);
        this.m_cache.removeMapListener(wrapper, filter);
    }

    @Override
    public boolean add(Binary e) {
        return this.offer(e);
    }

    @Override
    public boolean addAll(Collection<? extends Binary> c) {
        this.assertNotSameCollection(c, "This collection cannot be added to itself or the same underlying cache");
        for (Binary binary : c) {
            if (this.offer(binary)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Binary element() {
        QueuePollResult result = this.peekAtHeadInternal();
        Binary binary = result.getBinaryElement();
        if (binary != null) {
            this.m_statistics.registerHit();
            return binary;
        }
        this.m_statistics.registerMiss();
        throw new NoSuchElementException();
    }

    @Override
    public long append(Binary e) {
        boolean fSuccess;
        this.assertNotNull(e);
        QueueOfferResult result = this.offerToTailInternal(e);
        boolean bl = fSuccess = result.getResult() == 1;
        if (fSuccess) {
            this.m_statistics.registerAccepted();
        } else {
            this.m_statistics.registerRejected();
        }
        return fSuccess ? result.getId() : Long.MIN_VALUE;
    }

    @Override
    public boolean offer(Binary e) {
        long id = this.append(e);
        return id >= 0L;
    }

    @Override
    public Binary peek() {
        QueuePollResult result = this.peekAtHeadInternal();
        Binary binary = result.getBinaryElement();
        if (binary == null) {
            this.m_statistics.registerMiss();
        } else {
            this.m_statistics.registerHit();
        }
        return binary;
    }

    @Override
    public Binary poll() {
        QueuePollResult result = this.pollFromHeadInternal();
        Binary binary = result.getBinaryElement();
        if (binary == null) {
            this.m_statistics.registerMiss();
        } else {
            this.m_statistics.registerHit();
        }
        return binary;
    }

    @Override
    public Binary remove() {
        QueuePollResult result = this.pollFromHeadInternal();
        Binary binary = result.getBinaryElement();
        if (binary != null) {
            this.m_statistics.registerHit();
            return binary;
        }
        this.m_statistics.registerMiss();
        throw new NoSuchElementException();
    }

    @Override
    public abstract Iterator<Binary> iterator();

    @Override
    public Object[] toArray() {
        return this.toArrayInternal(null);
    }

    @Override
    public <T> T[] toArray(T[] ao) {
        return this.toArrayInternal(ao);
    }

    public String toString() {
        StringBuilder s = new StringBuilder().append(this.getClass().getSimpleName()).append("{name=\"").append(this.m_sName).append("\"").append(", metrics={");
        this.getQueueStatistics().logTo(s);
        s.append("}");
        return s.toString();
    }

    protected static QueueService ensureQueueService(CacheService cacheService) {
        if (cacheService instanceof QueueService) {
            return (QueueService)cacheService;
        }
        return new CacheQueueService(cacheService);
    }

    protected abstract QueueOfferResult offerToTailInternal(Binary var1);

    protected abstract QueuePollResult pollFromHeadInternal();

    protected abstract QueuePollResult peekAtHeadInternal();

    protected Object[] toArrayInternal(Object[] ao) {
        int c = this.size();
        if (ao == null) {
            ao = new Object[c];
        } else if (ao.length < c) {
            ao = (Object[])Array.newInstance(ao.getClass().getComponentType(), c);
        } else if (ao.length > c) {
            ao[c] = null;
        }
        Iterator<Binary> iter = this.iterator();
        for (int i = 0; i < c; ++i) {
            try {
                ao[i] = iter.next();
                continue;
            }
            catch (ArrayStoreException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw new ConcurrentModificationException("element " + i + ": " + e.getMessage());
            }
        }
        return ao;
    }
}

