/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.metrics;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.coherence.config.Config;
import com.tangosol.internal.metrics.MetricsHttpHandler;
import com.tangosol.internal.net.service.grid.DefaultProxyServiceDependencies;
import com.tangosol.internal.net.service.grid.LegacyXmlProxyServiceHelper;
import com.tangosol.internal.net.service.grid.ProxyServiceDependencies;
import com.tangosol.internal.net.service.peer.acceptor.HttpAcceptorDependencies;
import com.tangosol.net.CacheFactory;
import com.tangosol.net.Cluster;
import com.tangosol.net.OperationalContext;
import com.tangosol.net.ProxyService;
import com.tangosol.net.Service;
import com.tangosol.run.xml.XmlDocument;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Base;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;

public abstract class MetricsHttpHelper {
    public static MetricsHttpHandler s_metricsHandler;
    public static final String PROP_METRICS_ENABLED = "coherence.metrics.http.enabled";
    public static final String METRICS_CONFIG = "metrics-http-config.xml";
    public static final int DEFAULT_PROMETHEUS_METRICS_PORT = 9612;

    public static URL composeURL(String sHost, int nPort) throws MalformedURLException {
        return MetricsHttpHelper.composeURL(sHost, nPort, "http");
    }

    public static URL composeURL(String sHost, int nPort, String sProtocol) throws MalformedURLException {
        return new URL(sProtocol, sHost, nPort, s_metricsHandler == null ? "/metrics" : s_metricsHandler.getPath());
    }

    public static ProxyServiceDependencies getDependencies(OperationalContext ctx) {
        ClassLoader loader = Base.getContextClassLoader();
        URL urlConfig = loader.getResource(METRICS_CONFIG);
        if (urlConfig == null) {
            throw new IllegalStateException("Unable to locate metrics-http-config.xml");
        }
        XmlDocument xml = XmlHelper.loadXml(urlConfig);
        XmlHelper.replaceSystemProperties(xml, "system-property");
        return LegacyXmlProxyServiceHelper.fromXml(xml, new DefaultProxyServiceDependencies(), ctx, loader);
    }

    public static String getServiceName() {
        return "MetricsHttpProxy";
    }

    public static void ensureMetricsService(Map<Service, String> mapServices) {
        boolean fEnabled = Config.getBoolean(PROP_METRICS_ENABLED, false);
        if (fEnabled) {
            Cluster cluster = CacheFactory.ensureCluster();
            if (cluster.getManagement() == null) {
                Logger.err("Metrics over HTTP is not available due to management not being enabled");
            } else {
                ProxyServiceDependencies deps = MetricsHttpHelper.getDependencies((OperationalContext)((Object)cluster));
                Map.Entry<String, Object> entryResource = ((HttpAcceptorDependencies)deps.getAcceptorDependencies()).getResourceConfig().entrySet().iterator().next();
                s_metricsHandler = (MetricsHttpHandler)entryResource.getValue();
                s_metricsHandler.setPath(entryResource.getKey());
                ProxyService service = (ProxyService)cluster.ensureService(MetricsHttpHelper.getServiceName(), "Proxy");
                if (service.getDependencies() == null) {
                    service.setDependencies(deps);
                }
                service.start();
                mapServices.put(service, MetricsHttpHelper.getServiceName());
            }
        }
    }
}

