/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.management.model;

import com.oracle.coherence.common.base.Exceptions;
import com.tangosol.internal.net.management.model.ModelAttribute;
import com.tangosol.net.management.OpenMBeanHelper;
import com.tangosol.net.metrics.MBeanMetric;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.management.Descriptor;
import javax.management.MBeanAttributeInfo;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenMBeanAttributeInfoSupport;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import javax.management.openmbean.TabularType;

public abstract class TabularModel<R, M>
implements ModelAttribute<M> {
    private final String f_sName;
    private final String f_sDescription;
    private final ModelAttribute<R>[] f_aAttribute;
    private final String[] f_asAttributeNames;
    private final Function<M, Integer> f_fnRowCount;
    private final BiFunction<M, Integer, R> f_fnRow;
    private final TabularType f_tableType;
    private final CompositeType f_rowType;
    private final boolean f_fHasMetrics;
    private final MBeanMetric.Scope f_metricScope;
    private volatile MBeanAttributeInfo m_attribute;

    protected TabularModel(String sName, String sDescription, String sKeyName, ModelAttribute<R>[] aAttribute, Function<M, Integer> fnRowCount, BiFunction<M, Integer, R> fnRow) {
        int cAttribute = aAttribute.length;
        this.f_sName = sName;
        this.f_sDescription = sDescription;
        this.f_aAttribute = aAttribute;
        this.f_asAttributeNames = new String[cAttribute];
        this.f_fnRowCount = fnRowCount;
        this.f_fnRow = fnRow;
        String[] asDescr = new String[cAttribute];
        OpenType[] aoType = new OpenType[cAttribute];
        boolean fHasMetrics = false;
        MBeanMetric.Scope scope = MBeanMetric.Scope.VENDOR;
        boolean fKeyFound = false;
        for (int i = 0; i < cAttribute; ++i) {
            String sAttributeName;
            ModelAttribute<R> attribute = aAttribute[i];
            this.f_asAttributeNames[i] = sAttributeName = attribute.getName();
            if (attribute.isMetric()) {
                fHasMetrics = true;
                scope = attribute.getMetricScope();
            }
            asDescr[i] = sAttributeName;
            aoType[i] = attribute.getType();
            fKeyFound = fKeyFound || sAttributeName.equals(sKeyName);
        }
        if (!fKeyFound) {
            throw new IllegalArgumentException("The key attribute \"" + sKeyName + "\" could not be found in the attributes array " + Arrays.toString(this.f_asAttributeNames));
        }
        this.f_fHasMetrics = fHasMetrics;
        this.f_metricScope = scope;
        this.f_rowType = OpenMBeanHelper.createCompositeType(sKeyName, sDescription, this.f_asAttributeNames, asDescr, aoType);
        this.f_tableType = OpenMBeanHelper.createTabularType(sKeyName, sDescription, this.f_rowType, new String[]{sKeyName});
    }

    @Override
    public String getName() {
        return this.f_sName;
    }

    @Override
    public String getDescription() {
        return this.f_sDescription;
    }

    @Override
    public Function<M, ?> getFunction() {
        return this::getTabularData;
    }

    public TabularType getType() {
        return this.f_tableType;
    }

    @Override
    public MBeanAttributeInfo getMBeanAttributeInfo() {
        MBeanAttributeInfo info = this.m_attribute;
        if (info == null) {
            DescriptorSupport descriptor = new DescriptorSupport();
            descriptor.setField("metric.scope", this.f_metricScope.name());
            if (this.f_fHasMetrics) {
                descriptor.setField("metric.scope", MBeanMetric.Scope.VENDOR.name());
                descriptor.setField("metrics.value", this.f_sName);
                for (ModelAttribute<R> attribute : this.f_aAttribute) {
                    if (!attribute.isMetric()) continue;
                    String sName = attribute.getName();
                    Descriptor desc = attribute.getMBeanAttributeInfo().getDescriptor();
                    descriptor.setField(sName + ".metric.scope", desc.getFieldValue("metric.scope"));
                    descriptor.setField(sName + ".metrics.value", desc.getFieldValue("metrics.value"));
                    descriptor.setField(sName + ".metric.labels", desc.getFieldValue("metric.labels"));
                }
                String[] asMetricNames = (String[])Arrays.stream(this.f_aAttribute).filter(ModelAttribute::isMetric).map(ModelAttribute::getName).toArray(String[]::new);
                descriptor.setField("metrics.columns", asMetricNames);
            }
            info = this.m_attribute = new OpenMBeanAttributeInfoSupport(this.f_sName, this.f_sDescription, this.f_tableType, true, false, false, descriptor);
        }
        return info;
    }

    @Override
    public boolean isMetric() {
        return this.f_fHasMetrics;
    }

    @Override
    public MBeanMetric.Scope getMetricScope() {
        return this.f_metricScope;
    }

    public TabularData getTabularData(M m) {
        try {
            TabularDataSupport table = new TabularDataSupport(this.f_tableType);
            int cRow = this.f_fnRowCount.apply(m);
            CompositeData[] rows = new CompositeData[cRow];
            int cAttribute = this.f_aAttribute.length;
            for (int nRow = 0; nRow < cRow; ++nRow) {
                Object[] aoValue = new Object[cAttribute];
                for (int a = 0; a < cAttribute; ++a) {
                    R oRow = this.f_fnRow.apply(m, nRow);
                    aoValue[a] = this.f_aAttribute[a].getFunction().apply(oRow);
                }
                rows[nRow] = new CompositeDataSupport(this.f_rowType, this.f_asAttributeNames, aoValue);
            }
            table.putAll(rows);
            return table;
        }
        catch (OpenDataException e) {
            throw Exceptions.ensureRuntimeException(e);
        }
    }

    public CompositeType getRowType() {
        return this.f_rowType;
    }

    public String[] getAttributeNames() {
        return this.f_asAttributeNames;
    }

    public void dumpRows(PrintStream out, M m, String sPrefix) {
        int cRow = this.f_fnRowCount.apply(m);
        for (int nRow = 0; nRow < cRow; ++nRow) {
            StringBuilder sb = new StringBuilder(sPrefix).append(" row=").append(nRow);
            for (ModelAttribute<R> attribute : this.f_aAttribute) {
                R oRow = this.f_fnRow.apply(m, nRow);
                Object oValue = attribute.getFunction().apply(oRow);
                sb.append(", ").append(attribute.getName()).append("=").append(oValue);
            }
            out.println(sb);
        }
    }
}

