/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.management.model;

import com.tangosol.internal.net.management.model.ModelOperation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import javax.management.MBeanOperationInfo;
import javax.management.openmbean.OpenMBeanOperationInfoSupport;
import javax.management.openmbean.OpenMBeanParameterInfo;
import javax.management.openmbean.OpenMBeanParameterInfoSupport;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public class SimpleModelOperation<M>
implements ModelOperation<M> {
    private final String f_sName;
    private final String f_sDescription;
    private final OpenMBeanParameterInfo[] f_aParams;
    private final OpenType<?> f_typeReturn;
    private final BiFunction<M, Object[], ?> f_function;
    private MBeanOperationInfo m_info;

    private SimpleModelOperation(Builder<M> builder) {
        this.f_sName = builder.f_sName;
        this.f_sDescription = builder.m_sDescription;
        this.f_aParams = builder.m_listParams.toArray(new OpenMBeanParameterInfo[0]);
        this.f_typeReturn = builder.m_typeReturn;
        this.f_function = builder.m_function;
    }

    @Override
    public String getName() {
        return this.f_sName;
    }

    @Override
    public BiFunction<M, Object[], ?> getFunction() {
        return this.f_function;
    }

    @Override
    public MBeanOperationInfo getOperation() {
        MBeanOperationInfo info = this.m_info;
        if (info == null) {
            info = this.m_info = new OpenMBeanOperationInfoSupport(this.f_sName, this.f_sDescription, this.f_aParams, this.f_typeReturn, 1);
        }
        return info;
    }

    public static <M> Builder<M> builder(String sName, Class<? extends M> ignored) {
        return new Builder(sName);
    }

    public static class Builder<M> {
        private final String f_sName;
        private String m_sDescription;
        private final List<OpenMBeanParameterInfo> m_listParams = new ArrayList<OpenMBeanParameterInfo>();
        private OpenType<?> m_typeReturn = SimpleType.VOID;
        private BiFunction<M, Object[], ?> m_function = (m, p) -> null;

        private Builder(String sName) {
            this.f_sName = sName;
        }

        public Builder<M> withDescription(String sDescription) {
            this.m_sDescription = sDescription;
            return this;
        }

        public Builder<M> withParameter(String sName, String sDescription, OpenType<?> type) {
            return this.withParameters(new OpenMBeanParameterInfoSupport(sName, sDescription, type));
        }

        public Builder<M> withParameters(OpenMBeanParameterInfo ... aParams) {
            this.m_listParams.addAll(Arrays.asList(aParams));
            return this;
        }

        public Builder<M> returning(OpenType<?> type) {
            this.m_typeReturn = type;
            return this;
        }

        public Builder<M> withFunction(BiConsumer<M, Object[]> fn) {
            this.m_function = fn == null ? (m, p) -> null : (m, p) -> {
                fn.accept((Object)m, (Object[])p);
                return null;
            };
            return this;
        }

        public Builder<M> withFunction(BiFunction<M, Object[], ?> fn) {
            this.m_function = fn == null ? (m, p) -> null : fn;
            return this;
        }

        public SimpleModelOperation<M> build() {
            return new SimpleModelOperation(this);
        }
    }
}

