/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.management.model;

import com.tangosol.internal.net.management.model.ModelAttribute;
import com.tangosol.net.metrics.MBeanMetric;
import java.util.Set;
import java.util.function.Function;
import javax.management.MBeanAttributeInfo;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.openmbean.OpenMBeanAttributeInfoSupport;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public class SimpleModelAttribute<M>
implements ModelAttribute<M> {
    private volatile MBeanAttributeInfo m_attribute;
    private final String f_sName;
    private final String f_sDescription;
    private final OpenType<?> f_type;
    private final boolean f_fReadable;
    private final boolean f_fWritable;
    private final Function<M, ?> f_function;
    private final boolean f_fMetric;
    private final boolean f_fMetricTag;
    private final String[] f_asLabels;
    private final String f_sMetricName;
    private final MBeanMetric.Scope f_metricScope;

    private SimpleModelAttribute(Builder<M> builder) {
        this.f_sName = builder.f_sName;
        this.f_sDescription = builder.m_sDescription;
        this.f_type = builder.f_type;
        this.f_fReadable = builder.m_fReadable;
        this.f_fWritable = builder.m_fWritable;
        this.f_function = builder.m_function;
        this.f_fMetric = builder.m_fMetric;
        this.f_fMetricTag = builder.m_fMetricTag;
        this.f_sMetricName = builder.m_sMetricName;
        this.f_metricScope = builder.m_metricScope;
        this.f_asLabels = builder.m_asLabels;
    }

    @Override
    public String getName() {
        return this.f_sName;
    }

    @Override
    public OpenType<?> getType() {
        return this.f_type;
    }

    @Override
    public boolean isMetric() {
        return this.f_fMetric;
    }

    @Override
    public MBeanMetric.Scope getMetricScope() {
        return this.f_metricScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MBeanAttributeInfo getMBeanAttributeInfo() {
        if (this.m_attribute == null) {
            SimpleModelAttribute simpleModelAttribute = this;
            synchronized (simpleModelAttribute) {
                if (this.m_attribute == null) {
                    String sName;
                    DescriptorSupport descriptor = new DescriptorSupport();
                    String string = sName = this.f_sMetricName == null || this.f_sMetricName.isBlank() ? this.f_sName : this.f_sMetricName;
                    if (this.f_fMetric) {
                        descriptor.setField("metric.scope", MBeanMetric.Scope.VENDOR.name());
                        descriptor.setField("metrics.value", sName);
                        if (this.f_asLabels.length != 0) {
                            descriptor.setField("metric.labels", this.f_asLabels);
                        }
                    } else if (this.f_fMetricTag) {
                        descriptor.setField("metrics.tag", sName);
                    }
                    this.m_attribute = new OpenMBeanAttributeInfoSupport(this.f_sName, this.f_sDescription, this.f_type, this.f_fReadable, this.f_fWritable, false, descriptor);
                }
            }
        }
        return this.m_attribute;
    }

    @Override
    public Function<M, ?> getFunction() {
        return this.f_function;
    }

    @Override
    public String getDescription() {
        return this.f_sDescription;
    }

    public <T> Builder<T> asBuilder(Class<? extends T> cls) {
        Builder<? extends T> builder = SimpleModelAttribute.builder(this.f_sName, this.f_type, cls);
        builder.m_sMetricName = this.f_sMetricName;
        builder.m_asLabels = this.f_asLabels;
        builder.m_fMetric = this.f_fMetric;
        builder.m_fMetricTag = this.f_fMetricTag;
        builder.m_fReadable = this.f_fReadable;
        builder.m_function = this.f_function;
        builder.m_fWritable = this.f_fWritable;
        builder.m_metricScope = this.f_metricScope;
        builder.m_sDescription = this.f_sDescription;
        return builder;
    }

    public static <M> Builder<M> builder(String sName, OpenType<?> type, Class<? extends M> cls) {
        return new Builder(sName, type);
    }

    public static <M> Builder<M> intBuilder(String sName, Class<? extends M> cls) {
        return SimpleModelAttribute.builder(sName, SimpleType.INTEGER, cls);
    }

    public static <M> Builder<M> longBuilder(String sName, Class<? extends M> cls) {
        return SimpleModelAttribute.builder(sName, SimpleType.LONG, cls);
    }

    public static <M> Builder<M> doubleBuilder(String sName, Class<? extends M> cls) {
        return SimpleModelAttribute.builder(sName, SimpleType.DOUBLE, cls);
    }

    public static <M> Builder<M> booleanBuilder(String sName, Class<? extends M> cls) {
        return SimpleModelAttribute.builder(sName, SimpleType.BOOLEAN, cls);
    }

    public static <M> Builder<M> stringBuilder(String sName, Class<? extends M> cls) {
        return SimpleModelAttribute.builder(sName, SimpleType.STRING, cls);
    }

    public static class Builder<M> {
        private final String f_sName;
        private final OpenType<?> f_type;
        private String m_sDescription;
        private boolean m_fReadable = true;
        private boolean m_fWritable = false;
        private Function<M, ?> m_function = m -> null;
        private boolean m_fMetric = false;
        private boolean m_fMetricTag = false;
        private String[] m_asLabels = new String[0];
        private String m_sMetricName;
        private MBeanMetric.Scope m_metricScope = MBeanMetric.Scope.VENDOR;

        protected Builder(String sName, OpenType<?> type) {
            this.f_sName = sName;
            this.f_type = type;
        }

        public Builder<M> withDescription(String sDescription) {
            this.m_sDescription = sDescription;
            return this;
        }

        public Builder<M> readOnly(boolean fReadOnly) {
            this.m_fReadable = true;
            this.m_fWritable = !fReadOnly;
            return this;
        }

        public Builder<M> readable(boolean fReadable) {
            this.m_fReadable = fReadable;
            return this;
        }

        public Builder<M> writeable(boolean fWriteable) {
            this.m_fWritable = fWriteable;
            return this;
        }

        public Builder<M> withFunction(Function<M, ?> function) {
            this.m_function = function;
            return this;
        }

        public Builder<M> withMetricLabels(String ... asLabel) {
            this.m_fMetric = true;
            this.m_asLabels = asLabel;
            return this;
        }

        public Builder<M> withMetricLabels(Set<String> setLabel) {
            this.m_fMetric = true;
            this.m_asLabels = setLabel == null || setLabel.isEmpty() ? new String[]{} : setLabel.toArray(new String[0]);
            return this;
        }

        public Builder<M> withMetricScope(MBeanMetric.Scope scope) {
            this.m_metricScope = scope == null ? MBeanMetric.Scope.VENDOR : scope;
            return this;
        }

        public Builder<M> metric(String sName) {
            this.m_fMetric = true;
            this.m_sMetricName = sName;
            return this;
        }

        public Builder<M> metric(boolean fMetric) {
            this.m_fMetric = fMetric;
            return this;
        }

        public Builder<M> metricTag(boolean fTag) {
            this.m_fMetricTag = fTag;
            this.m_fMetric = false;
            return this;
        }

        public SimpleModelAttribute<M> build() {
            return new SimpleModelAttribute(this);
        }
    }
}

