/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.management.model;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.internal.net.management.model.ModelAttribute;
import com.tangosol.internal.net.management.model.ModelOperation;
import com.tangosol.internal.net.management.model.TabularModel;
import com.tangosol.net.metrics.MBeanMetric;
import java.io.PrintStream;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.AttributeNotFoundException;
import javax.management.DynamicMBean;
import javax.management.InvalidAttributeValueException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ReflectionException;
import javax.management.modelmbean.DescriptorSupport;
import javax.management.openmbean.OpenMBeanConstructorInfoSupport;

public abstract class AbstractModel<M extends AbstractModel<M>>
implements DynamicMBean {
    protected final LinkedHashMap<String, ModelAttribute<M>> f_mapAttribute = new LinkedHashMap();
    protected final LinkedHashMap<String, ModelOperation<M>> f_mapOperation = new LinkedHashMap();
    private final String f_sDescription;
    private volatile MBeanInfo m_mBeanInfo;
    private MBeanMetric.Scope m_scope = MBeanMetric.Scope.VENDOR;

    protected AbstractModel(String sDescription) {
        this.f_sDescription = sDescription;
    }

    protected void addAttribute(ModelAttribute<M> attribute) {
        this.f_mapAttribute.put(attribute.getName(), attribute);
    }

    protected void addOperation(ModelOperation<M> operation) {
        this.f_mapOperation.put(operation.getName(), operation);
    }

    protected void setScope(MBeanMetric.Scope scope) {
        this.m_scope = scope == null ? MBeanMetric.Scope.VENDOR : scope;
    }

    @Override
    public Object getAttribute(String sAttribute) throws AttributeNotFoundException, MBeanException, ReflectionException {
        ModelAttribute<M> attribute = this.f_mapAttribute.get(sAttribute);
        if (attribute == null) {
            throw new IllegalArgumentException("Invalid attribute name: " + sAttribute);
        }
        Function<M, ?> function = attribute.getFunction();
        if (function == null) {
            throw new AttributeNotFoundException(sAttribute);
        }
        return function.apply(this);
    }

    @Override
    public void setAttribute(Attribute sAttribute) throws AttributeNotFoundException, InvalidAttributeValueException, MBeanException, ReflectionException {
        throw new InvalidAttributeValueException("Attribute " + String.valueOf(sAttribute) + " is read-only");
    }

    @Override
    public AttributeList getAttributes(String[] asAttribute) {
        AttributeList list = new AttributeList();
        for (String sAttribute : asAttribute) {
            try {
                Object oValue = this.getAttribute(sAttribute);
                list.add(new Attribute(sAttribute, oValue));
            }
            catch (AttributeNotFoundException | MBeanException | ReflectionException e) {
                Logger.err(e);
            }
        }
        return list;
    }

    @Override
    public AttributeList setAttributes(AttributeList attributes) {
        AttributeList list = new AttributeList();
        for (Attribute attribute : attributes.asList()) {
            try {
                this.setAttribute(attribute);
                String sName = attribute.getName();
                list.add(new Attribute(sName, this.getAttribute(sName)));
            }
            catch (AttributeNotFoundException | InvalidAttributeValueException | MBeanException | ReflectionException e) {
                Logger.err(e);
            }
        }
        return list;
    }

    @Override
    public Object invoke(String sOperation, Object[] aoParam, String[] asSignature) throws MBeanException, ReflectionException {
        ModelOperation<M> operation = this.f_mapOperation.get(sOperation);
        if (operation == null) {
            throw new UnsupportedOperationException("MBean operation " + sOperation + " is not supported");
        }
        return operation.getFunction().apply(this, aoParam);
    }

    @Override
    public MBeanInfo getMBeanInfo() {
        if (this.m_mBeanInfo == null) {
            MBeanAttributeInfo[] aAttributeInfo = (MBeanAttributeInfo[])this.f_mapAttribute.values().stream().map(ModelAttribute::getMBeanAttributeInfo).toArray(MBeanAttributeInfo[]::new);
            MBeanOperationInfo[] aOperation = (MBeanOperationInfo[])this.f_mapOperation.values().stream().map(ModelOperation::getOperation).toArray(MBeanOperationInfo[]::new);
            DescriptorSupport descriptor = new DescriptorSupport();
            descriptor.setField("metric.scope", this.m_scope.name());
            this.m_mBeanInfo = new MBeanInfo(this.getClass().getName(), this.f_sDescription, aAttributeInfo, new OpenMBeanConstructorInfoSupport[0], aOperation, new MBeanNotificationInfo[0], descriptor);
        }
        return this.m_mBeanInfo;
    }

    public void dumpAttributes(PrintStream out) {
        for (Map.Entry<String, ModelAttribute<M>> entry : this.f_mapAttribute.entrySet()) {
            ModelAttribute<M> attribute = entry.getValue();
            if (attribute instanceof TabularModel) {
                ((TabularModel)attribute).dumpRows(out, this, entry.getKey());
                continue;
            }
            Function<M, ?> function = attribute.getFunction();
            Object oValue = function.apply(this);
            out.printf("%s %s\n", entry.getKey(), oValue);
        }
    }

    protected String valueOrNotApplicable(Object o) {
        return o == null ? "n/a" : String.valueOf(o);
    }
}

