/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.management;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.coherence.reporter.ReportBatch;
import com.tangosol.internal.net.management.CustomMBeanDependencies;
import com.tangosol.internal.net.management.DefaultConnectorDependencies;
import com.tangosol.internal.net.management.DefaultCustomMBeanDependencies;
import com.tangosol.internal.net.management.DefaultGatewayDependencies;
import com.tangosol.internal.net.management.LegacyXmlConnectorHelper;
import com.tangosol.internal.net.management.LegacyXmlCustomMBeanHelper;
import com.tangosol.internal.net.management.LegacyXmlReporterHelper;
import com.tangosol.net.management.MBeanServerFinder;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Base;
import com.tangosol.util.Filter;
import java.util.ArrayList;
import java.util.Iterator;

public class LegacyXmlGatewayHelper {
    public static DefaultGatewayDependencies fromXml(XmlElement xml, DefaultGatewayDependencies deps) {
        Base.azzert(xml.getName().equals("management-config"));
        deps.setManagedNodes(xml.getSafeElement("managed-nodes").getString(deps.getManagedNodes()));
        deps.setHttpManagedNodes(xml.getSafeElement("http-managed-nodes").getString(deps.getHttpManagedNodes()));
        deps.setAllowRemoteManagement(xml.getSafeElement("allow-remote-management").getBoolean(deps.isAllowRemoteManagement()));
        deps.setReadOnly(xml.getSafeElement("read-only").getBoolean(deps.isReadOnly()));
        if (!"Management".equals(xml.getSafeElement("service-name").getString())) {
            Logger.info("The \"management-config/service-name\" element value is ignored");
        }
        deps.setDefaultDomain(xml.getSafeElement("default-domain-name").getString(deps.getDefaultDomain()));
        deps.setDomainNameSuffix(xml.getSafeElement("domain-name-suffix").getString(deps.getDomainNameSuffix()));
        deps.setExtendedMBeanName(xml.getSafeElement("extended-mbean-name").getBoolean(deps.isExtendedMBeanName()));
        XmlElement xmlFactory = xml.getSafeElement("server-factory");
        MBeanServerFinder mbsf = XmlHelper.isInstanceConfigEmpty(xmlFactory) ? null : (MBeanServerFinder)XmlHelper.createInstance(xmlFactory, null, null);
        deps.setMBeanServerFinder(mbsf);
        DefaultConnectorDependencies connectorDeps = LegacyXmlConnectorHelper.fromXml(xml, new DefaultConnectorDependencies());
        deps.setConnectorDependencies(connectorDeps);
        ReportBatch.DefaultDependencies reporterDeps = LegacyXmlReporterHelper.fromXml(xml.getSafeElement("reporter"), new ReportBatch.DefaultDependencies());
        deps.setReporterDependencies(reporterDeps);
        LegacyXmlGatewayHelper.configureFilter(xml, deps);
        LegacyXmlGatewayHelper.configureCustomBeans(xml, deps);
        return deps;
    }

    private static void configureFilter(XmlElement xml, DefaultGatewayDependencies deps) {
        XmlElement xmlFilter = xml.getSafeElement("mbean-filter");
        if (!XmlHelper.isEmpty(xmlFilter)) {
            try {
                deps.setFilter((Filter)XmlHelper.createInstance(xmlFilter, null, null));
            }
            catch (Throwable e) {
                throw new IllegalArgumentException("Error instantiating mbean-filter.", e);
            }
        }
    }

    private static void configureCustomBeans(XmlElement xml, DefaultGatewayDependencies deps) {
        ArrayList<CustomMBeanDependencies> listCustomMBeanDeps = new ArrayList<CustomMBeanDependencies>();
        XmlElement xmlConfig = xml.getSafeElement("mbeans");
        Iterator iterBeans = xmlConfig.getElements("mbean");
        while (iterBeans.hasNext()) {
            listCustomMBeanDeps.add(LegacyXmlCustomMBeanHelper.fromXml((XmlElement)iterBeans.next(), new DefaultCustomMBeanDependencies()));
        }
        if (!listCustomMBeanDeps.isEmpty()) {
            deps.setCustomMBeanDependencies(listCustomMBeanDeps);
        }
    }
}

