/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.management;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.internal.net.service.grid.DefaultProxyServiceDependencies;
import com.tangosol.internal.net.service.grid.LegacyXmlProxyServiceHelper;
import com.tangosol.internal.net.service.peer.acceptor.HttpAcceptorDependencies;
import com.tangosol.net.Cluster;
import com.tangosol.net.OperationalContext;
import com.tangosol.net.Service;
import com.tangosol.net.management.MapJsonBodyHandler;
import com.tangosol.run.xml.XmlDocument;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Base;
import com.tangosol.util.Resources;
import java.net.MalformedURLException;
import java.net.URL;

public abstract class HttpHelper {
    public static final int DEFAULT_MANAGEMENT_OVER_REST_PORT = 30000;
    public static final String MANAGEMENT_SERVICE_NAME = "ManagementHttpProxy";
    public static final String DEFAULT_CLUSTER_PATH = "/management/coherence/cluster";
    public static final String MANAGEMENT_CONFIG = "management-http-config.xml";

    public static URL composeURL(String sHost, int nPort) throws MalformedURLException {
        return HttpHelper.composeURL(sHost, nPort, "http");
    }

    public static URL composeURL(String sHost, int nPort, String sProtocol) throws MalformedURLException {
        return new URL(sProtocol, sHost, nPort, DEFAULT_CLUSTER_PATH);
    }

    public static String getServiceName() {
        return MANAGEMENT_SERVICE_NAME;
    }

    public static boolean isHttpCapable(ClassLoader ignored) {
        try {
            MapJsonBodyHandler.ensureMapJsonBodyHandler();
        }
        catch (Throwable t) {
            StringBuilder sMsg = new StringBuilder(t.getMessage());
            for (Throwable cause = t.getCause(); cause != null; cause = cause.getCause()) {
                sMsg.append(", caused by: ").append(cause.getMessage());
            }
            Logger.finest("One or more dependencies are missing for management over HTTP: " + String.valueOf(sMsg));
            return false;
        }
        return true;
    }

    public static boolean startService(Cluster cluster) {
        ClassLoader classLoader = cluster.getContextClassLoader();
        if (HttpHelper.isHttpCapable(classLoader)) {
            DefaultProxyServiceDependencies deps = null;
            try {
                URL urlConfig = Resources.findFileOrResourceOrDefault(MANAGEMENT_CONFIG, classLoader);
                if (urlConfig == null) {
                    throw new IllegalStateException("Unable to locate management-http-config.xml which should be resolvable from the coherence-management module on the class path.");
                }
                XmlDocument xml = XmlHelper.loadXml(urlConfig);
                Logger.info("Loaded management over REST configuration from \"" + String.valueOf(urlConfig) + "\"");
                XmlHelper.replaceSystemProperties(xml, "system-property");
                deps = LegacyXmlProxyServiceHelper.fromXml(xml, new DefaultProxyServiceDependencies(), (OperationalContext)((Object)cluster), classLoader);
                Service service = cluster.ensureService(HttpHelper.getServiceName(), "Proxy");
                service.setDependencies(deps);
                service.start();
                return true;
            }
            catch (Throwable t) {
                Throwable tCause;
                Throwable tOriginal = t instanceof RuntimeException ? Base.getOriginalException((RuntimeException)t) : t;
                Throwable throwable = tCause = tOriginal.getCause() == null ? tOriginal : tOriginal.getCause();
                if (tCause instanceof ClassNotFoundException || tCause instanceof NoClassDefFoundError) {
                    Logger.err("Management over HTTP is not available most likely due to this member missing the necessary libraries to run the service. Handled exception: " + tCause.getClass().getCanonicalName() + ": " + tCause.getLocalizedMessage());
                } else {
                    StringBuilder sb = new StringBuilder();
                    sb.append("failed to start service ").append(HttpHelper.getServiceName());
                    if (deps != null) {
                        HttpAcceptorDependencies depsHttpAcceptor = (HttpAcceptorDependencies)deps.getAcceptorDependencies();
                        sb.append(" at address ").append(depsHttpAcceptor.getLocalAddress()).append(":").append(depsHttpAcceptor.getLocalPort());
                    }
                    sb.append(" due to ").append(tCause.getClass().getSimpleName()).append(" : ").append(tCause.getLocalizedMessage());
                    Logger.err(sb.toString());
                }
                return false;
            }
        }
        Logger.err("Management over HTTP is not available most likely due to missing classes");
        return false;
    }
}

