/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.logging;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.internal.net.logging.LoggingDependencies;

public class DefaultLoggingDependencies
implements LoggingDependencies {
    public static final int DEFAULT_LOGGING_CHAR_LIMIT = 65536;
    public static final String DEFAULT_LOGGING_DESTINATION = "stderr";
    public static final int DEFAULT_LOGGING_LEVEL = 9;
    public static final String DEFAULT_LOGGING_LOGGER_NAME = "Coherence";
    public static final String DEFAULT_LOGGING_MESSAGE_FORMAT = "{date} &lt;{level}&gt; (thread={thread}): {text}";
    private int m_cCharLimit = 65536;
    private String m_sDestination = "stderr";
    private String m_sLoggerName = "Coherence";
    private String m_sMessageFormat = "{date} &lt;{level}&gt; (thread={thread}): {text}";
    private int m_nSeverityLevel = 9;

    public DefaultLoggingDependencies() {
        this(null);
    }

    public DefaultLoggingDependencies(LoggingDependencies deps) {
        if (deps != null) {
            this.m_cCharLimit = deps.getCharacterLimit();
            this.m_sDestination = deps.getDestination();
            this.m_sLoggerName = deps.getLoggerName();
            this.m_sMessageFormat = deps.getMessageFormat();
            this.m_nSeverityLevel = deps.getSeverityLevel();
        }
    }

    @Override
    public int getCharacterLimit() {
        return this.m_cCharLimit;
    }

    public DefaultLoggingDependencies setCharacterLimit(int cCharLimit) {
        this.m_cCharLimit = cCharLimit;
        return this;
    }

    @Override
    public String getDestination() {
        return this.m_sDestination;
    }

    public DefaultLoggingDependencies setDestination(String sDestination) {
        this.m_sDestination = sDestination;
        return this;
    }

    @Override
    public String getLoggerName() {
        return this.m_sLoggerName;
    }

    public DefaultLoggingDependencies setLoggerName(String sLoggerName) {
        this.m_sLoggerName = sLoggerName;
        return this;
    }

    @Override
    public String getMessageFormat() {
        return this.m_sMessageFormat;
    }

    public DefaultLoggingDependencies setMessageFormat(String sMessageFormat) {
        this.m_sMessageFormat = sMessageFormat;
        return this;
    }

    @Override
    public int getSeverityLevel() {
        return this.m_nSeverityLevel;
    }

    protected DefaultLoggingDependencies setSeverityLevel(int nSeverityLevel) {
        this.m_nSeverityLevel = nSeverityLevel;
        return this;
    }

    public DefaultLoggingDependencies validate() {
        if (this.m_sMessageFormat.length() == 0) {
            this.m_sMessageFormat = DEFAULT_LOGGING_MESSAGE_FORMAT;
        }
        if (this.m_nSeverityLevel < 0) {
            Logger.fine("Logging.Dependencies: Minimum severity is 0 (overriding setting of " + this.m_nSeverityLevel + ")");
            this.m_nSeverityLevel = 0;
        } else if (this.m_nSeverityLevel > 9) {
            Logger.fine("Logging.Dependencies: Maximum severity is 9 (overriding setting of " + this.m_nSeverityLevel + ")");
            this.m_nSeverityLevel = 9;
        }
        if (this.m_cCharLimit <= 0) {
            this.m_cCharLimit = Integer.MAX_VALUE;
        }
        return this;
    }

    public String toString() {
        return "DefaultLoggingDependencies{" + this.getDescription() + "}";
    }

    protected String getDescription() {
        return "CharacterLimit=" + this.getCharacterLimit() + ", Destination=" + this.getDestination() + ", LoggerName=" + this.getLoggerName() + ", MessageFormat=" + this.getMessageFormat() + ", SeverityLevel=" + this.getSeverityLevel();
    }
}

