/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.grpc;

import com.tangosol.config.annotation.Injectable;
import com.tangosol.config.expression.Expression;
import com.tangosol.config.expression.LiteralExpression;
import com.tangosol.internal.net.grpc.RemoteGrpcServiceDependencies;
import com.tangosol.internal.net.service.extend.remote.DefaultRemoteServiceDependencies;
import com.tangosol.internal.tracing.TracingHelper;
import com.tangosol.internal.util.DaemonPoolDependencies;
import com.tangosol.internal.util.DefaultDaemonPoolDependencies;
import com.tangosol.io.SerializerFactory;
import com.tangosol.net.grpc.GrpcChannelDependencies;

public abstract class DefaultRemoteGrpcServiceDependencies
extends DefaultRemoteServiceDependencies
implements RemoteGrpcServiceDependencies {
    private GrpcChannelDependencies m_channelDependencies;
    private String m_sScopeName;
    private String m_sScopeNameRemote;
    private Expression<Boolean> m_fEnableTracing = new LiteralExpression<Boolean>(TracingHelper.isEnabled());
    private DefaultDaemonPoolDependencies m_daemonPoolDependencies;
    private SerializerFactory m_serializerFactory;
    private long m_nHeartbeatInterval = 0L;
    private boolean m_fRequireHeartbeatAck = false;

    protected DefaultRemoteGrpcServiceDependencies() {
        this(null);
    }

    protected DefaultRemoteGrpcServiceDependencies(RemoteGrpcServiceDependencies deps) {
        super(deps);
        if (deps != null) {
            this.setChannelDependencies(deps.getChannelDependencies());
            this.setDaemonPoolDependencies(deps.getDaemonPoolDependencies());
            this.setEnableTracing(deps.isTracingEnabled());
            this.setRemoteClusterName(deps.getRemoteClusterName());
            this.setRemoteScopeName(deps.getRemoteScopeName());
            this.setScopeName(deps.getScopeName());
            this.setSerializerFactory(deps.getSerializerFactory());
            this.setHeartbeatInterval(deps.getHeartbeatInterval());
        }
    }

    @Injectable(value="grpc-channel")
    public void setChannelDependencies(GrpcChannelDependencies deps) {
        this.m_channelDependencies = deps;
    }

    @Override
    public GrpcChannelDependencies getChannelDependencies() {
        return this.m_channelDependencies;
    }

    @Injectable(value="enable-tracing")
    public void setEnableTracing(Expression<Boolean> fEnableTracing) {
        this.m_fEnableTracing = fEnableTracing;
    }

    @Override
    public Expression<Boolean> isTracingEnabled() {
        return this.m_fEnableTracing;
    }

    @Override
    public DaemonPoolDependencies getDaemonPoolDependencies() {
        return this.ensureDaemonPoolDependencies();
    }

    public void setDaemonPoolDependencies(DaemonPoolDependencies deps) {
        this.m_daemonPoolDependencies = new DefaultDaemonPoolDependencies(deps);
    }

    @Injectable(value="scope-name")
    public void setScopeName(String sName) {
        this.m_sScopeName = sName;
    }

    @Override
    public String getScopeName() {
        return this.m_sScopeName;
    }

    @Override
    public String getRemoteScopeName() {
        if ("$DEFAULT$".equals(this.m_sScopeNameRemote)) {
            return "";
        }
        return this.m_sScopeNameRemote;
    }

    @Injectable(value="remote-scope-name")
    public void setRemoteScopeName(String sName) {
        this.m_sScopeNameRemote = sName;
    }

    @Override
    @Injectable(value="cluster-name")
    public void setRemoteClusterName(String sName) {
        super.setRemoteClusterName(sName);
    }

    @Override
    public SerializerFactory getSerializerFactory() {
        return this.m_serializerFactory;
    }

    @Override
    @Injectable(value="serializer")
    public void setSerializerFactory(SerializerFactory factory) {
        this.m_serializerFactory = factory;
    }

    @Injectable(value="thread-count")
    public void setThreadCount(int cThreads) {
        this.ensureDaemonPoolDependencies().setThreadCount(cThreads);
    }

    @Injectable(value="thread-count-max")
    public void setThreadCountMax(int cThreads) {
        this.ensureDaemonPoolDependencies().setThreadCountMax(cThreads);
    }

    @Injectable(value="thread-count-min")
    public void setThreadCountMin(int cThreads) {
        this.ensureDaemonPoolDependencies().setThreadCountMin(cThreads);
    }

    @Override
    @Injectable(value="worker-priority")
    public void setThreadPriority(int nPriority) {
        this.ensureDaemonPoolDependencies().setThreadPriority(nPriority);
    }

    @Override
    public long getDeadline() {
        return super.getRequestTimeoutMillis();
    }

    @Override
    public long getHeartbeatInterval() {
        return this.m_nHeartbeatInterval;
    }

    @Injectable(value="heartbeat-interval")
    public void setHeartbeatInterval(long nEventsHeartbeat) {
        this.m_nHeartbeatInterval = Math.max(0L, nEventsHeartbeat);
    }

    @Override
    public boolean isRequireHeartbeatAck() {
        return this.m_fRequireHeartbeatAck;
    }

    @Injectable(value="heartbeat-ack-required")
    public void setRequireHeartbeatAck(boolean fRequireHeartbeatAck) {
        this.m_fRequireHeartbeatAck = fRequireHeartbeatAck;
    }

    protected DefaultDaemonPoolDependencies ensureDaemonPoolDependencies() {
        DefaultDaemonPoolDependencies deps = this.m_daemonPoolDependencies;
        if (deps == null) {
            deps = this.m_daemonPoolDependencies = new DefaultDaemonPoolDependencies();
        }
        return deps;
    }
}

