/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.cluster;

import com.tangosol.coherence.config.builder.ActionPolicyBuilder;
import com.tangosol.coherence.config.builder.ClusterQuorumPolicyBuilder;
import com.tangosol.coherence.config.builder.FactoryBasedAddressProviderBuilder;
import com.tangosol.coherence.config.builder.PartitionedCacheQuorumPolicyBuilder;
import com.tangosol.coherence.config.builder.ProxyQuorumPolicyBuilder;
import com.tangosol.config.ConfigurationException;
import com.tangosol.internal.net.LegacyXmlConfigHelper;
import com.tangosol.net.ActionPolicy;
import com.tangosol.net.AddressProviderFactory;
import com.tangosol.net.ConfigurableQuorumPolicy;
import com.tangosol.net.OperationalContext;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.run.xml.XmlValue;
import com.tangosol.util.Base;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class LegacyXmlConfigurableQuorumPolicy {
    public ActionPolicyBuilder createPolicyBuilder(XmlElement xmlConfig, OperationalContext ctx, ClassLoader loader) {
        if (XmlHelper.isInstanceConfigEmpty(xmlConfig)) {
            if (!xmlConfig.getElementList().isEmpty()) {
                String sConfig = xmlConfig.getName();
                if (sConfig.equals("partitioned-quorum-policy-scheme")) {
                    XmlElement xmlHosts = xmlConfig.getElement("recovery-hosts");
                    AddressProviderFactory factory = xmlHosts == null ? null : LegacyXmlConfigHelper.parseAddressProvider("recovery-hosts", xmlConfig, ctx.getAddressProviderMap());
                    FactoryBasedAddressProviderBuilder bldrRecoveryHosts = new FactoryBasedAddressProviderBuilder(factory);
                    PartitionedCacheQuorumPolicyBuilder builder = new PartitionedCacheQuorumPolicyBuilder(bldrRecoveryHosts, xmlConfig);
                    for (ConfigurableQuorumPolicy.PartitionedCacheQuorumPolicy.ActionRule action : ConfigurableQuorumPolicy.PartitionedCacheQuorumPolicy.ActionRule.values()) {
                        int nThreshold = 0;
                        float flThresholdPct = 0.0f;
                        if (action.getMask() == 16) {
                            String sElementName = action.getElementName();
                            String sThreshold = xmlConfig.getSafeElement(sElementName).getString();
                            int ofPct = sThreshold.indexOf("%");
                            if (ofPct >= 0) {
                                try {
                                    flThresholdPct = Base.parsePercentage(sThreshold);
                                }
                                catch (IllegalArgumentException e) {
                                    throw new ConfigurationException("The <" + sElementName + "> is not a valid value", "Please ensure that the value is non-nagative integer with or without %  <" + sElementName + ">");
                                }
                            } else {
                                nThreshold = Integer.parseInt(sThreshold);
                            }
                        } else {
                            nThreshold = xmlConfig.getSafeElement(action.getElementName()).getInt();
                        }
                        builder.addQuorumRule(action.getElementName(), action.getMask(), nThreshold, flThresholdPct);
                    }
                    return builder;
                }
                if (sConfig.equals("proxy-quorum-policy-scheme")) {
                    int nThreshold = xmlConfig.getSafeElement("connect-quorum").getInt(0);
                    ProxyQuorumPolicyBuilder builder = new ProxyQuorumPolicyBuilder(nThreshold, xmlConfig);
                    return builder;
                }
                if (sConfig.equals("cluster-quorum-policy")) {
                    return new ClusterQuorumPolicyBuilder(this.getQuorumMap(xmlConfig), xmlConfig);
                }
            }
            return new ActionPolicyBuilder.NullImplementationBuilder();
        }
        return new ActionPolicyBuilder.ActionPolicyParameterizedBuilder(LegacyXmlConfigHelper.createBuilder(xmlConfig, ActionPolicy.class));
    }

    private Map<String, Integer> getQuorumMap(XmlElement xmlConfig) {
        HashMap<String, Integer> mapQuorum = new HashMap<String, Integer>();
        if (xmlConfig != null) {
            this.processQuorumElement(xmlConfig, mapQuorum, "timeout-survivor-quorum", "");
            this.processQuorumElement(xmlConfig, mapQuorum, "timeout-site-quorum", "*sites*");
            this.processQuorumElement(xmlConfig, mapQuorum, "timeout-machine-quorum", "*machines*");
        }
        return mapQuorum;
    }

    private void processQuorumElement(XmlElement xmlConfig, Map<String, Integer> mapQuorum, String sGroup, String sPrefix) {
        Iterator iter = xmlConfig.getElements(sGroup);
        while (iter.hasNext()) {
            XmlElement xmlQuorum = (XmlElement)iter.next();
            XmlValue xmlRole = xmlQuorum.getAttribute("role");
            int nQuorum = xmlQuorum.getInt();
            String sRole = xmlRole == null || xmlRole.isEmpty() ? "*role-any*" : xmlRole.getString();
            mapQuorum.put(sPrefix + sRole, nQuorum);
        }
    }
}

