/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net.cluster;

import com.oracle.coherence.common.base.Classes;
import com.oracle.coherence.common.base.Logger;
import com.tangosol.coherence.config.Config;
import com.tangosol.coherence.config.builder.InstanceBuilder;
import com.tangosol.config.expression.NullParameterResolver;
import com.tangosol.internal.net.cluster.ClusterDependencies;
import com.tangosol.net.MemberIdentity;
import com.tangosol.net.MemberIdentityProvider;
import com.tangosol.util.Base;
import com.tangosol.util.ClassHelper;
import com.tangosol.util.NullImplementation;
import com.tangosol.util.comparator.PriorityComparator;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.Objects;
import java.util.ServiceLoader;

public class DefaultMemberIdentity
implements MemberIdentity {
    private String m_sClusterName;
    private int m_nMachineId;
    private String m_sMachineName;
    private String m_sMemberName;
    private int m_memberPriority;
    private String m_sProcessName;
    private String m_sRackName;
    private String m_sRoleName;
    private String m_sSiteName;
    private volatile MemberIdentityProvider m_provider;
    private ClusterDependencies m_dependencies;

    public DefaultMemberIdentity() {
        this(null);
    }

    public DefaultMemberIdentity(MemberIdentity identity) {
        if (identity != null) {
            this.m_sClusterName = identity.getClusterName();
            this.m_nMachineId = identity.getMachineId();
            this.m_sMachineName = identity.getMachineName();
            this.m_sMemberName = identity.getMemberName();
            this.m_memberPriority = identity.getPriority();
            this.m_sProcessName = identity.getProcessName();
            this.m_sRackName = identity.getRackName();
            this.m_sRoleName = identity.getRoleName();
            this.m_sSiteName = identity.getSiteName();
        }
    }

    @Override
    public String getClusterName() {
        return this.m_sClusterName;
    }

    public DefaultMemberIdentity setClusterName(String sClusterName) {
        this.m_sClusterName = sClusterName;
        return this;
    }

    @Override
    public int getMachineId() {
        return this.m_nMachineId;
    }

    public DefaultMemberIdentity setMachineId(int nMachineId) {
        this.m_nMachineId = nMachineId & 0xFFFF;
        return this;
    }

    @Override
    public String getMachineName() {
        String sMachineName = this.m_sMachineName;
        if (sMachineName == null) {
            this.m_sMachineName = sMachineName = this.ensureProvider().getMachineName();
        }
        return sMachineName;
    }

    public DefaultMemberIdentity setMachineName(String sMachineName) {
        this.m_sMachineName = sMachineName;
        return this;
    }

    @Override
    public String getMemberName() {
        String sMemberName = this.m_sMemberName;
        if (sMemberName == null) {
            this.m_sMemberName = sMemberName = this.ensureProvider().getMemberName();
        }
        return sMemberName;
    }

    public DefaultMemberIdentity setMemberName(String sName) {
        this.m_sMemberName = sName;
        return this;
    }

    @Override
    public int getPriority() {
        return this.m_memberPriority;
    }

    public DefaultMemberIdentity setPriority(int nPriority) {
        this.m_memberPriority = nPriority;
        return this;
    }

    @Override
    public String getProcessName() {
        String sProcessName = this.m_sProcessName;
        if (sProcessName == null) {
            this.m_sProcessName = sProcessName = this.makeProcessName();
        }
        return sProcessName;
    }

    public DefaultMemberIdentity setProcessName(String sProcessName) {
        this.m_sProcessName = sProcessName;
        return this;
    }

    @Override
    public String getRackName() {
        String sRackName = this.m_sRackName;
        if (sRackName == null) {
            this.m_sRackName = sRackName = this.ensureProvider().getRackName();
        }
        return sRackName;
    }

    public DefaultMemberIdentity setRackName(String sRackName) {
        this.m_sRackName = sRackName;
        return this;
    }

    @Override
    public String getRoleName() {
        String sRoleName = this.m_sRoleName;
        if (sRoleName == null) {
            this.m_sRoleName = sRoleName = this.makeRoleName();
        }
        return sRoleName;
    }

    public DefaultMemberIdentity setRoleName(String sRoleName) {
        this.m_sRoleName = sRoleName;
        return this;
    }

    @Override
    public String getSiteName() {
        String sSiteName = this.m_sSiteName;
        if (sSiteName == null) {
            this.m_sSiteName = sSiteName = this.ensureProvider().getSiteName();
        }
        return sSiteName;
    }

    public DefaultMemberIdentity setSiteName(String sSiteName) {
        this.m_sSiteName = sSiteName;
        return this;
    }

    public void setDependencies(ClusterDependencies dependencies) {
        this.m_dependencies = dependencies;
    }

    public DefaultMemberIdentity validate() {
        Base.checkRange(this.getClusterName() == null ? 0L : (long)this.getClusterName().length(), 0L, 66L, "ClusterName");
        Base.checkRange(this.getMachineName() == null ? 0L : (long)this.getMachineName().length(), 0L, 66L, "MachineName");
        Base.checkRange(this.getMemberName() == null ? 0L : (long)this.getMemberName().length(), 0L, 66L, "MemberName");
        Base.checkRange(this.getProcessName() == null ? 0L : (long)this.getProcessName().length(), 0L, 66L, "ProcessName");
        Base.checkRange(this.getRackName() == null ? 0L : (long)this.getRackName().length(), 0L, 66L, "RackName");
        Base.checkRange(this.getRoleName() == null ? 0L : (long)this.getRoleName().length(), 0L, 66L, "RoleName");
        Base.checkRange(this.getSiteName() == null ? 0L : (long)this.getSiteName().length(), 0L, 66L, "SiteName");
        Base.checkRange(this.getPriority(), 0L, 10L, "Priority");
        return this;
    }

    public String toString() {
        return "DefaultMemberIdentity{ClusterName=" + this.getClusterName() + ", MachineId=" + this.getMachineId() + ", MachineName=" + this.getMachineName() + ", MemberName=" + this.getMemberName() + ", Priority=" + this.getPriority() + ", ProcessName=" + this.getProcessName() + ", RackName=" + this.getRackName() + ", RoleName=" + this.getRoleName() + ", SiteName=" + this.getSiteName() + "}";
    }

    protected String makeProcessName() {
        String sName = ManagementFactory.getRuntimeMXBean().getName();
        int ofAt = sName.indexOf(64);
        if (ofAt != -1) {
            String sPid = sName.substring(0, ofAt);
            try {
                Long.parseLong(sPid);
                sName = sPid;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (sName.length() > 66) {
            sName = sName.substring(0, 66);
        }
        return sName;
    }

    protected String makeRoleName() {
        Object sName = this.ensureProvider().getRoleName();
        if (sName == null) {
            try {
                Thread thread = Thread.currentThread();
                StackTraceElement[] aStack = null;
                if (Base.equals(thread.getName(), "main")) {
                    aStack = new Throwable().getStackTrace();
                } else {
                    ThreadGroup group = thread.getThreadGroup();
                    ThreadGroup parent = group.getParent();
                    while (parent != null) {
                        group = parent;
                        parent = group.getParent();
                    }
                    Thread[] aThread = new Thread[group.activeCount()];
                    int c = group.enumerate(aThread);
                    for (int i = 0; i < c; ++i) {
                        thread = aThread[i];
                        String sThreadName = thread.getName();
                        if (!Base.equals(sThreadName, "main") && !Base.equals(sThreadName, "Main Thread")) continue;
                        aStack = (StackTraceElement[])ClassHelper.invoke(thread, "getStackTrace", ClassHelper.VOID);
                        break;
                    }
                }
                if (aStack != null) {
                    String sClass = aStack[aStack.length - 1].getClassName();
                    if (sClass.equals("com.tangosol.coherence.component.Application") || sClass.equals("com.tangosol.net.CacheFactory")) {
                        sName = "CoherenceConsole";
                    } else if (sClass.equals("com.tangosol.net.DefaultCacheServer") || sClass.equals("com.tangosol.net.Coherence")) {
                        sName = "CoherenceServer";
                    } else {
                        String[] sParts = Base.parseDelimitedString(sClass, '.');
                        int ofPartStart = sParts[0].equals("com") || sParts[0].equals("org") ? 1 : 0;
                        sName = Base.capitalize(sParts[ofPartStart]);
                        String sEnd = Base.capitalize(sParts[sParts.length - 1]);
                        if (((String)sName).length() + sEnd.length() < 66) {
                            int c = sParts.length - 1;
                            for (int i = ofPartStart + 1; i < c; ++i) {
                                String sPart = sParts[i];
                                if (((String)sName).length() + sPart.length() + sEnd.length() > 66) break;
                                sName = (String)sName + Base.capitalize(sPart);
                            }
                            sName = (String)sName + sEnd;
                        } else {
                            sName = sEnd.substring(0, 66);
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return sName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MemberIdentityProvider ensureProvider() {
        if (this.m_provider == null) {
            DefaultMemberIdentity defaultMemberIdentity = this;
            synchronized (defaultMemberIdentity) {
                if (this.m_provider == null) {
                    try {
                        MemberIdentityProvider provider = null;
                        String sClass = Config.getProperty("coherence.identity.provider");
                        if (sClass != null) {
                            try {
                                Logger.finer("Loading MemberIdentityProvider: " + sClass);
                                InstanceBuilder builder = new InstanceBuilder(sClass, new Object[0]);
                                provider = (MemberIdentityProvider)builder.realize(new NullParameterResolver(), Classes.getContextClassLoader(), null);
                            }
                            catch (Throwable e) {
                                Logger.err("Failed to load MemberIdentityProvider: " + sClass, e);
                            }
                        }
                        if (provider == null && (provider = (MemberIdentityProvider)ServiceLoader.load(MemberIdentityProvider.class).stream().sorted(Collections.reverseOrder(PriorityComparator.forServiceLoader())).map(ServiceLoader.Provider::get).filter(Objects::nonNull).findFirst().orElse(null)) != null) {
                            provider.setDependencies(this.m_dependencies);
                            Logger.finer("Discovered MemberIdentityProvider: " + String.valueOf(provider));
                        }
                        this.m_provider = provider == null ? NullImplementation.getMemberIdentityProvider() : provider;
                    }
                    catch (Throwable t) {
                        Logger.err("Failed to load identity provider", t);
                        this.m_provider = NullImplementation.getMemberIdentityProvider();
                    }
                }
            }
        }
        return this.m_provider;
    }
}

