/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net;

import com.tangosol.net.Coherence;
import com.tangosol.net.SessionConfiguration;
import com.tangosol.net.SessionProvider;
import java.util.Optional;

public class SystemSessionConfiguration
implements SessionConfiguration {
    public static final int PROVIDER_PRIORITY = 0;
    private final Coherence.Mode f_mode;
    private final String f_sScope;

    public SystemSessionConfiguration(Coherence.Mode mode) {
        this.f_mode = mode == null ? Coherence.Mode.ClusterMember : mode;
        this.f_sScope = "$SYS";
    }

    @Override
    public String getName() {
        return "$SYS";
    }

    @Override
    public String getScopeName() {
        return this.f_sScope;
    }

    @Override
    public Optional<String> getConfigUri() {
        return Optional.of("coherence-system-config.xml");
    }

    @Override
    public Optional<Coherence.Mode> getMode() {
        return Optional.of(this.f_mode);
    }

    public static class SystemSessionProvider
    implements SessionProvider {
        static final SystemSessionProvider INSTANCE = new SystemSessionProvider();

        @Override
        public int getPriority() {
            return 0;
        }

        @Override
        public SessionProvider.Context createSession(SessionConfiguration configuration, SessionProvider.Context context) {
            if (configuration instanceof SystemSessionConfiguration) {
                return context.createSession(configuration);
            }
            if ("$SYS".equals(configuration.getName())) {
                return context.createSession(new SystemSessionConfiguration(context.getMode()));
            }
            return context;
        }
    }
}

