/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net;

import com.tangosol.net.ScopeResolver;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;

public class ScopedUriScopeResolver
implements ScopeResolver {
    public static final String SCOPED_SCHEME = "scoped";
    public static final String SCOPED_PATTERN = "%s://%s?%s";
    private final boolean f_fUseScopeInConfig;

    public ScopedUriScopeResolver() {
        this(true);
    }

    public ScopedUriScopeResolver(boolean fUseScopeInConfig) {
        this.f_fUseScopeInConfig = fUseScopeInConfig;
    }

    @Override
    public String resolveScopeName(String sConfigURI, ClassLoader loader, String sScopeName) {
        URI uri = URI.create(sConfigURI);
        if (SCOPED_SCHEME.equals(uri.getScheme())) {
            Object sScope = uri.getAuthority();
            String sPath = uri.getPath();
            if (sPath != null && !sPath.isBlank()) {
                sScope = URLDecoder.decode((String)sScope, StandardCharsets.UTF_8) + URLDecoder.decode(sPath, StandardCharsets.UTF_8);
            }
            return URLDecoder.decode((String)sScope, StandardCharsets.UTF_8);
        }
        return sScopeName;
    }

    @Override
    public String resolveURI(String sConfigURI) {
        URI uri = URI.create(sConfigURI);
        if (SCOPED_SCHEME.equals(uri.getScheme())) {
            String sQuery = uri.getQuery();
            String sFragment = uri.getFragment();
            if (sFragment != null) {
                return URLDecoder.decode(sQuery, StandardCharsets.UTF_8) + "#" + URLDecoder.decode(sFragment, StandardCharsets.UTF_8);
            }
            return URLDecoder.decode(sQuery, StandardCharsets.UTF_8);
        }
        return sConfigURI;
    }

    @Override
    public boolean useScopeInConfig() {
        return this.f_fUseScopeInConfig;
    }

    public static String encodeScope(String sConfigURI, String sScope) {
        if (sConfigURI == null || sConfigURI.trim().isEmpty()) {
            throw new IllegalArgumentException("Config URI cannot be null or blank");
        }
        if (sScope == null || sScope.trim().isEmpty()) {
            return sConfigURI;
        }
        return String.format(SCOPED_PATTERN, SCOPED_SCHEME, URLEncoder.encode(sScope, StandardCharsets.UTF_8), URLEncoder.encode(sConfigURI));
    }
}

