/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net;

import com.oracle.coherence.common.base.Logger;
import com.tangosol.internal.net.NamedMapCollection;
import com.tangosol.internal.net.SessionNamedCache;
import com.tangosol.net.NamedMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;

public abstract class NamedMapValuesCollection<K, V>
implements NamedMapCollection<K, V, V>,
Collection<V> {
    protected final String m_sName;
    protected final NamedMap<K, V> m_cache;

    public NamedMapValuesCollection(String sName, NamedMap<K, V> cache) {
        this.m_sName = Objects.requireNonNull(sName);
        this.m_cache = Objects.requireNonNull(cache);
        if (sName.isEmpty()) {
            throw new IllegalArgumentException("the name parameter cannot be an empty String");
        }
    }

    @Override
    public NamedMap<K, V> getNamedMap() {
        return this.m_cache;
    }

    @Override
    public String getName() {
        return this.m_sName;
    }

    @Override
    public boolean isDestroyed() {
        return this.m_cache.isDestroyed();
    }

    @Override
    public boolean isActive() {
        return this.m_cache.isActive();
    }

    @Override
    public boolean isReleased() {
        return this.m_cache.isReleased();
    }

    @Override
    public void destroy() {
        this.destroy(this.m_cache);
    }

    @Override
    public void release() {
        this.release(this.m_cache);
    }

    @Override
    public int size() {
        return this.m_cache.size();
    }

    @Override
    public boolean isEmpty() {
        return this.m_cache.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.m_cache.containsValue(o);
    }

    @Override
    public Iterator<V> iterator() {
        return this.m_cache.values().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.m_cache.values().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.m_cache.values().toArray(a);
    }

    @Override
    public boolean add(V v) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (this.equals(c)) {
            return true;
        }
        return this.m_cache.values().containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends V> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.m_cache.clear();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NamedMapValuesCollection that = (NamedMapValuesCollection)o;
        return Objects.equals(this.m_sName, that.m_sName) && Objects.equals(this.m_cache, that.m_cache);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.m_sName, this.m_cache);
    }

    protected void assertNotNull(V oValue) {
        if (oValue == null) {
            throw new NullPointerException("this collection does not accept null values");
        }
    }

    public void assertNotSameCollection(Collection<?> c, String sMsg) {
        if (this.equals(Objects.requireNonNull(c))) {
            throw new IllegalArgumentException(sMsg);
        }
        if (c instanceof NamedMapCollection) {
            NamedMap map = ((NamedMapCollection)c).getNamedMap();
            if (this.m_cache.equals(map)) {
                throw new IllegalArgumentException(sMsg);
            }
            if (map instanceof SessionNamedCache) {
                map = ((SessionNamedCache)map).getInternalNamedCache();
            }
            if (this.m_cache.equals(map)) {
                throw new IllegalArgumentException(sMsg);
            }
        }
    }

    protected void release(NamedMap<?, ?> map) {
        if (map != null && !map.isReleased() && !map.isDestroyed()) {
            try {
                map.release();
            }
            catch (Exception e) {
                Logger.err(e);
            }
        }
    }

    protected void destroy(NamedMap<?, ?> map) {
        if (map != null && !map.isReleased() && !map.isDestroyed()) {
            try {
                map.destroy();
            }
            catch (Exception e) {
                Logger.err(e);
            }
        }
    }
}

