/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net;

import com.tangosol.coherence.config.ParameterList;
import com.tangosol.coherence.config.builder.InetAddressRangeFilterBuilder;
import com.tangosol.coherence.config.builder.ParameterizedBuilder;
import com.tangosol.coherence.config.builder.ServiceFailurePolicyBuilder;
import com.tangosol.config.expression.ParameterResolver;
import com.tangosol.net.AddressProviderFactory;
import com.tangosol.net.ConfigurableAddressProviderFactory;
import com.tangosol.net.InetAddressHelper;
import com.tangosol.net.ServiceFailurePolicy;
import com.tangosol.run.xml.XmlElement;
import com.tangosol.run.xml.XmlHelper;
import com.tangosol.util.Base;
import com.tangosol.util.Filter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class LegacyXmlConfigHelper {
    @Deprecated
    public static List<String> parseFilterList(XmlElement xml) {
        ArrayList<String> list = new ArrayList<String>();
        Iterator iter = xml.getSafeElement("use-filters").getElements("filter-name");
        while (iter.hasNext()) {
            String sName = ((XmlElement)iter.next()).getString();
            if (sName.length() <= 0) continue;
            list.add(sName);
        }
        return list.size() == 0 ? Collections.EMPTY_LIST : list;
    }

    public static ServiceFailurePolicyBuilder parseServiceFailurePolicyBuilder(XmlElement xml) {
        ServiceFailurePolicyBuilder builder = null;
        String sPolicy = xml.getString().trim();
        if (sPolicy.length() != 0) {
            builder = new ServiceFailurePolicyBuilder(sPolicy, xml);
        } else if (!xml.getElementList().isEmpty()) {
            ParameterizedBuilder<ServiceFailurePolicy> bldr = LegacyXmlConfigHelper.createBuilder(xml, ServiceFailurePolicy.class);
            builder = new ServiceFailurePolicyBuilder(bldr, xml);
        }
        return builder;
    }

    @Deprecated
    public static ParameterizedBuilder<Filter> parseAuthorizedHosts(XmlElement xml) {
        XmlElement xmlCat = xml.getSafeElement("authorized-hosts");
        XmlElement xmlVal = xmlCat.getElement("host-filter");
        if (xmlVal != null && !XmlHelper.isEmpty(xmlVal)) {
            return LegacyXmlConfigHelper.createBuilder(xmlVal, Filter.class);
        }
        InetAddressRangeFilterBuilder builder = new InetAddressRangeFilterBuilder();
        Iterator iter = xmlCat.getElements("host-address");
        while (iter.hasNext()) {
            xmlVal = (XmlElement)iter.next();
            builder.addAuthorizedHostsToFilter(xmlVal.getString(), null);
        }
        iter = xmlCat.getElements("host-range");
        while (iter.hasNext()) {
            xmlVal = (XmlElement)iter.next();
            builder.addAuthorizedHostsToFilter(xmlVal.getSafeElement("from-address").getString(), xmlVal.getSafeElement("to-address").getString());
        }
        return builder;
    }

    public static InetSocketAddress parseLocalSocketAddress(XmlElement xml) {
        XmlElement xmlAddr = xml.getElement("address");
        XmlElement xmlPort = xml.getElement("port");
        if (xmlAddr == null && xmlPort == null) {
            return null;
        }
        String sAddr = xmlAddr == null ? "localhost" : xmlAddr.getString();
        int nPort = xmlPort == null ? 0 : xmlPort.getInt();
        InetAddress addr = null;
        try {
            addr = InetAddressHelper.getLocalAddress(sAddr);
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e, "the \"" + xml.getName() + "\" configuration element contains an invalid \"address\" element");
        }
        try {
            return new InetSocketAddress(addr, nPort);
        }
        catch (RuntimeException e) {
            throw Base.ensureRuntimeException(e, "the \"" + xml.getName() + "\" configuration element contains an invalid \"port\" element");
        }
    }

    public static Object createInstance(XmlElement xml, String clzName) {
        try {
            return XmlHelper.createInstance(xml, Base.getContextClassLoader(), null, null);
        }
        catch (Exception e) {
            throw Base.ensureRuntimeException(e, "Error creating " + clzName + " object." + String.valueOf(xml));
        }
    }

    public static <T> ParameterizedBuilder<T> createBuilder(XmlElement xml, final Class<T> clz) {
        final XmlElement f_xml = xml;
        final String f_sClzName = clz.getName();
        return new ParameterizedBuilder<T>(){

            @Override
            public T realize(ParameterResolver resolver, ClassLoader loader, ParameterList listParameters) {
                try {
                    return XmlHelper.createInstance(f_xml, loader, null, clz);
                }
                catch (Exception e) {
                    throw Base.ensureRuntimeException(e, "Error creating " + f_sClzName + " object." + String.valueOf(f_xml));
                }
            }
        };
    }

    public static AddressProviderFactory parseAddressProvider(XmlElement xml, Map<String, AddressProviderFactory> map) {
        return LegacyXmlConfigHelper.parseAddressProvider("address-provider", xml, map);
    }

    public static AddressProviderFactory parseAddressProvider(String sElement, XmlElement xml, Map<String, AddressProviderFactory> map) {
        boolean fEmpty;
        XmlElement xmlProvider = xml.getElement(sElement);
        boolean fMissing = xmlProvider == null;
        boolean bl = fEmpty = !fMissing && xmlProvider.isEmpty();
        if (fEmpty || fMissing) {
            ConfigurableAddressProviderFactory factory = new ConfigurableAddressProviderFactory();
            factory.setConfig(fMissing ? xml : xmlProvider);
            return factory;
        }
        String sName = xmlProvider.getString();
        AddressProviderFactory factory = map.get(sName);
        if (factory == null) {
            throw new IllegalArgumentException("Address-provider name \"" + sName + "\" is undefined:\n" + String.valueOf(xmlProvider));
        }
        return factory;
    }
}

