/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net;

import com.oracle.coherence.common.base.Converter;
import com.oracle.coherence.common.base.NonBlocking;
import com.tangosol.internal.net.AbstractFlowControl;
import java.util.concurrent.atomic.AtomicLong;

public class DebouncedFlowControl
extends AbstractFlowControl {
    private final long f_lLimitNormal;
    private final long f_lLimitExcessive;
    private final AtomicLong f_lBacklog = new AtomicLong();
    private final Converter<Long, String> f_unitFormatter;

    public DebouncedFlowControl(long lLimitNormal, long lLimitExcessive) {
        this(lLimitNormal, lLimitExcessive, null);
    }

    public DebouncedFlowControl(long lLimitNormal, long lLimitExcessive, Converter<Long, String> unitFormatter) {
        this.f_lLimitNormal = lLimitNormal;
        this.f_lLimitExcessive = lLimitExcessive;
        this.f_unitFormatter = unitFormatter == null ? Object::toString : unitFormatter;
    }

    public long getBacklog() {
        return this.f_lBacklog.get() >> 1;
    }

    public DebouncedFlowControl adjustBacklog(long c) {
        boolean fExitBacklog;
        long fBacklogged;
        long cBacklogNew;
        long lBacklogNew;
        long lBacklogOld;
        do {
            lBacklogOld = this.f_lBacklog.get();
            cBacklogNew = (lBacklogOld >> 1) + c;
            fBacklogged = lBacklogOld & 1L;
            fExitBacklog = false;
            if (cBacklogNew >= 0x3FFFFFFFFFFFFFFFL || cBacklogNew <= -4611686018427387904L) {
                throw new IllegalArgumentException("adjustment would overflow");
            }
            if (fBacklogged == 0L && cBacklogNew >= this.f_lLimitExcessive) {
                fBacklogged = 1L;
                continue;
            }
            if (fBacklogged != 1L || cBacklogNew > this.f_lLimitNormal) continue;
            fBacklogged = 0L;
            fExitBacklog = true;
        } while (!this.f_lBacklog.compareAndSet(lBacklogOld, lBacklogNew = cBacklogNew << 1 | fBacklogged));
        if (fExitBacklog) {
            this.processContinuations();
        } else if (fBacklogged == 1L && !NonBlocking.isNonBlockingCaller()) {
            this.drainBacklog(0L);
        }
        return this;
    }

    public DebouncedFlowControl incrementBacklog() {
        return this.adjustBacklog(1L);
    }

    public DebouncedFlowControl decrementBacklog() {
        return this.adjustBacklog(-1L);
    }

    public long getNormalLimit() {
        return this.f_lLimitNormal;
    }

    public long getExcessiveLimit() {
        return this.f_lLimitExcessive;
    }

    @Override
    public boolean isBacklogged() {
        return (this.f_lBacklog.get() & 1L) != 0L;
    }

    public String toString() {
        long lBacklog = this.f_lBacklog.get();
        long cBacklog = lBacklog >> 1;
        long fBacklog = lBacklog & 1L;
        return this.f_unitFormatter.convert(cBacklog) + "/" + this.f_unitFormatter.convert(this.f_lLimitExcessive) + " " + cBacklog * 100L / this.f_lLimitExcessive + "%" + (fBacklog == 0L ? " normal" : " excessive");
    }
}

