/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.net;

import com.oracle.coherence.common.base.Logger;
import com.oracle.coherence.common.util.Options;
import com.tangosol.internal.net.SessionNamedCache;
import com.tangosol.internal.net.SessionNamedTopic;
import com.tangosol.net.ConfigurableCacheFactory;
import com.tangosol.net.ExtensibleConfigurableCacheFactory;
import com.tangosol.net.NamedCache;
import com.tangosol.net.NamedCollection;
import com.tangosol.net.NamedMap;
import com.tangosol.net.Releasable;
import com.tangosol.net.Service;
import com.tangosol.net.Session;
import com.tangosol.net.ValueTypeAssertion;
import com.tangosol.net.cache.TypeAssertion;
import com.tangosol.net.events.EventDispatcher;
import com.tangosol.net.events.EventDispatcherAwareInterceptor;
import com.tangosol.net.events.EventDispatcherRegistry;
import com.tangosol.net.events.InterceptorRegistry;
import com.tangosol.net.events.application.LifecycleEvent;
import com.tangosol.net.events.internal.ConfigurableCacheFactoryDispatcher;
import com.tangosol.net.events.internal.SessionEventDispatcher;
import com.tangosol.net.options.WithClassLoader;
import com.tangosol.net.topic.NamedTopic;
import com.tangosol.util.Base;
import com.tangosol.util.RegistrationBehavior;
import com.tangosol.util.ResourceRegistry;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;

public class ConfigurableCacheFactorySession
implements Session {
    public static final String SESSION_NAME = "$SESSION$";
    private final String f_sName;
    private final ConfigurableCacheFactory f_ccf;
    private final ClassLoader f_classLoader;
    private volatile boolean m_fActivated;
    private volatile boolean m_fClosed;
    private final ConcurrentHashMap<String, ConcurrentHashMap<TypeAssertion, SessionNamedCache>> f_mapCaches;
    private final ConcurrentHashMap<String, ConcurrentHashMap<ValueTypeAssertion, SessionNamedTopic>> f_mapTopics;
    private final SessionEventDispatcher f_eventDispatcher;
    private final ResourceRegistry f_registry;
    private final String f_eventInterceptorId;

    public ConfigurableCacheFactorySession(ConfigurableCacheFactory ccf, ClassLoader loader) {
        this(ccf, loader, null);
    }

    public ConfigurableCacheFactorySession(ConfigurableCacheFactory ccf, ClassLoader loader, String sName) {
        this.f_ccf = ccf;
        this.f_classLoader = loader == null ? Base.ensureClassLoader(null) : loader;
        this.f_sName = sName;
        this.f_mapCaches = new ConcurrentHashMap();
        this.f_mapTopics = new ConcurrentHashMap();
        this.f_eventDispatcher = new SessionEventDispatcher(this);
        this.f_registry = this.f_ccf.getResourceRegistry();
        if (this.f_sName != null && !"".equals(sName)) {
            ResourceRegistry registry = ccf.getResourceRegistry();
            String sNameExisting = registry.getResource(String.class, SESSION_NAME);
            if (sNameExisting == null) {
                registry.registerResource(String.class, SESSION_NAME, this.f_sName);
            } else if (!sNameExisting.equals(this.f_sName)) {
                throw new IllegalStateException("Failed to register Session name \"" + this.f_sName + "\" with ConfigurableCacheFactory, a different Session name \"" + sNameExisting + "\" has already been registered. This could be caused by multiple sessions configured with the same scope name and configuration URI");
            }
        }
        if (this.f_ccf instanceof ExtensibleConfigurableCacheFactory) {
            EventDispatcherRegistry dispatcherReg = this.f_registry.getResource(EventDispatcherRegistry.class);
            dispatcherReg.registerEventDispatcher(this.f_eventDispatcher);
            this.f_eventInterceptorId = this.f_ccf.getInterceptorRegistry().registerEventInterceptor(new LifecycleInterceptor());
        } else {
            this.f_eventInterceptorId = null;
        }
    }

    @Override
    public <K, V> NamedMap<K, V> getMap(String sName, NamedMap.Option ... options) {
        return this.getCache(sName, options);
    }

    @Override
    public <K, V> NamedCache<K, V> getCache(String sName, NamedMap.Option ... options) {
        if (!this.m_fClosed) {
            this.f_registry.registerResource(NamedCacheReferenceCounter.class, sName, NamedCacheReferenceCounter::new, RegistrationBehavior.IGNORE, null);
            ConcurrentHashMap mapCachesByTypeAssertion = this.f_mapCaches.computeIfAbsent(sName, any -> new ConcurrentHashMap());
            Options<NamedMap.Option> optionSet = Options.from(NamedMap.Option.class, options);
            TypeAssertion typeAssertion = optionSet.get(TypeAssertion.class);
            ClassLoader loader = optionSet.get(WithClassLoader.class, WithClassLoader.using(this.f_classLoader)).getClassLoader();
            return mapCachesByTypeAssertion.compute(typeAssertion, (key, value) -> {
                if (value != null && !value.isDestroyed() && !value.isReleased() && value.getContextClassLoader() == loader) {
                    return value;
                }
                NamedCache cacheUnderlying = this.f_ccf.ensureTypedCache(sName, loader, typeAssertion);
                SessionNamedCache cache = new SessionNamedCache(this, cacheUnderlying, loader, typeAssertion);
                this.f_registry.getResource(NamedCacheReferenceCounter.class, sName).incrementAndGet();
                return cache;
            });
        }
        throw new IllegalStateException("Session is closed");
    }

    @Override
    public <V> NamedTopic<V> getTopic(String sName, NamedCollection.Option ... options) {
        if (!this.m_fClosed) {
            this.f_registry.registerResource(NamedTopicReferenceCounter.class, sName, NamedTopicReferenceCounter::new, RegistrationBehavior.IGNORE, null);
            ConcurrentHashMap mapTopicsByTypeAssertion = this.f_mapTopics.computeIfAbsent(sName, any -> new ConcurrentHashMap());
            Options<NamedCollection.Option> optionSet = Options.from(NamedCollection.Option.class, options);
            ValueTypeAssertion typeAssertion = optionSet.get(ValueTypeAssertion.class);
            ClassLoader loader = optionSet.get(WithClassLoader.class, WithClassLoader.using(this.f_classLoader)).getClassLoader();
            return mapTopicsByTypeAssertion.compute(typeAssertion, (key, value) -> {
                if (value != null && !value.isDestroyed() && !value.isReleased() && value.getContextClassLoader() == loader) {
                    return value;
                }
                NamedTopic topicUnderlying = this.f_ccf.ensureTopic(sName, loader, typeAssertion);
                SessionNamedTopic topic = new SessionNamedTopic(this, topicUnderlying, loader, typeAssertion);
                this.f_registry.getResource(NamedTopicReferenceCounter.class, sName).incrementAndGet();
                return topic;
            });
        }
        throw new IllegalStateException("Session " + this.getName() + " is closed");
    }

    @Override
    public void close(NamedCollection col) {
        if (col instanceof SessionNamedCache) {
            this.onClose((SessionNamedCache)col);
        } else if (col instanceof SessionNamedTopic) {
            this.onClose((SessionNamedTopic)col);
        }
    }

    @Override
    public void destroy(NamedCollection col) {
        if (col instanceof SessionNamedCache) {
            this.onDestroy((SessionNamedCache)col);
        } else if (col instanceof SessionNamedTopic) {
            this.onDestroy((SessionNamedTopic)col);
        }
    }

    @Override
    public synchronized void activate() {
        if (this.m_fActivated) {
            return;
        }
        this.f_eventDispatcher.dispatchStarting();
        this.m_fActivated = true;
        this.f_eventDispatcher.dispatchStarted();
    }

    @Override
    public synchronized void close() throws Exception {
        if (!this.m_fClosed) {
            Logger.info("Closing Session " + this.getName());
            this.m_fClosed = true;
            this.f_eventDispatcher.dispatchStopping();
            this.f_mapCaches.values().stream().flatMap(mapCachesByAssertion -> mapCachesByAssertion.values().stream()).forEach(SessionNamedCache::close);
            this.f_mapCaches.clear();
            this.f_mapTopics.values().stream().flatMap(mapTopicsByAssertion -> mapTopicsByAssertion.values().stream()).forEach(Releasable::close);
            this.f_mapTopics.clear();
            this.f_eventDispatcher.dispatchStopped();
            if (this.f_eventInterceptorId != null) {
                this.f_ccf.getInterceptorRegistry().unregisterEventInterceptor(this.f_eventInterceptorId);
            }
            Logger.info("Closed Session " + this.getName());
        }
    }

    @Override
    public ResourceRegistry getResourceRegistry() {
        return this.f_registry;
    }

    @Override
    public InterceptorRegistry getInterceptorRegistry() {
        return this.f_ccf.getInterceptorRegistry();
    }

    @Override
    public boolean isCacheActive(String sCacheName, ClassLoader loader) {
        return this.f_ccf.isCacheActive(sCacheName, loader);
    }

    @Override
    public boolean isMapActive(String sMapName, ClassLoader loader) {
        return this.f_ccf.isCacheActive(sMapName, loader);
    }

    @Override
    public boolean isTopicActive(String sTopicName, ClassLoader loader) {
        return this.f_ccf.isTopicActive(sTopicName, loader);
    }

    @Override
    public String getName() {
        return this.f_sName;
    }

    @Override
    public String getScopeName() {
        return this.f_ccf.getScopeName();
    }

    @Override
    public boolean isActive() {
        return !this.m_fClosed;
    }

    @Override
    public Service getService(String sServiceName) {
        return this.f_ccf.ensureService(sServiceName);
    }

    public ConfigurableCacheFactory getConfigurableCacheFactory() {
        return this.f_ccf;
    }

    <V> void onClose(SessionNamedTopic<V> topic) {
        this.dropNamedTopic(topic);
        topic.onClosing();
        if (this.f_registry.getResource(NamedTopicReferenceCounter.class, topic.getName()).decrementAndGet() == 0) {
            this.f_ccf.releaseTopic(topic.getInternalNamedTopic());
        }
        topic.onClosed();
    }

    <V> void onDestroy(SessionNamedTopic<V> topic) {
        this.dropNamedTopic(topic);
        topic.onDestroying();
        this.f_registry.getResource(NamedTopicReferenceCounter.class, topic.getName()).reset();
        this.f_ccf.destroyTopic(topic.getInternalNamedTopic());
        topic.onDestroyed();
    }

    private <V> void dropNamedTopic(SessionNamedTopic<V> namedTopic) {
        ConcurrentHashMap<ValueTypeAssertion, SessionNamedTopic> mapTopicsByTypeAssertion = this.f_mapTopics.get(namedTopic.getName());
        if (mapTopicsByTypeAssertion != null) {
            mapTopicsByTypeAssertion.remove(namedTopic.getTypeAssertion());
        }
    }

    <K, V> void onClose(SessionNamedCache<K, V> namedCache) {
        this.dropNamedCache(namedCache);
        namedCache.onClosing();
        if (this.f_registry.getResource(NamedCacheReferenceCounter.class, namedCache.getCacheName()).decrementAndGet() == 0) {
            this.f_ccf.releaseCache(namedCache.getInternalNamedCache());
        }
        namedCache.onClosed();
    }

    <K, V> void onDestroy(SessionNamedCache<K, V> namedCache) {
        this.dropNamedCache(namedCache);
        namedCache.onDestroying();
        this.f_registry.getResource(NamedCacheReferenceCounter.class, namedCache.getCacheName()).reset();
        this.f_ccf.destroyCache(namedCache.getInternalNamedCache());
        namedCache.onDestroyed();
    }

    <K, V> void dropNamedCache(SessionNamedCache<K, V> namedCache) {
        ConcurrentHashMap<TypeAssertion, SessionNamedCache> mapCachesByTypeAssertion = this.f_mapCaches.get(namedCache.getCacheName());
        if (mapCachesByTypeAssertion != null) {
            mapCachesByTypeAssertion.remove(namedCache.getTypeAssertion());
        }
    }

    protected boolean isClosed() {
        return this.m_fClosed;
    }

    private class LifecycleInterceptor
    implements EventDispatcherAwareInterceptor<LifecycleEvent> {
        private LifecycleInterceptor() {
        }

        @Override
        public void introduceEventDispatcher(String sIdentifier, EventDispatcher dispatcher) {
            if (dispatcher instanceof ConfigurableCacheFactoryDispatcher) {
                dispatcher.addEventInterceptor(ConfigurableCacheFactorySession.this.getName(), this);
            }
        }

        @Override
        public void onEvent(LifecycleEvent event) {
            if (event.getType() == LifecycleEvent.Type.DISPOSING) {
                try {
                    ConfigurableCacheFactorySession.this.close();
                }
                catch (Exception e) {
                    Logger.err(e);
                }
            }
        }
    }

    protected static class NamedCacheReferenceCounter
    extends ReferenceCounter {
        protected NamedCacheReferenceCounter() {
        }
    }

    protected static class NamedTopicReferenceCounter
    extends ReferenceCounter {
        protected NamedTopicReferenceCounter() {
        }
    }

    protected static class ReferenceCounter {
        private final AtomicInteger f_count = new AtomicInteger(0);

        public int get() {
            return this.f_count.get();
        }

        public int incrementAndGet() {
            return this.f_count.incrementAndGet();
        }

        public int decrementAndGet() {
            return this.f_count.decrementAndGet();
        }

        public void reset() {
            this.f_count.set(0);
        }
    }
}

