/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.metrics;

import com.oracle.coherence.common.base.Exceptions;
import com.oracle.coherence.common.base.Logger;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.tangosol.coherence.config.Config;
import com.tangosol.internal.metrics.DefaultMetricRegistry;
import com.tangosol.internal.metrics.MetricsFormatter;
import com.tangosol.net.metrics.MBeanMetric;
import com.tangosol.util.SimpleMapEntry;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPOutputStream;

public class MetricsHttpHandler
implements HttpHandler {
    protected static final String PROP_EXTENDED = "coherence.metrics.extended";
    protected static final boolean f_fAlwaysUseExtended = Boolean.parseBoolean(System.getProperty("coherence.metrics.extended", "false"));
    public static final String PROP_USE_LEGACY_NAMES = "coherence.metrics.legacy.names";
    public static final String PROP_USE_MP_NAMES = "coherence.metrics.mp.names";
    public static final String PROP_USE_DOT_NAMES = "coherence.metrics.dot.names";
    public static final String APPLICATION_JSON = "application/json";
    public static final String TEXT_PLAIN = "text/plain";
    public static final String WILDCARD = "*/*";
    private static final byte[] EMPTY_BODY = new byte[0];
    protected Format f_format;
    private String m_sPath;

    public MetricsHttpHandler() {
        this(MetricsHttpHandler.defaultFormat());
    }

    protected MetricsHttpHandler(Format format) {
        this.f_format = format;
    }

    public Format getFormat() {
        return this.f_format;
    }

    public String getPath() {
        return this.m_sPath;
    }

    public void setPath(String sPath) {
        this.m_sPath = sPath;
    }

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        try {
            URI requestURI = exchange.getRequestURI();
            Map<String, List<String>> mapQuery = this.getQueryParameters(requestURI);
            Headers headers = exchange.getRequestHeaders();
            String sSuffix = null;
            String sName = null;
            List<String> listExtended = mapQuery.remove("extended");
            boolean fExtended = f_fAlwaysUseExtended || listExtended != null && !listExtended.isEmpty() && Boolean.parseBoolean(listExtended.get(0));
            String sPath = requestURI.getPath();
            if (sPath.equals(this.getPath()) || sPath.startsWith(this.getPath() + "/")) {
                if (sPath.endsWith(".txt")) {
                    sSuffix = ".txt";
                    sPath = sPath.substring(0, sPath.length() - 4);
                } else if (sPath.endsWith(".json")) {
                    sSuffix = ".json";
                    sPath = sPath.substring(0, sPath.length() - 5);
                }
                String[] asSegment = sPath.split("/");
                if (asSegment.length > 4 || asSegment.length == 4 && asSegment[3].length() != 0) {
                    MetricsHttpHandler.send(exchange, 404);
                    return;
                }
                if (asSegment.length >= 3) {
                    sName = asSegment[2];
                }
            } else {
                MetricsHttpHandler.send(exchange, 404);
                return;
            }
            MetricPredicate predicate = this.createPredicate(sName, mapQuery);
            MetricsFormatter formatter = ".txt".equals(sSuffix) ? this.getPrometheusMetrics(predicate, fExtended) : (".json".equals(sSuffix) ? this.getJsonMetrics(predicate, fExtended) : this.getFormatterForAcceptedType(headers, predicate, fExtended));
            if (formatter == null) {
                MetricsHttpHandler.send(exchange, 415);
                return;
            }
            boolean fGzip = false;
            String sEncoding = headers.getFirst("Accept-Encoding");
            if (sEncoding != null) {
                fGzip = Arrays.stream(sEncoding.split(",")).map(String::trim).anyMatch("gzip"::equalsIgnoreCase);
            }
            try (OutputStream os = exchange.getResponseBody();){
                exchange.getResponseHeaders().set("Content-Type", formatter.getContentType());
                if (fGzip) {
                    this.sendGZippedMetrics(exchange, os, formatter);
                } else {
                    this.sendMetrics(exchange, () -> os, formatter);
                }
            }
        }
        catch (Throwable t) {
            Logger.err(t);
            exchange.sendResponseHeaders(500, -1L);
        }
    }

    private Map<String, List<String>> getQueryParameters(URI uri) {
        String sQuery = uri.getQuery();
        if (sQuery == null || sQuery.length() == 0) {
            return Collections.emptyMap();
        }
        return Arrays.stream(sQuery.split("&")).map(this::splitQueryParameter).filter(e -> e.getValue() != null).collect(Collectors.groupingBy(Map.Entry::getKey, LinkedHashMap::new, Collectors.mapping(Map.Entry::getValue, Collectors.toList())));
    }

    private Map.Entry<String, String> splitQueryParameter(String sParam) {
        try {
            int nIndex = sParam.indexOf("=");
            String sKey = nIndex > 0 ? sParam.substring(0, nIndex) : sParam;
            String sValue = nIndex > 0 && sParam.length() > nIndex + 1 ? sParam.substring(nIndex + 1) : null;
            String sDecoded = sValue == null ? null : URLDecoder.decode(sValue, "UTF-8");
            return new SimpleMapEntry<String, String>(URLDecoder.decode(sKey, "UTF-8"), sDecoded);
        }
        catch (UnsupportedEncodingException e) {
            throw Exceptions.ensureRuntimeException(e);
        }
    }

    private MetricsFormatter getFormatterForAcceptedType(Headers headers, Predicate<MBeanMetric> predicate, boolean fExtended) {
        Object listAccept = headers.get("Accept");
        if (listAccept == null) {
            return this.getPrometheusMetrics(predicate, fExtended);
        }
        Iterator iterator = listAccept.iterator();
        while (iterator.hasNext()) {
            String[] asType;
            String sType = (String)iterator.next();
            for (String sAccept : asType = sType.split(",")) {
                int nIndex = sAccept.indexOf(59);
                if (nIndex >= 0) {
                    sAccept = sAccept.substring(0, nIndex);
                }
                switch (sAccept.trim()) {
                    case "application/json": {
                        return this.getJsonMetrics(predicate, fExtended);
                    }
                    case "text/plain": 
                    case "*/*": {
                        return this.getPrometheusMetrics(predicate, fExtended);
                    }
                }
            }
        }
        return null;
    }

    private void sendMetrics(HttpExchange exchange, StreamSupplier supplier, MetricsFormatter formatter) throws IOException {
        exchange.sendResponseHeaders(200, 0L);
        try (OutputStreamWriter writer = new OutputStreamWriter(supplier.get());){
            formatter.writeMetrics(writer);
            ((Writer)writer).flush();
        }
    }

    private void sendGZippedMetrics(HttpExchange exchange, OutputStream os, MetricsFormatter formatter) throws IOException {
        exchange.getResponseHeaders().set("Content-Encoding", "gzip");
        this.sendMetrics(exchange, () -> new GZIPOutputStream(os), formatter);
    }

    private static void send(HttpExchange t, int status) {
        try {
            t.sendResponseHeaders(status, 0L);
            try (OutputStream os = t.getResponseBody();){
                os.write(EMPTY_BODY);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected MetricsFormatter getPrometheusMetrics(Predicate<MBeanMetric> predicate, boolean fExtended) {
        return new PrometheusFormatter(fExtended, this.f_format, this.getMetrics(predicate));
    }

    protected MetricsFormatter getJsonMetrics(Predicate<MBeanMetric> predicate, boolean fExtended) {
        return new JsonFormatter(fExtended, this.getMetrics(predicate));
    }

    static Format defaultFormat() {
        if (Config.getBoolean(PROP_USE_MP_NAMES, false)) {
            return Format.Microprofile;
        }
        if (Config.getBoolean(PROP_USE_DOT_NAMES, false)) {
            return Format.DotDelimited;
        }
        if (Config.getBoolean(PROP_USE_LEGACY_NAMES, false)) {
            return Format.Legacy;
        }
        return Format.Default;
    }

    protected List<MBeanMetric> getMetrics(Predicate<MBeanMetric> predicate) {
        try {
            Stream<Map.Entry<MBeanMetric.Identifier, MBeanMetric>> stream = DefaultMetricRegistry.getRegistry().stream();
            if (predicate != null) {
                stream = stream.filter(e -> predicate.test((MBeanMetric)e.getValue()));
            }
            return stream.map(Map.Entry::getValue).collect(Collectors.toList());
        }
        catch (Throwable t) {
            Logger.err("Exception in MetricsResource.getMetrics():", t);
            throw t;
        }
    }

    private MetricPredicate createPredicate(String sName, Map<String, List<String>> mapTags) {
        if ((sName == null || sName.isEmpty()) && mapTags.isEmpty()) {
            return null;
        }
        return new MetricPredicate(sName, mapTags);
    }

    public static enum Format {
        Default,
        DotDelimited,
        Legacy,
        Microprofile;

    }

    protected static class MetricPredicate
    implements Predicate<MBeanMetric> {
        private final String f_sName;
        private final Map<String, String> f_mapTags;

        public MetricPredicate(String sName, Map<String, List<String>> mapTags) {
            this.f_sName = sName;
            this.f_mapTags = mapTags.entrySet().stream().filter(e -> !((String)e.getKey()).equalsIgnoreCase("extended")).collect(Collectors.toMap(Map.Entry::getKey, e -> (String)((List)e.getValue()).get(0)));
        }

        @Override
        public boolean test(MBeanMetric metric) {
            return this.hasValue(metric) && this.nameMatches(metric) && this.tagsMatch(metric);
        }

        private boolean hasValue(MBeanMetric metric) {
            return metric.getValue() != null;
        }

        private boolean nameMatches(MBeanMetric metric) {
            return this.f_sName == null || metric.getName().startsWith(this.f_sName);
        }

        private boolean tagsMatch(MBeanMetric metric) {
            if (this.f_mapTags == null || this.f_mapTags.isEmpty()) {
                return true;
            }
            Map<String, String> mapTags = metric.getTags();
            for (String sKey : this.f_mapTags.keySet()) {
                if (this.f_mapTags.get(sKey).equals(mapTags.get(sKey))) continue;
                return false;
            }
            return true;
        }
    }

    @FunctionalInterface
    private static interface StreamSupplier {
        public OutputStream get() throws IOException;
    }

    protected static class PrometheusFormatter
    implements MetricsFormatter {
        private final boolean f_fExtended;
        private final Format f_format;
        private final List<MBeanMetric> f_listMetrics;

        public PrometheusFormatter(boolean fExtended, Format format, List<MBeanMetric> listMetrics) {
            this.f_fExtended = fExtended;
            this.f_format = format;
            this.f_listMetrics = listMetrics;
        }

        @Override
        public String getContentType() {
            return MetricsHttpHandler.TEXT_PLAIN;
        }

        @Override
        public void writeMetrics(Writer writer) throws IOException {
            for (MBeanMetric metric : this.f_listMetrics) {
                this.writeMetric(writer, metric);
                writer.flush();
            }
        }

        private void writeMetric(Writer writer, MBeanMetric metric) throws IOException {
            Object oValue = metric.getValue();
            if (oValue != null) {
                MBeanMetric.Identifier id = metric.getIdentifier();
                Map<String, String> mapTag = id.getPrometheusTags();
                String sName = switch (this.f_format.ordinal()) {
                    case 2 -> id.getLegacyName();
                    case 3 -> id.getMicroprofileName();
                    case 1 -> id.getFormattedName();
                    default -> id.getFormattedName().replaceAll("\\.", "_");
                };
                if (this.f_fExtended) {
                    this.writeType(writer, sName);
                    this.writeHelp(writer, sName, metric.getDescription());
                }
                writer.append(sName);
                this.writeTags(writer, mapTag);
                writer.append(' ').append(oValue.toString()).append('\n');
            }
        }

        private void writeType(Writer writer, String sName) throws IOException {
            writer.append("# TYPE ").append(sName.trim()).append(" gauge\n");
        }

        private void writeHelp(Writer writer, String sName, String sDescription) throws IOException {
            if (sDescription != null && sDescription.length() > 0) {
                writer.append("# HELP ").append(sName).append(' ').append(sDescription).append('\n');
            }
        }

        private void writeTags(Writer writer, Map<String, String> mapTags) throws IOException {
            if (!mapTags.isEmpty()) {
                writer.write(123);
                Iterator<Map.Entry<String, String>> iterator = mapTags.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<String, String> tag = iterator.next();
                    writer.append(tag.getKey()).append("=\"").append(tag.getValue()).append('\"');
                    if (!iterator.hasNext()) continue;
                    writer.append(", ");
                }
                writer.write(125);
            }
        }
    }

    protected static class JsonFormatter
    implements MetricsFormatter {
        private final boolean f_fExtended;
        private final List<MBeanMetric> f_metrics;

        public JsonFormatter(boolean fExtended, List<MBeanMetric> metrics) {
            this.f_fExtended = fExtended;
            this.f_metrics = metrics;
        }

        @Override
        public String getContentType() {
            return MetricsHttpHandler.APPLICATION_JSON;
        }

        @Override
        public void writeMetrics(Writer writer) throws IOException {
            writer.write(91);
            boolean separator = false;
            for (MBeanMetric metric : this.f_metrics) {
                separator = this.writeMetric(writer, metric, separator) || separator;
            }
            writer.write(93);
        }

        private boolean writeMetric(Writer writer, MBeanMetric metric, boolean fSeparator) throws IOException {
            Object oValue = metric.getValue();
            if (oValue != null) {
                MBeanMetric.Identifier id = metric.getIdentifier();
                if (fSeparator) {
                    writer.write(44);
                }
                writer.write(123);
                writer.write("\"name\":\"");
                writer.write(id.getName());
                writer.write("\",");
                this.writeTags(writer, id.getTags());
                writer.write("\"scope\":\"");
                writer.write(id.getScope().name());
                writer.write("\",");
                writer.write("\"value\":");
                if (oValue instanceof Number || oValue instanceof Boolean) {
                    writer.write(String.valueOf(oValue));
                } else {
                    writer.write(34);
                    writer.write(String.valueOf(oValue));
                    writer.write(34);
                }
                String sDesc = metric.getDescription();
                if (this.f_fExtended && sDesc != null && sDesc.length() > 0) {
                    writer.write(44);
                    writer.write("\"description\":\"");
                    writer.write(sDesc);
                    writer.write(34);
                }
                writer.write(125);
                return true;
            }
            return false;
        }

        private void writeTags(Writer writer, Map<String, String> mapTags) throws IOException {
            if (!mapTags.isEmpty()) {
                String sTags = mapTags.entrySet().stream().map(e -> "\"" + (String)e.getKey() + "\":\"" + (String)e.getValue() + "\"").collect(Collectors.joining(","));
                writer.write("\"tags\":{");
                writer.write(sTags);
                writer.write("},");
            }
        }
    }
}

