/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.metrics;

import com.oracle.coherence.common.collections.ConcurrentHashMap;
import com.tangosol.net.metrics.MBeanMetric;
import com.tangosol.net.metrics.MetricsRegistryAdapter;
import java.util.Comparator;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class DefaultMetricRegistry {
    private static final DefaultMetricRegistry INSTANCE = new DefaultMetricRegistry();
    private static final MetricComparator METRIC_COMPARATOR = new MetricComparator();
    private Map<MBeanMetric.Identifier, MBeanMetric> f_mapMetric = new ConcurrentHashMap<MBeanMetric.Identifier, MBeanMetric>();

    DefaultMetricRegistry() {
    }

    public static DefaultMetricRegistry getRegistry() {
        return INSTANCE;
    }

    public void register(MBeanMetric metric) {
        this.f_mapMetric.put(metric.getIdentifier(), metric);
    }

    public void remove(MBeanMetric.Identifier identifier) {
        this.f_mapMetric.remove(identifier);
    }

    public MBeanMetric getMetric(MBeanMetric.Identifier identifier) {
        return this.f_mapMetric.get(identifier);
    }

    public Stream<Map.Entry<MBeanMetric.Identifier, MBeanMetric>> getMetrics(String sName) {
        return this.f_mapMetric.entrySet().stream().filter(e -> ((MBeanMetric.Identifier)e.getKey()).getName().equals(sName));
    }

    public Stream<Map.Entry<MBeanMetric.Identifier, MBeanMetric>> getMetrics(Pattern pattern) {
        return this.f_mapMetric.entrySet().stream().filter(e -> pattern.matcher(((MBeanMetric.Identifier)e.getKey()).getName()).matches());
    }

    public Stream<Map.Entry<MBeanMetric.Identifier, MBeanMetric>> stream() {
        return this.f_mapMetric.entrySet().stream().sorted(METRIC_COMPARATOR);
    }

    public static class MetricComparator
    implements Comparator<Map.Entry<MBeanMetric.Identifier, MBeanMetric>> {
        @Override
        public int compare(Map.Entry<MBeanMetric.Identifier, MBeanMetric> o1, Map.Entry<MBeanMetric.Identifier, MBeanMetric> o2) {
            return o1.getKey().compareTo(o2.getKey());
        }
    }

    public static class Adapter
    implements MetricsRegistryAdapter {
        @Override
        public void register(MBeanMetric metric) {
            DefaultMetricRegistry.getRegistry().register(metric);
        }

        @Override
        public void remove(MBeanMetric.Identifier identifier) {
            DefaultMetricRegistry.getRegistry().remove(identifier);
        }
    }
}

