/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.management.resources;

import com.tangosol.internal.http.HttpRequest;
import com.tangosol.internal.http.RequestRouter;
import com.tangosol.internal.http.Response;
import com.tangosol.internal.management.EntityMBeanResponse;
import com.tangosol.internal.management.VersionUtils;
import com.tangosol.internal.management.resources.AbstractManagementResource;
import com.tangosol.internal.management.resources.VersionResource;
import com.tangosol.util.Filter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public class VersionsResource
extends AbstractManagementResource {
    private final Supplier<Set<String>> f_supplierClusters;

    public VersionsResource(Supplier<Set<String>> f_supplierClusters) {
        this.f_supplierClusters = f_supplierClusters;
    }

    @Override
    public void addRoutes(RequestRouter router, String sPathRoot) {
        router.addGet(sPathRoot, this::get);
        router.addRoutes(sPathRoot + "/12.2.1.4.0", new VersionResource(this.f_supplierClusters));
        router.addRoutes(sPathRoot + "/latest", new VersionResource(this.f_supplierClusters));
    }

    public Response get(HttpRequest request) {
        String sIncludeFields = request.getFirstQueryParameter("fields");
        String sExcludeFields = request.getFirstQueryParameter("excludeFields");
        Filter<String> propertiesFilter = this.getAttributesFilter(sIncludeFields, sExcludeFields);
        Filter<String> linksFilter = this.getLinksFilter(request);
        EntityMBeanResponse mBeanResponse = new EntityMBeanResponse(request, linksFilter);
        ArrayList<Map<String, Object>> items = new ArrayList<Map<String, Object>>();
        mBeanResponse.addSelfResourceLinks(this.getCurrentUri(request));
        mBeanResponse.addResourceLink("current", VersionsResource.getSubUri(this.getCurrentUri(request), "12.2.1.4.0"));
        items.add(this.getVersion(request, "12.2.1.4.0", propertiesFilter, linksFilter));
        mBeanResponse.setEntities(items);
        return this.response(mBeanResponse);
    }

    private Map<String, Object> getVersion(HttpRequest request, String sVersion, Filter<String> filterProps, Filter<String> filterLinks) {
        EntityMBeanResponse response = new EntityMBeanResponse(request, filterLinks);
        response.setEntity(new LinkedHashMap<String, Object>(VersionUtils.getVersion(sVersion, true, "active", filterProps)));
        response.addSelfResourceLinks(VersionsResource.getSubUri(this.getCurrentUri(request), sVersion));
        return response.toJson();
    }
}

