/*
 * Decompiled with CFR 0.152.
 */
package com.tangosol.internal.management.resources;

import com.tangosol.internal.http.HttpRequest;
import com.tangosol.internal.http.RequestRouter;
import com.tangosol.internal.http.Response;
import com.tangosol.internal.management.EntityMBeanResponse;
import com.tangosol.internal.management.VersionUtils;
import com.tangosol.internal.management.resources.AbstractManagementResource;
import com.tangosol.internal.management.resources.ClustersResource;
import com.tangosol.util.Filter;
import java.util.LinkedHashMap;
import java.util.Set;
import java.util.function.Supplier;

public class VersionResource
extends AbstractManagementResource {
    private final Supplier<Set<String>> f_supplierClusters;

    public VersionResource(Supplier<Set<String>> supplier) {
        this.f_supplierClusters = supplier;
    }

    @Override
    public void addRoutes(RequestRouter router, String sPathRoot) {
        router.addGet(sPathRoot, this::get);
        router.addRoutes(sPathRoot + "/clusters", new ClustersResource(this.f_supplierClusters));
    }

    public Response get(HttpRequest request) {
        String sIncludeFields = request.getFirstQueryParameter("fields");
        String sExcludeFields = request.getFirstQueryParameter("excludeFields");
        Filter<String> propertiesFilter = this.getAttributesFilter(sIncludeFields, sExcludeFields);
        Filter<String> linksFilter = this.getLinksFilter(request);
        EntityMBeanResponse mBeanResponse = new EntityMBeanResponse(request, linksFilter);
        mBeanResponse.addParentResourceLink(this.getParentUri(request));
        mBeanResponse.addSelfResourceLinks(this.getCurrentUri(request));
        mBeanResponse.setEntity(new LinkedHashMap<String, Object>(VersionUtils.getVersion("12.2.1.4.0", true, "active", propertiesFilter)));
        return this.response(mBeanResponse);
    }
}

